#include <gtk/gtk.h>
#include <glade/glade.h>
#include "globals.h"

extern struct _app_globals app_globals;

gint
on_win_main_delete_event (GtkWidget * widget, GdkEventAny * event)
{
  shutdown_app ();
  return 0;
}

gint
on_win_main_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
  shutdown_app ();
  return 0;
}

gint
on_win_promptdel_delete_event (GtkWidget * widget, GdkEventAny * event)
{
  gtk_widget_hide (app_globals.win_promptdel);
}

gint
on_win_promptdel_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
  gtk_widget_hide (app_globals.win_promptdel);
}

gint
on_win_properties_delete_event (GtkWidget * widget, GdkEventAny * event)
{
  gtk_widget_hide (app_globals.win_properties);
}

gint
on_win_properties_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
  gtk_widget_hide (app_globals.win_properties);
}

gint
on_win_open_with_delete_event (GtkWidget * widget, GdkEventAny * event)
{
	gtk_widget_hide (app_globals.win_open_with);
}

gint
on_win_open_with_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
	gtk_widget_hide (app_globals.win_open_with);
}

gint
on_win_new_file_delete_event (GtkWidget * widget, GdkEventAny * event)
{
  hide_creation_dialog (NEW_CANCEL);
  return 1;
}

gint
on_win_new_file_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
  hide_creation_dialog (NEW_CANCEL);
  return 1;
}

void
on_menu_new_dir_activate (GtkMenuItem * menu_item)
{
  show_creation_dialog (NEW_DIR);
}

void
on_menu_open_with_activate (GtkMenuItem * menu_item)
{
  handle_open_with ();
}

void
on_menu_properties_activate (GtkMenuItem * menu_item)
{
	init_property_dialog();
}

void
on_menu_new_file_activate (GtkMenuItem * menu_item)
{
  show_creation_dialog (NEW_FILE);
}

void
on_menu_select_all_activate (GtkMenuItem * menu_item)
{
  if (app_globals.sel_all == FALSE) {
    app_globals.sel_all = TRUE;
    gtk_clist_select_all (GTK_CLIST (app_globals.clist_files));
  }
  else {
    app_globals.sel_all = FALSE;
    gtk_clist_unselect_all (GTK_CLIST (app_globals.clist_files));
  }
}

void
on_b_copy_clicked (GtkButton * button)
{
  select_for_copy ();
}

void
on_b_cut_clicked (GtkButton * button)
{
  select_for_cut ();
}

void
on_b_del_clicked (GtkButton * button)
{
  handle_delete ();
}

void
on_b_delfile_cancel_clicked (GtkButton * button)
{
  gtk_widget_hide (app_globals.win_promptdel);
}

void
on_b_delfile_ok_clicked (GtkButton * button)
{
  gtk_widget_hide (app_globals.win_promptdel);
  real_handle_delete ();
}

void
on_b_newfile_cancel_clicked (GtkButton * button)
{
  hide_creation_dialog (NEW_CANCEL);
}

void
on_b_newfile_ok_clicked (GtkButton * button)
{
  hide_creation_dialog (app_globals.newfile_state);
}

void
on_b_home_clicked (GtkButton * button)
{
  gchar *temp = getenv ("HOME");

  if (temp == NULL)
    temp = "/";

  change_directory (temp);
  display_directory ();
}

void
on_b_paste_clicked (GtkButton * button)
{
  handle_paste ();
}

void
on_b_run_with_ok_clicked (GtkButton * button)
{
  real_handle_open_with ();
}

void
on_b_run_with_cancel_clicked (GtkButton * button)
{
  gtk_widget_hide (app_globals.win_open_with);
}

void on_b_prop_cancel_clicked (GtkButton *button) {
	gtk_widget_hide (app_globals.win_properties);
}

void on_b_prop_ok_clicked (GtkButton *button) {
	apply_property_dialog();	
	gtk_widget_hide (app_globals.win_properties);
}

void
cancel_op (GtkButton * button)
{
  app_globals.cancel_op = TRUE;
}

gint
on_clist_files_button_press_event (GtkWidget * widget, GdkEventButton * event)
{
  gint row, column;
  gchar *text;

  if (event->type == GDK_2BUTTON_PRESS) {
    gtk_clist_get_selection_info (GTK_CLIST (app_globals.clist_files),
				  event->x, event->y, &row, &column);
    gtk_clist_get_text (GTK_CLIST (app_globals.clist_files), row, 1, &text);
    handle_file_verb (text, NULL);
    return FALSE;
  }
}

void 
on_menu_multiselect_enabled_toggled (GtkMenuItem *menu_item) {
	if (GTK_CHECK_MENU_ITEM(menu_item)->active == 1)
		gtk_clist_set_selection_mode(GTK_CLIST(app_globals.clist_files),
					     GTK_SELECTION_MULTIPLE);
	else
		gtk_clist_set_selection_mode(GTK_CLIST(app_globals.clist_files),
		                             GTK_SELECTION_SINGLE);
}

gint
on_win_run_cmd_delete_event (GtkWidget * widget, GdkEventAny * event)
{
	gtk_widget_hide(app_globals.win_run_cmd);
}

gint
on_win_run_cmd_destroy_event (GtkWidget * widget, GdkEventAny * event)
{
	gtk_widget_hide(app_globals.win_run_cmd);
}

void on_b_run_cmd_clicked (GtkButton *button) {
	gchar *temp = gtk_entry_get_text(GTK_ENTRY(app_globals.entry_run_cmd));
	run_cmd(temp, NULL);
	gtk_widget_hide(app_globals.win_run_cmd);
}

void on_b_run_cmd_cancel_clicked (GtkButton *button) {
	gtk_widget_hide(app_globals.win_run_cmd);
}

void
on_run_command_activate (GtkMenuItem * menu_item)
{
	gtk_widget_show(app_globals.win_run_cmd);
}
