#include <stdlib.h>
#include <glade/glade.h>
#include <gtk/gtk.h>
#include <glib.h>

#define OP_CUT 0
#define OP_COPY 1

#define EXT_MAP_PATH "/home/drrakn/ext.map"
#define APP_MAP_PATH "/home/drrakn/app.map"

#define NEW_FILE 0
#define NEW_DIR 1
#define NEW_CANCEL 2

#define MAX_TITLE_WIDTH 160

struct _app_globals
{
  GladeXML *xml;

  /* widgets */
  GtkWidget *win_main;
  GtkWidget *win_newfile;
  GtkWidget *win_curfile;
  GtkWidget *win_promptdel;
  GtkWidget *win_properties;
  GtkWidget *win_open_with;
  GtkWidget *win_run_cmd;

  GtkWidget *clist_files;
  GtkWidget *clist_runwith;
  GtkWidget *label_curfile;
  GtkWidget *label_newfile;
  GtkWidget *entry_newfile;
  GtkWidget *entry_run_cmd;

	/* property dialog widgets */
	GtkWidget* perms[12];
	GtkWidget *combo_user;
	GtkWidget *combo_group;
	GtkWidget *img_prop_type;
	GtkWidget *entry_prop_name;
	GtkWidget *label_prop_attrib;

  gchar *c_dir;			/* current directory */
	gchar *c_dir_title; /* current dir, pretty-printed to fit */

  gboolean cancel_op;		/* abort the current operation */

  /* icons */
  GdkPixmap *img_dir;
  GdkBitmap *img_dir_mask;
  GdkPixmap *img_file;
  GdkBitmap *img_file_mask;
  GdkPixmap *img_fifo;
  GdkBitmap *img_fifo_mask;
  GdkPixmap *img_dev;
  GdkBitmap *img_dev_mask;
  GdkPixmap *img_lnk;
  GdkBitmap *img_lnk_mask;

  /* .ext -> app map */
  GHashTable *ext_map;
  GHashTable *app_map;

  /* selected files */
  gboolean sel_all;		/* true if all selected */
  gint sel_op;			/* 0 for cut, 1 for copy */
  gchar *sel_path;
  GList *sel_list;

  gint newfile_state;

  int slavefd;			/* fd for our application spawning slave process */
  int slavepid;			/* so we can kill it before the parent exits */
};
