/*
linphone
Copyright (C) 2000  Simon MORLAT (simon.morlat@free.fr)

callbacks.c -- gtk callbacks, and osipua callbacks.

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "linphone.h"

#define get_core()	(uiobj->core)
#define get_main_window() (&uiobj->main_window)
#define get_uiobj()	(uiobj)
void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *about2;
  about2 = create_about2 ();
  gtk_widget_show (about2);
}

void
on_transferbutton_clicked                 (GtkButton *button ,gpointer         user_data)
{
	gchar *sipurl;

	LinphoneGnomeUI *ui=get_uiobj();
	LinphoneCore *lc=get_core();
	if (lc->call!=NULL) {
	    /* get the url to call */
	    sipurl=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.transferentry),0,-1);
	    linphone_core_transfer(lc, sipurl); 
	    g_free(sipurl);
	} else {
	    osip_trace(OSIP_INFO1,("on_transfer_button_clicked: Need an ongoing call to transfer\n"));				
	} 

}

void
on_greenbutton_clicked                 (GtkButton *button ,gpointer         user_data)
{
	LinphoneGnomeUI *ui=get_uiobj();
	LinphoneCore *lc=get_core();
	if (lc->call==NULL){
		gchar *sipurl;
		/* we have no dialog in progress */
		/* get the url to call */
		sipurl=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
		linphone_core_invite(lc,sipurl);
		g_free(sipurl);
	} else linphone_core_accept_dialog(lc,NULL);
}


void
on_redbutton_clicked                   (GtkButton *button ,gpointer         user_data)
{
    LinphoneGnomeUI *ui=get_uiobj();
	LinphoneCore *lc=get_core();
	if (lc->call!=NULL)
		linphone_core_terminate_dialog(lc,NULL);
}

gint
on_prop1_close                         (GnomeDialog     *gnomedialog,
                                        gpointer         user_data)
{	
	LinphoneMainWindow *obj=get_main_window();
	gnome_appbar_clear_stack( GNOME_APPBAR(obj->status_bar));
	return(FALSE);
}

void
on_parametres1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	LinphoneGnomeUI *ui=get_uiobj();
	linphone_property_box_init(&ui->propbox);
}



void
on_user_manual1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	gnome_help_display("manual/index.html",NULL,NULL);
}


gboolean
on_play_vol_button_release_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	int vol;
	vol=(gtk_range_get_adjustment(GTK_RANGE(widget)))->value;
	linphone_core_set_play_level(get_core(),vol);
	return FALSE;
}


gboolean
on_rec_vol_button_release_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	int vol;
	vol=(gtk_range_get_adjustment(GTK_RANGE(widget)))->value;
	linphone_core_set_rec_level(get_core(),vol);
	return FALSE;
}


void
on_prop1_help                          (GnomePropertyBox *gnomepropertybox,
                                        gint             arg1,
                                        gpointer         user_data)
{
	gnome_help_display("manual/params.html",NULL,NULL);
}




void
on_fermer1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	linphone_gnome_ui_hide(get_uiobj());
}



#if 0
/*this is when the panel size changes*/
void applet_change_pixel_size(GtkWidget *w, int size, gpointer data)
{
	GtkWidget *pixmap,*button;
	
	pixmap=gtk_object_get_data(GTK_OBJECT(applet),"applet_pixmap");	
	button=(GtkWidget*)gtk_object_get_data(GTK_OBJECT(applet),"applet_button");	
	if (button==NULL)
	{
		printf("Cannot find applet button\n");
		return;
	}
	if (pixmap!=NULL) gtk_widget_destroy(pixmap);
	pixmap = gnome_pixmap_new_from_xpm_d_at_size(linphone2_xpm,
							 size-4, size-4);
	gtk_object_set_data(GTK_OBJECT(applet),"applet_pixmap",pixmap);
  	gtk_widget_show(pixmap);
  	gtk_container_add(GTK_CONTAINER(button), pixmap);	
}
#endif

void
on_adresse_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	address_book_init(&get_uiobj()->addressbook,get_core(),get_main_window()->addressentry);
}

void on_address_book_show(GtkWidget *widget,gpointer user_data)
{
	
}


/* LIK:  Transfer related functionality */
void on_mute_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gint state;
	LinphoneCore *lc=get_core();

	GtkWidget *optioncontrols=get_main_window()->optioncontrols;
	state=gtk_toggle_button_get_active(togglebutton);
	printf("Trying to set up mute %d\n", state);
	if (state) {
	    if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 1;
	    }
	} else {
	    if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 0;
	    }
	}
}


void
on_showmore_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gint state;
	GtkWidget *optioncontrols=get_main_window()->optioncontrols;
	state=gtk_toggle_button_get_active(togglebutton);
	if (state) gtk_widget_show(optioncontrols);
	else {
		gtk_widget_hide(optioncontrols);
	}
}



void
on_alt_href_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *url,*sipurl;
	GtkWidget *label;
	from_t * from;
	LinphoneGnomeUI *ui=get_uiobj();
	label=GTK_BIN(button)->child;
	gtk_label_get(GTK_LABEL(label),&url);
	from_init(&from);
	if ( from_parse(from,url) <0){
		/* do something here */
	}else
	{ /* it was a sip url, so display it in the entry*/
		gtk_entry_set_text(GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(ui->main_window.addressentry))),url);
	}
	from_free(from);
	sfree(from);
}

void
on_alt_href_realize                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GdkCursor *cursor = gdk_cursor_new(GDK_HAND2);
  gdk_window_set_cursor(widget->window, cursor);
  gdk_cursor_destroy(cursor);
}


void
on_dtmf_3_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"3");
	linphone_core_send_dtmf(get_uiobj()->core,'3');
}


void
on_dmtf_2_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"2");
	linphone_core_send_dtmf(get_uiobj()->core,'2');}


void
on_dtmf_1_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"1");
	linphone_core_send_dtmf(get_uiobj()->core,'1');
}


void
on_dtmf_4_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"4");
	linphone_core_send_dtmf(get_uiobj()->core,'4');
}


void
on_dtmf_5_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"5");
	linphone_core_send_dtmf(get_uiobj()->core,'5');
}


void
on_dtmf_6_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"6");
	linphone_core_send_dtmf(get_uiobj()->core,'6');
}


void
on_dtmf_7_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"7");
	linphone_core_send_dtmf(get_uiobj()->core,'7');
}


void
on_dtmf_8_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"8");
	linphone_core_send_dtmf(get_uiobj()->core,'8');
}


void
on_dtmf_9_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"9");
	linphone_core_send_dtmf(get_uiobj()->core,'9');
}


void
on_dtmf_star_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"*");
	linphone_core_send_dtmf(get_uiobj()->core,'*');
}


void
on_dtmf_0_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"0");
	linphone_core_send_dtmf(get_uiobj()->core,'0');
}


void
on_dtmf_pound_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *dtmf_entry=get_main_window()->dtmfentry;
	gtk_entry_append_text(GTK_ENTRY(dtmf_entry),"#");
	linphone_core_send_dtmf(get_uiobj()->core,'#');
}


void
on_dtmf_entry_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
	//g_message("entry modified");
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
#ifdef LINPHONE_APPLET
#else	
	gtk_main_quit();
#endif
}


void on_app1_destroy(GtkWidget *app1, gpointer user_data)
{
#ifdef LINPHONE_APPLET
#else	
	gtk_main_quit();
#endif
}



