/***************************************************************************
                          linphone.c  -  Main code for linphone's gnome 
										  interface
                             -------------------
    begin                : Mon Dec 17 2001
    copyright            : (C) 2001 by Simon Morlat
    email                : simon.morlat@linphone.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include "linphone.h"
#include "support.h"
#include "interface.h"


LinphoneGnomeUI *uiobj=NULL;

void linphone_gnome_ui_init(LinphoneGnomeUI *ui,LinphoneCore *core)
{
	gdk_threads_init();
	memset(ui,0,sizeof(LinphoneGnomeUI));
	ui->core=core;
	uiobj=ui;
}

void main_window_create(LinphoneGnomeUI *obj)
{
	GtkWidget *child;
	GtkWidget *window;
	window=obj->main_window.window=create_app1 ();
	gnome_window_icon_set_from_default(GTK_WINDOW(window));
	obj->main_window.status_bar=lookup_widget(window,"appbar1");
	obj->main_window.addressentry=lookup_widget(window,"addressentry");
	obj->main_window.transferentry=lookup_widget(window,"transferentry");
	obj->main_window.optioncontrols=lookup_widget(window,"optioncontrols");
	obj->main_window.dtmfentry=lookup_widget(window,"dtmf_entry");
	child=lookup_widget(window,"showmore");
	/* hide the optionnal controls at startup */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(child),0);

	child=lookup_widget(window,"mutebutton");
	/* Default is not to mute */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(child),0);

	presence_box_init(&obj->main_window.presencebox,window,obj->core);
	set_levels(obj,linphone_core_get_rec_level(obj->core),linphone_core_get_play_level(obj->core));
	g_object_set_data(G_OBJECT(window),"ui",(gpointer)obj);
}

void linphone_gnome_ui_show(LinphoneGnomeUI *ui)
{
	GtkWidget *win,*child;
	if (ui->main_window.window==NULL){
		main_window_create(ui);
		
	}
	gtk_widget_show(ui->main_window.window);
}

void linphone_gnome_ui_hide(LinphoneGnomeUI *ui)
{
	if (ui->main_window.window==NULL) return;
	gtk_widget_hide(ui->main_window.window);
}


void linphone_gnome_ui_uninit(LinphoneGnomeUI *ui)
{
	ui->main_window.window=NULL;
}


void linphone_gnome_ui_display_something(LinphoneGnomeUI *ui,GtkMessageType type,char *message)
{
	GtkWidget *dialog;
	
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	linphone_gnome_ui_show(ui);
	dialog = gtk_message_dialog_new (GTK_WINDOW(ui->main_window.window),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  type,
                                  GTK_BUTTONS_CLOSE,
                                  (const gchar*)message);
	/* Destroy the dialog when the user responds to it (e.g. clicks a button) */
	g_signal_connect_swapped (G_OBJECT (dialog), "response",
                           G_CALLBACK (gtk_widget_destroy),
                           G_OBJECT (dialog));
	gtk_widget_show(dialog);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

/* these are the LinphoneCore virtual functions */
void linphone_gnome_display_message(LinphoneCore *lc,char *message)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	linphone_gnome_ui_display_something(ui,GTK_MESSAGE_INFO,message);
}

void linphone_gnome_display_warning(LinphoneCore *lc,char *warning)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	linphone_gnome_ui_display_something(ui,GTK_MESSAGE_WARNING,warning);
}

void linphone_gnome_display_status(LinphoneCore *lc,char *status)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	if (ui->main_window.window==NULL) return;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	gnome_appbar_push(GNOME_APPBAR(ui->main_window.status_bar),status);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void linphone_gnome_inv_recv(LinphoneCore *lc,char *from)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	if (ui->main_window.window==NULL) return;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	gtk_entry_set_text(GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(ui->main_window.addressentry))),from);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void linphone_gnome_show(LinphoneCore *lc)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	linphone_gnome_ui_show(ui);
}

void linphone_gnome_display_url(LinphoneCore *lc, char *message, char *url)
{
	LinphoneGnomeUI *ui=(LinphoneGnomeUI*)lc->data;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	alt_ressource_display(ui,url);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void stub(){
}

LinphoneCoreVTable linphone_gnome_vtable=
{
	show: linphone_gnome_show,
	inv_recv: linphone_gnome_inv_recv,
	bye_recv : stub,
	display_status : linphone_gnome_display_status,
	display_message : linphone_gnome_display_message,
	display_warning : linphone_gnome_display_warning,
	display_url : linphone_gnome_display_url,
	display_question : stub
};

void linphone_gnome_init(LinphoneGnomeUI *ui,LinphoneCore *lc)
{
	linphone_gnome_ui_init(ui,lc);
	linphone_core_init(lc,&linphone_gnome_vtable,NULL,(gpointer)ui);
	ui->timeout_id=gtk_timeout_add(5000,(GtkFunction)linphone_core_refresh,(gpointer)lc);
}

void linphone_gnome_uninit(LinphoneGnomeUI *ui)
{
	LinphoneCore *lc=ui->core;
	linphone_gnome_ui_uninit(ui);
	linphone_core_uninit(lc);
	gtk_timeout_remove (ui->timeout_id);
}

