/***************************************************************************
                          addressbook.c  -  
                             -------------------
    begin                : Wed Jan 30 2002
    copyright            : (C) 2002 by Simon Morlat
    email                : simon.morlat@linphone.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "linphone.h"

#define get_address_book()	(&uiobj->addressbook)
#define get_main_window() (&uiobj->main_window)

enum{
	SIP_ADDRESS_COLUMN,
	AB_NCOLUMNS
};

void address_selection_changed_cb(GtkTreeSelection *selection, gpointer data)
{
	AddressBook *ab=get_address_book();
	GtkTreeIter iter;
	GtkTreeModel *model;
	from_t *sipaddr;
	gchar *address=NULL;
	gchar *url;
	gint error;
	
	if (gtk_tree_selection_get_selected (selection, &model, &iter)){
		gtk_tree_model_get (model, &iter,SIP_ADDRESS_COLUMN , &address, -1);
		g_return_if_fail(address!=NULL);
		from_init(&sipaddr);
		error=from_parse(sipaddr,address);
		if (error!=0){
			g_warning("error parsing sip address\n");
			goto end;
		}
		gtk_entry_set_text(GTK_ENTRY(ab->name_entry),sipaddr->displayname);
		sfree(sipaddr->displayname);
		sipaddr->displayname=NULL;
		from_2char(sipaddr,&url);
		gtk_entry_set_text(GTK_ENTRY(ab->address_entry),url);
		from_free(sipaddr);
		sfree(sipaddr);
		sfree(url);
	}else return;
	end:
		g_free(address);
}

void address_book_init(AddressBook *ab,LinphoneCore *lc,GtkWidget *main_entry)
{
}


void
on_modify_address_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *address,*full_address,*displayname;
	from_t *sipaddr;
	gint error;
	AddressBook *ab=get_address_book();
	GtkTreeSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	
	address=gtk_editable_get_chars(GTK_EDITABLE(ab->address_entry),0,-1);
	displayname=gtk_editable_get_chars(GTK_EDITABLE(ab->name_entry),0,-1);
	from_init(&sipaddr);
	error=from_parse(sipaddr,address);
	if (error!=0)
	{
		g_warning("Sip address is incorrect.\n");
		free(sipaddr);
		g_free(address);
		g_free(displayname);
		return;
	}
	sipaddr->displayname=sgetcopy(displayname);
	from_2char(sipaddr,&full_address);
	g_return_if_fail(full_address!=NULL);
	/* change the address in the view */
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_list_store_set(GTK_LIST_STORE(model), &iter,SIP_ADDRESS_COLUMN ,full_address, -1);
	}
}

void on_add_address_clicked(GtkButton *button,gpointer user_data)
{
	gchar *address,*full_address,*displayname;
	from_t *sipaddr;
	int error;
	GtkTreeIter iter;
	AddressBook *ab=get_address_book();
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(ab->address_list));
	
	address=gtk_editable_get_chars(GTK_EDITABLE(ab->address_entry),0,-1);
	displayname=gtk_editable_get_chars(GTK_EDITABLE(ab->name_entry),0,-1);
	
	from_init(&sipaddr);
	error=from_parse(sipaddr,address);
	if (error!=0)
	{
		g_warning("Sip address is incorrect.\n");
		sfree(sipaddr);
		g_free(address);
		g_free(displayname);
		return;
	}
	sipaddr->displayname=sgetcopy(displayname);
	from_2char(sipaddr,&full_address);
	g_return_if_fail(full_address!=NULL);
	gtk_list_store_append(GTK_LIST_STORE(model),&iter);
	gtk_list_store_set(GTK_LIST_STORE(model),&iter,SIP_ADDRESS_COLUMN,full_address,-1);

	from_free(sipaddr);
	free(sipaddr);
	g_free(address);
	g_free(displayname);
}

void on_remove_address_clicked(GtkButton *button,gpointer user_data)
{
	AddressBook *ab=get_address_book();
	GtkTreeSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
	}
}

void on_select_address_clicked(GtkButton *button,gpointer user_data)
{
}

void address_book_close(GtkButton *button,gpointer user_data)
{
	
	address_book_uninit(get_address_book());
}

void address_book_uninit(AddressBook *ab)
{
	GtkTreeIter iter;
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(ab->address_list));
	GList *siplist=NULL;
	gchar *address;
	
	/* get the list from the view */
	if (gtk_tree_model_get_iter_first(model,&iter)){
	
		do{
			gtk_tree_model_get (model, &iter,SIP_ADDRESS_COLUMN , &address, -1);
			g_return_if_fail(address!=NULL);
			siplist=g_list_append(siplist,(gpointer)address);
		} while(gtk_tree_model_iter_next(model,&iter));
	}
	linphone_core_set_address_list(ab->lc,siplist);
	gtk_widget_destroy(ab->address_book);
	memset(ab,0,sizeof(AddressBook));
}

