#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "linphone.h"

#define get_core()      (uiobj->core)
#define get_main_window() (&uiobj->main_window)
#define get_uiobj()     (uiobj)

void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void on_app1_destroy(GtkWidget *app1, gpointer user_data)
{
    gtk_main_quit();
    exit(0);
}


void
on_address_book1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gtk_main_quit();
    exit(0);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_user_manual1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_greenbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
    LinphoneGnomeUI *ui=get_uiobj();
    LinphoneCore *lc=get_core();
    if (lc->call==NULL){
	gchar *sipurl;
	/* we have no dialog in progress */
	/* get the url to call */
	sipurl=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
	linphone_core_invite(lc,sipurl);
	g_free(sipurl);
    } else linphone_core_accept_dialog(lc,NULL);    
}


void
on_redbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
    LinphoneGnomeUI *ui=get_uiobj();
    LinphoneCore *lc=get_core();
    if (lc->call!=NULL)
	linphone_core_terminate_dialog(lc,NULL);            
}


void
on_transferbutton_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    gchar *sipurl;
    
    LinphoneGnomeUI *ui=get_uiobj();
    LinphoneCore *lc=get_core();
    if (lc->call!=NULL) {
	/* get the url to call */
	sipurl=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.transferentry),0,-1);
	linphone_core_transfer(lc, sipurl); 
	g_free(sipurl);
        } else {
            osip_trace(OSIP_INFO1,("on_transfer_button_clicked: Need an ongoing call to transfer\n"));                               
        }         
}


void
on_mute_toggled                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    gint state;
    LinphoneCore *lc=get_core();
    
    state=gtk_toggle_button_get_active(togglebutton);
    if (state) {
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
	    lc->audiostream->timer->mute = 1;
	}
    } else {
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
	    lc->audiostream->timer->mute = 0;
	}
    }    
}

