/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#ifndef MSOSS_H
#define MSOSS_H

#undef PACKAGE
#undef VERSION
#include <config.h>
#undef PACKAGE
#undef VERSION

#include <glib.h>

#define MSOSS_MAX_DEVICES 4


struct _SndCard
{
	gchar *dev_name;            /* /dev/dsp0 for example */
	gchar *mixdev_name;         /* /dev/mixer0 for example */
	gchar *card_name;          /* SB16 PCI for example */
	gint fd;   /* the file descriptor of the open soundcard, 0 if not open*/
	guint16 blocksize;
	gint16 rate;
	gchar stereo;
	gchar bits;
};

typedef struct _SndCard SndCard;



struct _MSOss
{
	SndCard card[MSOSS_MAX_DEVICES];
	gint wcards; /* working cards */
	gint defcard;	/* the default card to be used */
};

typedef struct _MSOss MSOss;

#define MS_OSS(obj)  ( (MSOss*)(obj) )


void ms_oss_init(MSOss *klass);

void ms_oss_set_default_card(MSOss *obj, int index);

/* open a sound device for duplex */
int ms_oss_opendev(MSOss *obj,int devid, int bits, int stereo, int rate, int blocksize);

/* close a sound device */
void ms_oss_closedev(MSOss *obj,int devid);

/* set the path to device id */
void ms_oss_set_dev_name(MSOss *klass, int devid, char *path);

/* set the path to mixer for device id */
void ms_oss_set_mixdev_name(MSOss *klass,int devid, char *path);

/*set playback level */
void ms_oss_set_plevel(MSOss *obj, gint devid, gint a);

/*set recording level */
void ms_oss_set_rlevel(MSOss *obj, gint devid, gint a);

/* set general level */
void ms_oss_set_glevel(MSOss *obj,gint devid, gint a);

gint ms_oss_get_glevel(MSOss *obj,gint devid);

void ms_oss_set_source(MSOss *obj, gint devid, gchar source);

#define ms_oss_getfd(o,devid) ((o)->card[devid].fd)

#define ms_oss_getbsize(o,devid) ((o)->card[devid].blocksize)

extern MSOss oss_mgr;

#endif
