/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "osipua.h"
#include "osipmanager.h"
#include "resolver.h"
#include "utils.h"
#include "uatransaction.h"


void nist_kill_transaction(transaction_t * trn)
{
	osip_trace (OSIP_INFO1,("Transaction %i killed.\n", trn->transactionid));
	ua_transaction_free (trn);
}

void nist_register_received(transaction_t * trn, sip_t *sipmsg)
{
	int error;
	OsipDialog *dia;
	osip_trace (OSIP_INFO1,("nist_register_received: not fully implemented"));
	
	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	/* always answer Not implemented */
	if (dia!=NULL){
	  //ua_transaction_incoming_set_dialog (trn, dia);
	  //osip_dialog_update_from_request(dia,sipmsg);
	}else {
		/* should answer not implemented ? */
	}
}

/* LIK.  Process an incoming refer request and save the 
 * refer url in the call leg so you can forward to it when
 * you received the bye that comes afterwards */

void nist_refer_received(transaction_t *trn, sip_t *sipmsg)
{    
    OsipDialog *call;
    OsipUA *ua;
    const char *refer = "refer-to";
    header_t *tmp_header;
    int error;
    int i=0;
    osip_trace (OSIP_INFO1, ("nist_refer_received():\n"));

    error = osip_dialog_find(sipmsg, &call);
    if (error==-1) {
	/* discard the transaction, it is not valid, perhaps a retransmission */
	/* put the transaction in the free list */
	osip_remove_nist(trn->config,trn);
	fifo_add(&def_manager->garbage_trn,(void*)trn);
	osip_trace (OSIP_INFO1, ("Could not find dialog for REFER message"));	
    }
    
    if (call != NULL) {
	while (!list_eol(sipmsg->headers, i)) {		    
	    tmp_header = (header_t *)list_get(sipmsg->headers, i);
	    /* Found it.  Make a call to the sip URL associated with it */
	    if (strncmp(tmp_header->hname, refer, sizeof(refer)) == 0) {
		call->referurl = sgetcopy(tmp_header->hvalue);
		break;
	    }		    
	    i++;
	}
		
	/* respond 202 OK to the client */
	osip_dialog_respond (call, trn, 202);

    } else {
	osip_trace (OSIP_WARNING,
		    ("REFER for an inexistant dialog !\n"));
	ua = (OsipUA *) list_get (&ua_list, 0);
	respond_to_request (ua->config, trn, 481);
	/* return an Inexistant Call-Leg */
    }
    return;
}

/* A notify has arrived.  Not clear what to do with it
 * so simply acknowledge it and send a 200 back */

void nist_notify_received(transaction_t *trn, sip_t *sipmsg)
{
    OsipDialog *call;
    OsipUA *ua;
    int error;
    osip_trace (OSIP_INFO1, ("nist_refer_received():\n"));

    error = osip_dialog_find(sipmsg, &call);
    if (error==-1) {
	/* discard the transaction, it is not valid, perhaps a retransmission */
	/* put the transaction in the free list */
	osip_remove_nist(trn->config,trn);
	fifo_add(&def_manager->garbage_trn,(void*)trn);
	osip_trace (OSIP_INFO1, ("Could not find dialog for REFER message"));	
    }
    
    if (call != NULL) {
	/* respond 200 OK to the client */
	osip_dialog_respond (call, trn, 200);
	
    } else {
	osip_trace (OSIP_WARNING,
		    ("REFER for an inexistant dialog !\n"));
	ua = (OsipUA *) list_get (&ua_list, 0);
	respond_to_request (ua->config, trn, 481);
	/* return an Inexistant Call-Leg */
    }
    return;
}

void nist_bye_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *call;
	OsipUA *ua;
	int error;
	int i=0;
	header_t *tmp_header;
	const char *also="also";
	char *referurl;
	osip_trace (OSIP_INFO1, ("nist_bye_received():\n"));

	error = osip_dialog_find (sipmsg,&call);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_nist(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (call != NULL)
	{
		/* an existing call-leg was found, so process it */
		ua = osip_dialog_get_ua (call);
		ua_transaction_set_incoming_bye_tr(trn, call);
		/* indicate the user of the end of the call-leg */
		if (ua->bye != NULL)
			ua->bye (call, trn, sipmsg,
				 (void *) NULL);

		if (call->referurl != NULL)
		    referurl = sgetcopy(call->referurl);
		else
		    referurl = NULL;
		/* respond 200 OK to the client */
		osip_dialog_respond (call, trn, 200);
		

		/*LIK: transfer related functionality 
		  then delete the call, unless we want to preserve it 
		  if we have seen a refer transaction */
		if (referurl==NULL)
		    osip_dialog_release (call);

		/* LIK: Transfer related functionality 
		 * Now we are done with the bye.  Check to see if there 
		 * an also header in the message */
		/* Two cases:  Either this is a BYE with an Also header
		 * or there was a REFER before the BYE */
		
		while (!list_eol(sipmsg->headers, i)) {		    
		    tmp_header = (header_t *)list_get(sipmsg->headers, i);
		    /* Found it.  Make a call to the sip URL associated with it */
		    if (strncmp(tmp_header->hname, also, sizeof(also)) == 0) {
			if (ua->byetransfer_function != NULL)
			    ua->byetransfer_function(ua->data, NULL, NULL, tmp_header->hvalue);
			return; 
		    }		    
		    i++;
		}

		if (referurl != NULL) {
		    if (ua->refertransfer_function != NULL)
			ua->refertransfer_function(ua->data, NULL, sipmsg, referurl);
		    sfree(referurl);
		    return;
		}
	       
	}
	else
	{
		osip_trace (OSIP_WARNING,
				("Bye for an inexistant dialog !\n"));
		ua = (OsipUA *) list_get (&ua_list, 0);
		respond_to_request (ua->config, trn, 481);
		/* return an Inexistant Call-Leg */
	}
	return;		/* ok */
}


void nist_cancel_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *dia;
	OsipUA *ua;
	int error;

	osip_trace (OSIP_INFO1, ("nist_cancel_received():"));

	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (dia!=NULL){
	  //osip_dialog_update_from_request(dia,sipmsg);
		/* an existing call-leg was found, so process it */
		ua = osip_dialog_get_ua (dia);
		ua_transaction_set_incoming_cancel_tr(trn, dia);
		osip_dialog_set_state(dia,DIALOG_CANCELLED);
		/* cancel the previous invite transaction */
		//ua_transaction_free(dia->inc_invite_tr);
		/* indicate the user of the end of the call-leg */
		if (ua->bye != NULL)
			ua->bye (dia, trn, sipmsg,
				 (void *) NULL);
		osip_dialog_respond(dia,trn,200);
		/* respond 487 to the client */
		if (dia->inc_invite_tr!=NULL)
			osip_dialog_respond (dia, dia->inc_invite_tr, 487);
		else osip_trace(OSIP_WARNING,("null invite request!\n"));
		/* then delete the call */
		osip_dialog_release (dia);
	}else {
		/* should answer not implemented ? */
	}	
}

void nist_options_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *dia;
	OsipUA *ua;
	int error;

	osip_trace (OSIP_WARNING, ("nist_options_received(): not fully implemented.\n"));

	error = osip_dialog_find (sipmsg,&dia);
	if (error==-1){
		/* discard the transaction, it is not valid, perhaps a retransmission */
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
	if (dia!=NULL){
 	  /* TODO */

	  //ua_transaction_incoming_set_dialog (trn, dia);
	  //osip_dialog_update_from_request(dia,sipmsg);
		/* answer 200 OK ? */
	  //osip_dialog_respond(dia,trn,200);
	}else {
		/* should answer not implemented ? */
	}	
}

