/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/



#include "osipua.h"
#include "sdphandler.h"

int gen_offer(SdpHandler *sdph, SdpContext *ctx){
	SdpPayload payload;
	sdp_payload_init(&payload);
	payload.localport=8888;
	payload.pt=3;
	payload.a_rtpmap="gsm/8000/1";
	sdp_handler_add_audio_payload(sdph,ctx,&payload);
	return 0;	/* we just want one codec with one mline */
}

int main()
{
	OsipUA *ua;
	OsipDialog *call;
	BodyHandler *bh;
	
	osipua_init();
	TRACE_INITIALIZE(OSIP_INFO4,NULL);
	ua=osip_ua_new();
	osip_ua_set_contact(ua,"sip:simon@127.0.0.1");
	bh=sdp_handler_new();
	sdp_handler_set_write_offer_fcn(SDP_HANDLER(bh),gen_offer,NULL);
	osip_ua_add_body_handler(ua,bh);
	
	call=osip_dialog_new(ua);
	osip_dialog_invite(call,"sip:toto@127.0.0.1:5064","application/sdp");
	
	sleep(1);
	osipua_exit();
	
	return 0;
}

























