/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <osip/osip.h>
#include <osip/smsgtypes.h>
#include "osipdialog.h"

transaction_t * ua_transaction_new(OsipDialog *call, sip_t *msg);


#define ua_transaction_get_dialog(trn) ((OsipDialog*)((trn)->your_instance))

void ua_transaction_set_incoming_invite_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_outgoing_invite_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_incoming_bye_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_outgoing_bye_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_outgoing_register_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_outgoing_cancel_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_incoming_cancel_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_outgoing_notify_tr(transaction_t *trn,OsipDialog *call);
void ua_transaction_set_incoming_notify_tr(transaction_t *trn,OsipDialog *call);

void ua_transaction_free(transaction_t *transaction);

void ua_transaction_set_destination(transaction_t *trn,char *destination, int port);

int ua_transaction_get_destination(transaction_t *trn, char **destination, int *port);

/* execute a transaction outside the udp thread context */
void ua_transaction_execute(transaction_t *trn, sipevent_t *ev);

