/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <errno.h>
#include "osipua.h"
#include <osip/sdp.h>
#include "utils.h"
#include "uatransaction.h"


void nict_kill_transaction(transaction_t* trn)
{
	osip_trace (OSIP_INFO1,("Transaction %i killed.\n", trn->transactionid));
	ua_transaction_free (trn);
}

void nict_1xx_received(transaction_t* trn, sip_t* sipmsg)
{
	
	OsipDialog *call;
	OsipUA *ua;
	int inf;
	char *strinf;

	osip_trace (OSIP_INFO1, ("OnEvent_New_Incoming1xxResponse!\n"));

	call = ua_transaction_get_dialog (trn);
	if (call == NULL)
	{
		osip_trace (OSIP_WARNING,
			    ("1xx response for an inexistant call leg! \n"));
		return;
	}
	strinf = sipmsg->strtline->statuscode;
	if (strinf != NULL)
		inf = satoi (strinf);
	ua = (OsipUA *) call->ua;
	if (ua->informative != NULL)
		ua->informative (call, trn, sipmsg, (void*)&inf);

	return;			/* ok */
}


void nict_2xx_received(transaction_t* trn, sip_t* sipmsg)
{
	OsipUA *ua;
	OsipDialog *call;
	call=ua_transaction_get_dialog(trn);
	ua=osip_dialog_get_ua(call);
	if (MSG_IS_REGISTER (trn->orig_request))
	{
		int inf = 200;
		char *tmp;
		RegistrationCtxt *ctx = call->reg_context;

		/* add  the address of records to the list of aliases if the expire!=0 else try to remove it */
		contact_2char ((contact_t *) trn->orig_request->to,
				   &tmp);
		if (ctx != NULL)
		{
			if (ctx->expires != 0)
				osip_ua_add_alias (ua, tmp);
			else
				osip_ua_remove_alias (ua, tmp);
			sfree (tmp);
			if (ua->informative != NULL)
				ua->informative (call, trn, sipmsg,
						 (void *) &inf);
			/* destroys the registration context (well dec the ref count) */
			call->reg_context = NULL;
			registration_ctxt_destroy (ctx);
		}
	}
}

void nict_3xx_received(transaction_t* trn, sip_t* sipmsg)
{
	osip_trace (OSIP_WARNING, ("nict_3xx_received(): not implemented\n"));
}

void nict_4xx_received(transaction_t* trn, sip_t* sipmsg)
{
	
	OsipDialog *call;
	OsipUA *ua;
	char *strerr;
	int error;

	osip_trace (OSIP_INFO1, ("OnEvent_New_Incoming4xxResponse!\n"));
	call = ua_transaction_get_dialog (trn);
	if (call == NULL)
	{
		osip_trace (OSIP_WARNING,
			    ("4xx response for an inexistant call leg! \n"));
		return;
	}
	ua = osip_dialog_get_ua (call);
	
	strerr = sipmsg->strtline->statuscode;
	if (strerr != NULL)
		error = satoi (strerr);
	switch (error)
	{
	case 407:		/*Multiples choices */
	case 401:		/*Multiples choices */
		if (call->reg_auth_count==0)
		{
			osip_trace (OSIP_INFO1,
				    ("User need to authenticate to REGISTER!\n"));
			call->status = DIALOG_NEW;
			osip_dialog_register_with_authentication (call,sipmsg,NULL);
			call->reg_auth_count++;
			return;
		}
		else
		{
			osip_trace (OSIP_INFO1,("Authentification aborted.\n"));
			break;
		}
	}

	if (ua->faillure != NULL)
		ua->faillure (call, trn,sipmsg,(void*) &error);

	osip_dialog_release (call);
	return;			/* ok */
}


void nict_5xx_received(transaction_t* trn, sip_t* sipmsg)
{
	OsipDialog *call;
	OsipUA *ua;
	char *strerr;
	int error;

	osip_trace (OSIP_INFO1, ("ict_5xx_received():\n"));
	call = ua_transaction_get_dialog (trn);
	if (call == NULL)
	{
		osip_trace (OSIP_WARNING,
			    ("5xx response for an inexistant call leg! \n"));
		return;
	}
	ua = osip_dialog_get_ua (call);
	
	strerr = sipmsg->strtline->statuscode;
	if (strerr != NULL)
		error = satoi (strerr);
	if (ua->faillure != NULL)
		ua->faillure (call, trn, sipmsg, (void*)&error);
	osip_dialog_release (call);
	return;			/* ok */
}

void nict_6xx_received(transaction_t* trn, sip_t* sipmsg)
{
	OsipDialog *call;
	OsipUA *ua;
	char *strerr;
	int error;

	osip_trace (OSIP_INFO1, ("OnEvent_New_Incoming6xxResponse!\n"));
	call = ua_transaction_get_dialog (trn);
	if (call == NULL)
	{
		osip_trace (OSIP_WARNING,
			    ("6xx response for an inexistant call leg! \n"));
		return;
	}
	ua = osip_dialog_get_ua (call);
	
	
	strerr = sipmsg->strtline->statuscode;
	if (strerr != NULL)
		error = satoi (strerr);
	if (ua->faillure != NULL)
		ua->faillure (call, trn, sipmsg, (void*)&error);
	osip_dialog_release (call);
	return;			/* ok */
}
