/***************************************************************************
                          addressbook.c  -  
                             -------------------
    begin                : Wed Jan 30 2002
    copyright            : (C) 2002 by Simon Morlat
    email                : simon.morlat@linphone.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "linphone.h"

#define get_address_book()	(&uiobj->addressbook)
#define get_main_window() (&uiobj->main_window)

enum {
	SIP_ADDRESS_COLUMN,
	SIP_PRESENCE_COLUMN,
	AB_NCOLUMNS
};

void choose_address_and_close(AddressBook *ab){
	GtkTreeSelection *select;
	GtkWidget *addressentry=get_main_window()->addressentry;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *address;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (select==NULL) return;
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter,SIP_ADDRESS_COLUMN , &address, -1);
	}
	g_return_if_fail(address!=NULL);
	gtk_entry_set_text (GTK_ENTRY(gnome_entry_gtk_entry(GNOME_ENTRY(addressentry))),address);
	address_book_uninit(ab,TRUE);
}

void address_selection_changed_cb(GtkTreeSelection *selection, gpointer data)
{
	AddressBook *ab=get_address_book();
	GtkTreeIter iter;
	GtkTreeModel *model;
	from_t *sipaddr;
	gchar *address=NULL;
	gchar *url;
	gint error;
	
	if (gtk_tree_selection_get_selected (selection, &model, &iter)){
		gtk_tree_model_get (model, &iter,SIP_ADDRESS_COLUMN , &address, -1);
		g_return_if_fail(address!=NULL);
		from_init(&sipaddr);
		error=from_parse(sipaddr,address);
		if (error!=0){
			g_warning("error parsing sip address\n");
			goto end;
		}
		gtk_entry_set_text(GTK_ENTRY(ab->name_entry),sipaddr->displayname);
		sfree(sipaddr->displayname);
		sipaddr->displayname=NULL;
		from_2char(sipaddr,&url);
		gtk_entry_set_text(GTK_ENTRY(ab->address_entry),url);
		from_free(sipaddr);
		sfree(sipaddr);
		sfree(url);
	}else return;
	end:
		g_free(address);
}
gboolean address_button_press(GtkWidget *widget,GdkEventButton *event,gpointer user_data)
{
	if (event->type==GDK_2BUTTON_PRESS){
		choose_address_and_close(get_address_book());
		return TRUE;
	}
	return FALSE;
}

void address_book_init(AddressBook *ab,LinphoneCore *lc,GtkWidget *main_entry)
{
	GtkListStore *store;
	GtkTreeIter iter;
	GtkCellRenderer *renderer;
	GtkTreeViewColumn *column;
	GtkTreeSelection *select;
	GList *list,*elem;
	
	if (ab->address_book!=NULL) {
		gtk_widget_show(ab->address_book);
		return;
	}
	store = gtk_list_store_new (AB_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING);
	ab->address_book=create_address_book();
	ab->name_entry=lookup_widget(ab->address_book,"name_entry");
	ab->address_entry=lookup_widget(ab->address_book,"address_entry");
	ab->main_entry=main_entry;
	ab->lc=lc;
	/* setup the address list */
	ab->address_list=lookup_widget(ab->address_book,"address_list");
	list=linphone_core_get_address_list(lc);
	elem=list;
	while(elem!=NULL){
		/* get an iterator */
		LinphoneCoreAddressEntry *entry = (LinphoneCoreAddressEntry *)elem->data;
		gtk_list_store_append(store,&iter);
		gtk_list_store_set(store,&iter,SIP_ADDRESS_COLUMN,entry->address,-1);
		if (entry->subscribe_notify)
			gtk_list_store_set(store,&iter,SIP_PRESENCE_COLUMN,entry->subscribe_notify,-1);
		elem=g_list_next(elem);
	}
	if (list!=NULL) g_list_free(list);
	
	gtk_tree_view_set_model(GTK_TREE_VIEW(ab->address_list),GTK_TREE_MODEL(store));
	g_object_unref(G_OBJECT(store));
	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("SIP Address list",
                                                   renderer,
                                                   "text", SIP_ADDRESS_COLUMN,
                                                   NULL);
	gtk_tree_view_column_set_resizable(column, 1);
	gtk_tree_view_column_set_clickable(column, 1);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ab->address_list), column);

	renderer = gtk_cell_renderer_text_new ();
	column = gtk_tree_view_column_new_with_attributes ("Presence",
                                                   renderer,
                                                   "text", SIP_PRESENCE_COLUMN,
                                                   NULL);
	gtk_tree_view_column_set_resizable(column, 1);
	gtk_tree_view_column_set_clickable(column, 1);
	gtk_tree_view_append_column (GTK_TREE_VIEW (ab->address_list), column);

	/* Setup the selection handler */
	gtk_tree_view_set_enable_search(GTK_TREE_VIEW (ab->address_list), 1);
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
	g_signal_connect (G_OBJECT (select), "changed",
                  G_CALLBACK (address_selection_changed_cb),
                  NULL);
	
	/* setup handler for double click */
	g_signal_connect(G_OBJECT(ab->address_list),"button-press-event",G_CALLBACK(address_button_press),(gpointer)NULL);
	gtk_widget_show(ab->address_book);
}


void
on_modify_address_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *address,*full_address,*displayname;
	from_t *sipaddr;
	gint error;
	AddressBook *ab=get_address_book();
	GtkTreeSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	
	address=gtk_editable_get_chars(GTK_EDITABLE(ab->address_entry),0,-1);
	displayname=gtk_editable_get_chars(GTK_EDITABLE(ab->name_entry),0,-1);
	from_init(&sipaddr);
	error=from_parse(sipaddr,address);
	if (error!=0)
	{
		g_warning("Sip address is incorrect.\n");
		free(sipaddr);
		g_free(address);
		g_free(displayname);
		return;
	}
	sipaddr->displayname=sgetcopy(displayname);
	from_2char(sipaddr,&full_address);
	g_return_if_fail(full_address!=NULL);
	/* change the address in the view */
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_list_store_set(GTK_LIST_STORE(model), &iter,SIP_ADDRESS_COLUMN ,full_address, -1);
	}
}

void on_add_address_clicked(GtkButton *button,gpointer user_data)
{
	gchar *address,*full_address,*displayname;
	from_t *sipaddr;
	int error;
	GtkTreeIter iter;
	AddressBook *ab=get_address_book();
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(ab->address_list));
	
	address=gtk_editable_get_chars(GTK_EDITABLE(ab->address_entry),0,-1);
	displayname=gtk_editable_get_chars(GTK_EDITABLE(ab->name_entry),0,-1);
	
	from_init(&sipaddr);
	error=from_parse(sipaddr,address);
	if (error!=0)
	{
		g_warning("Sip address is incorrect.\n");
		sfree(sipaddr);
		g_free(address);
		g_free(displayname);
		return;
	}
	sipaddr->displayname=sgetcopy(displayname);
	from_2char(sipaddr,&full_address);
	g_return_if_fail(full_address!=NULL);
	gtk_list_store_append(GTK_LIST_STORE(model),&iter);
	gtk_list_store_set(GTK_LIST_STORE(model),&iter,SIP_ADDRESS_COLUMN,full_address,-1);

	from_free(sipaddr);
	sfree(sipaddr);
	g_free(address);
	g_free(displayname);
}

void on_remove_address_clicked(GtkButton *button,gpointer user_data)
{
	AddressBook *ab=get_address_book();
	GtkTreeSelection *select;
	GtkTreeIter iter;
	GtkTreeModel *model;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
	}
}



void on_select_address_clicked(GtkButton *button,gpointer user_data)
{
	
	AddressBook *ab=get_address_book();
	choose_address_and_close(ab);
}

void address_book_close(GtkButton *button,gpointer user_data)
{
	
	address_book_uninit(get_address_book(),TRUE);
}

void on_address_book_close(GtkWidget *ab){
	g_message("on_address_book_close");
	address_book_uninit(get_address_book(),FALSE);
}

void address_book_uninit(AddressBook *ab, gboolean destroy_widget)
{
	GtkTreeIter iter;
	GtkTreeModel *model=gtk_tree_view_get_model(GTK_TREE_VIEW(ab->address_list));
	GList *siplist=NULL;
	gchar *address;
	
	/* get the list from the view */
	if (gtk_tree_model_get_iter_first(model,&iter)){
	
		do{
			LinphoneCoreAddressEntry *entry = g_malloc(sizeof(LinphoneCoreAddressEntry));

			gtk_tree_model_get (model, &iter, SIP_ADDRESS_COLUMN, &entry->address, -1);
			g_return_if_fail(entry->address!=NULL);
			gtk_tree_model_get (model, &iter, SIP_PRESENCE_COLUMN, &entry->subscribe_notify, -1);

			fprintf(stderr, "address=%s subscribe_notify=%s\n", entry->address, entry->subscribe_notify);

			siplist=g_list_append(siplist,(gpointer)entry);
		} while(gtk_tree_model_iter_next(model,&iter));
	}
	linphone_core_set_address_list(ab->lc,siplist);
	if (destroy_widget) gtk_widget_destroy(ab->address_book);
	memset(ab,0,sizeof(AddressBook));
}


void
on_subscribe_address_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	AddressBook *ab=get_address_book();
	GtkTreeSelection *select;
	GtkWidget *addressentry=get_main_window()->addressentry;
	GtkTreeIter iter;
	GtkTreeModel *model;
	gchar *address, *pstring;
	select = gtk_tree_view_get_selection (GTK_TREE_VIEW (ab->address_list));
	if (select==NULL) return;
	if (gtk_tree_selection_get_selected (select, &model, &iter))
	{
		gtk_tree_model_get (model, &iter,SIP_ADDRESS_COLUMN , &address, -1);
	}
	g_return_if_fail(address!=NULL);

	linphone_core_subscribe(ab->lc, address);	

	pstring = sgetcopy("subscribing");
	gtk_list_store_set(GTK_LIST_STORE(model),&iter,SIP_PRESENCE_COLUMN,pstring,-1);

}

