#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "mediastream.h"
#include "linphone-gpe.h"
#include "events.h"

#define get_core()	(uiobj->core)
#define get_main_window() (&uiobj->main_window)
#define get_uiobj()	(uiobj)

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_phone_number_activate                       (GtkMenuItem     *menuitem,
						gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     GtkWidget *addressentry=get_main_window()->addressentry;
     gtk_entry_set_text(GTK_ENTRY(addressentry), user_data);
}

void
on_call_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (lc->call==NULL){
	  gchar *sipuri;
	  GtkWidget *placed_calls_menu = lookup_widget(GTK_WIDGET(menuitem), "placed_calls_menu");
	  /* we have no dialog in progress */
	  /* get the url to call */
	  sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
	  linphone_core_invite(lc,sipuri);
	  if (placed_calls_menu) {
	    GtkWidget *new_entry = gtk_menu_item_new_with_mnemonic(sipuri);
	    gtk_widget_show(new_entry);
	    gtk_container_add(GTK_CONTAINER(placed_calls_menu), new_entry);
	    g_signal_connect ((gpointer) new_entry, "activate",
			      G_CALLBACK (on_phone_number_activate),
			      strdup(sipuri));
	  }
	  g_free(sipuri);
     } else {
	  linphone_core_accept_dialog(lc,NULL);
     }
}


void
on_transfer_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_release_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (lc->call!=NULL)
	  linphone_core_terminate_dialog(lc,NULL);

}


void
on_conference_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_dtmf_1_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"1");
}
void
on_dtmf_2_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"2");
}
void
on_dtmf_3_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"3");
}
void
on_dtmf_4_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"4");
}
void
on_dtmf_5_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"5");
}
void
on_dtmf_6_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"6");
}
void
on_dtmf_7_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"7");
}
void
on_dtmf_8_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"8");
}
void
on_dtmf_9_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"9");
}
void
on_dtmf_star_clicked                      (GtkButton       *button,
					   gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"*");
}
void
on_dtmf_0_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"0");
}
void
on_dtmf_pound_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"#");
}


void
on_subscribe_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     gchar *sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
     event_update_buddy(lc, sipuri, NULL, NULL);
     linphone_core_subscribe(lc, sipuri);	
}


void
on_unsubscribe_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     gchar *sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
     linphone_core_unsubscribe(lc, sipuri);	
}


void
on_address_book_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_missed_calls_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_received_calls_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_placed_calls_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keypad_back_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gchar *text = gtk_editable_get_chars(GTK_EDITABLE(addressentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(addressentry), strlen(text)-1, -1);
}


void
on_keypad_clear_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_set_text(GTK_ENTRY(addressentry),"");
}


void
on_item4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_linphone_gpe_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit();
}


void
on_mute_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	LinphoneCore *lc=get_core();
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 1;
	}
}


void
on_unmute_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	LinphoneCore *lc=get_core();
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 0;
	}

}


void
on_ethernet_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}

void
on_settings_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	linphone_property_box_init(&uiobj->propbox);
}

void
on_properties_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
	linphone_property_box_uninit(&uiobj->propbox);
}


void
on_properties_close_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	LinphoneCore *lc = get_core();
	linphone_property_box_apply(&uiobj->propbox, lc);
	gtk_widget_destroy(GTK_WIDGET(&uiobj->propbox.prop)); 
}


void
on_properties_apply_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	LinphoneCore *lc = get_core();
	linphone_property_box_apply(&uiobj->propbox, lc);
}


void
on_properties_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
}



