 /*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  Aymeric MOIZARD jack@atosc.org
  *
  * Copyright (C) 2003 Hewlett-Packard Company
  *
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef CPIMHANDLER_H
#error "Never include this file directly, use cpimhandler.h instead"
#endif

#ifndef CPIMCONTEXT_H
#define CPIMCONTEXT_H

typedef enum _CpimContextState
{
	CPIM_CONTEXT_STATE_INIT,
	CPIM_CONTEXT_STATE_NEGOCIATION_OPENED,
	CPIM_CONTEXT_STATE_NEGOCIATION_CLOSED
} CpimContextState;

struct _CpimContext
{
	BodyContext parent;
	CpimContextState state;
};

struct _CpimContextClass
{
	BodyContextClass parent_class;
};

typedef struct  _CpimContext CpimContext;
typedef struct  _CpimContextClass CpimContextClass;

void cpim_context_init(CpimContext *obj, CpimHandler *info);
void cpim_context_class_init(CpimContextClass *klass);

BodyContext *cpim_context_new(CpimHandler *info);
void cpim_context_destroy(CpimContext *obj);

#define CPIM_CONTEXT(obj)  ((CpimContext*)(obj))
#define CPIM_CONTEXT_CLASS(klass)  ((CpimContextClass*)(klass))

/* get the local cpim after negociation */
#define cpim_context_get_answer(h)	((h)->localneg)
/* get the remote cpim after the response from remote server is received */
#define cpim_context_get_remote(h)	((h)->remote)

#define cpim_context_get_negociation_status(ctx)		((ctx)->negoc_status)

#endif
