/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef OSIPUA_H
#error "You must not include osipcallleg.h in an application. Use osipua.h instead."
#endif

#ifndef OSIP_CALL_LEG_H
#define OSIP_CALL_LEG_H

#include <osip/smsgtypes.h>

#include "regctxt.h"

/* status for call-legs*/
enum { DIALOG_NEW, DIALOG_INVITING, DIALOG_INVITED, DIALOG_ESTABLISHED, DIALOG_CANCELLING, DIALOG_CANCELLED,
       DIALOG_TERMINATED, 
       DIALOG_MUTING, DIALOG_MUTED, 
       DIALOG_TRANSFERRING, DIALOG_TRANSFERRED,
       DIALOG_REFERRING, DIALOG_REFERRED,
       DIALOG_SUBSCRIBING, DIALOG_SUBSCRIBED, DIALOG_FAKE};

/* the list of call-legs handled by the stack*/
extern list_t callleg_list;


/* create a new call-leg managed by an existing use agent*/
OsipDialog *osip_dialog_new(struct _OsipUA *ua);

OsipDialog *osip_dialog_new_from_incoming_trn(transaction_t *trn);

void osip_dialog_update_from_response(OsipDialog *call,sip_t *resp);

void osip_dialog_update_from_request(OsipDialog *dia, sip_t *sipmsg);

#define osip_dialog_set_state(call, state) (call)->status=(state)

#define osip_dialog_get_state(call) ((call)->status)

/* returns 1 if call leg exists*/
int osip_dialog_exists(OsipDialog *call);

/* returns the ua that owns the call leg*/
#define osip_dialog_get_ua(call) ((struct _OsipUA*)(call->ua))

/* find an existing call_leg in the stack list using an incmoing sip message. Returns NULL if not found*/
int osip_dialog_find(sip_t *sipmsg, OsipDialog **ret_dialog);

/* find an existing call leg using a transaction id*/
//OsipDialog *osip_dialog_find_with_tid(int tid);


/* accept an invitation for an existing call-leg*/
void osip_dialog_accept_invite(OsipDialog *call_leg,transaction_t *trn);

/* invite somebody */
int osip_dialog_invite(OsipDialog *call_leg, char *callee, char *body_mime);
int osip_dialog_reinvite_with_authentication(OsipDialog *call_leg,
					     sip_t *previous_answer, char *password);
/* subscribe to somebody */
int osip_dialog_subscribe(OsipDialog *call_leg, char *callee);
/* resubscribe */
int osip_dialog_resubscribe (OsipDialog * call_leg);

/**
 * Sends a NOTIFY request to a subscribeer.
 */
int
osip_dialog_notify (OsipDialog * call_leg, char *callee, char *event_package, 
		    char *mimetype, char *body);

/* register your identity to a registrar */
int osip_dialog_register(OsipDialog *call_leg, RegistrationCtxt *ctxt);
/* action can be :*/

int osip_dialog_register_with_authentication(OsipDialog *call_leg,sip_t *previous_answer, char *password);

/* unregister user's identity to a registrar*/
int osip_dialog_unregister(OsipDialog *call, RegistrationCtxt *ctxt);

/* get the list media streams with their profile when a call is starting*/
//list_t * osip_dialog_get_streams(OsipDialog *call_leg);

void osip_dialog_ack(OsipDialog *call,transaction_t *trn);
/* bye and destroy the call-leg*/
int osip_dialog_bye(OsipDialog *call_leg);
int osip_dialog_reject_invite (OsipDialog * call_leg);

int osip_dialog_generate_request_within_dialog( OsipDialog *call_leg,
					   char *method_name,sip_t **dest);
int generating_request_out_of_dialog(OsipDialog * call_leg,
				 char *method_name,
				 char *callee, sip_t **dest);
				 
int osip_dialog_send_request(OsipDialog *call_leg,sip_t *sipmsg);

int
osip_dialog_generate_response_default(OsipDialog *call_leg,
				      int status, sip_t *request, sip_t **dest);

/* respond to a request that is part from a call-leg : ex 200OK (INVITE)*/
void osip_dialog_respond(OsipDialog *call, transaction_t *trn, int code);

void osip_dialog_send_response(OsipDialog *call,transaction_t *trn, sip_t *resp);

void osip_dialog_release(OsipDialog *call); 

/* Destroy a call-leg and remove it from ua list and stack list*/
int osip_dialog_destroy(OsipDialog *call);

/* Refer a call to someone else */
int osip_dialog_refer(OsipDialog *call_leg);

/* Terminate a call after having transferred somewhere else */
int osip_dialog_bye_transfer(OsipDialog *call_leg, int action);

/* extract all media descriptors from a sdp_t, and find compatible profiles for each one*/
/* if compatible profile is found for ALL medias, return 0, else -1. The list of MediaDesc is stored in OsipDialog::media_list*/
//int osip_dialog_extract_media(OsipDialog *call,sdp_t *remote_sdp);

/* possible requests*/
#define INVITE 0
#define BYE 1
#define REGISTER 2
#define ACK 3

/* returns 1 if call is handled by ua*/
int osip_ua_call_leg_exists(OsipUA *ua,OsipDialog *call);


void osip_dialog_add_body_context(OsipDialog *call, BodyContext *handler);

BodyContext * osip_dialog_get_body_context(OsipDialog *call, char *body_mime, int pos);

int osip_dialog_add_body_to_request(OsipDialog *call, sip_t *msg, char *body_mime);

#endif
