/***************************************************************************
          linphone.c  -  Main code for linphone's gpe interface
                             -------------------
    begin                : Mon Dec 17 2001
    copyright            : (C) 2001 by Simon Morlat
    email                : simon.morlat@linphone.org
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include "linphone-gpe.h"
#include "support.h"
#include "interface.h"
#include <events.h>


LinphoneGPEUI *uiobj=NULL;

void linphone_gpe_ui_init(LinphoneGPEUI *ui,LinphoneCore *core)
{
	gdk_threads_init();
	memset(ui,0,sizeof(LinphoneGPEUI));
	ui->core=core;
	uiobj=ui;
}

extern void on_phone_number_activate(GtkMenuItem *menuitem, gpointer user_data);
static void phone_menu_init(GtkWidget *menu, GList *address_list)
{
	if (menu) {
		GList *children = g_list_copy(gtk_container_get_children(GTK_CONTAINER(menu)));
		/* remove old children */
		while (children) {
			gtk_container_remove(GTK_CONTAINER(menu), children->data);
			children = children->next;
		}
		g_list_free(children);
		/* add new children */
		while (address_list) {
			gchar *entry = address_list->data;
			GtkWidget *new_entry = gtk_menu_item_new_with_mnemonic(entry);
			gtk_widget_show(new_entry);
			gtk_container_add(GTK_CONTAINER(menu), new_entry);
			g_signal_connect ((gpointer) new_entry, "activate",
					  G_CALLBACK (on_phone_number_activate),
					  strdup(entry));
			address_list = g_list_next(address_list);
		}
	}
}

void placed_calls_init(LinphoneGPEUI *obj)
{
	LinphoneCore *lc = obj->core;
	GtkWidget *main_window=obj->main_window.window;
	GtkWidget *missed_calls_menu = lookup_widget(main_window, "missed_calls_menu");
	GtkWidget *received_calls_menu = lookup_widget(main_window, "received_calls_menu");
	GtkWidget *placed_calls_menu = lookup_widget(main_window, "placed_calls_menu");
	phone_menu_init(missed_calls_menu, linphone_core_get_missed_calls_list(lc));
	phone_menu_init(received_calls_menu, linphone_core_get_received_calls_list(lc));
	phone_menu_init(placed_calls_menu, linphone_core_get_placed_calls_list(lc));
	event_update_buddy_list(lc, linphone_core_get_buddy_list(lc));
}

void main_window_create(LinphoneGPEUI *obj)
{
	GtkWidget *child;
	GtkWidget *window;
	window=obj->main_window.window=create_linphone_gpe ();
	// gnome_window_icon_set_from_default(GTK_WINDOW(window));
	obj->main_window.status_bar=lookup_widget(window,"statusbar");
	obj->main_window.addressentry=lookup_widget(window,"addressentry");
	// obj->main_window.optioncontrols=lookup_widget(window,"optioncontrols");
	obj->main_window.buddies=lookup_widget(window,"buddies_treeview");
	obj->main_window.conference=lookup_widget(window,"conference_treeview");

	buddies_treeview_init(obj->main_window.buddies,window,obj->core);
	conference_treeview_init(obj->main_window.conference,window,obj->core);

	presence_box_init(&obj->main_window.presencebox,window,obj->core);
	placed_calls_init(obj);
	// set_levels(obj,linphone_core_get_rec_level(obj->core),linphone_core_get_play_level(obj->core));
	g_object_set_data(G_OBJECT(window),"ui",(gpointer)obj);

}

void linphone_gpe_ui_show(LinphoneGPEUI *ui)
{
	GtkWidget *win,*child;
	if (ui->main_window.window==NULL){
		main_window_create(ui);
		
	}
	gtk_widget_show(ui->main_window.window);
}

void linphone_gpe_ui_hide(LinphoneGPEUI *ui)
{
	if (ui->main_window.window==NULL) return;
	gtk_widget_hide(ui->main_window.window);
}


void linphone_gpe_ui_uninit(LinphoneGPEUI *ui)
{
	ui->main_window.window=NULL;
}


void linphone_gpe_ui_display_something(LinphoneGPEUI *ui,GtkMessageType type,char *message)
{
	GtkWidget *dialog;
	
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	linphone_gpe_ui_show(ui);
	dialog = gtk_message_dialog_new (GTK_WINDOW(ui->main_window.window),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  type,
                                  GTK_BUTTONS_CLOSE,
                                  (const gchar*)message);
	/* Destroy the dialog when the user responds to it (e.g. clicks a button) */
	g_signal_connect_swapped (G_OBJECT (dialog), "response",
                           G_CALLBACK (gtk_widget_destroy),
                           G_OBJECT (dialog));
	gtk_widget_show(dialog);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

/* these are the LinphoneCore virtual functions */
void linphone_gpe_display_message(LinphoneCore *lc,char *message)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	linphone_gpe_ui_display_something(ui,GTK_MESSAGE_INFO,message);
}

void linphone_gpe_display_warning(LinphoneCore *lc,char *warning)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	linphone_gpe_ui_display_something(ui,GTK_MESSAGE_WARNING,warning);
}

void linphone_gpe_display_status(LinphoneCore *lc,char *status)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	if (ui->main_window.window==NULL) return;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	gtk_statusbar_push(GTK_STATUSBAR(ui->main_window.status_bar), 0, status);
	fprintf(stderr, "%s: status=%s\n", __FUNCTION__, status);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void linphone_gpe_inv_recv(LinphoneCore *lc,char *from)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	if (ui->main_window.window==NULL) return;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	gtk_entry_set_text(GTK_ENTRY(ui->main_window.addressentry),from);
	fprintf(stderr, "%s: from=%s\n", __FUNCTION__, from);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void linphone_gpe_show(LinphoneCore *lc)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	linphone_gpe_ui_show(ui);
}

void linphone_gpe_display_url(LinphoneCore *lc, char *message, char *url)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
	// alt_ressource_display(ui,url);
	fprintf(stderr, "%s: message=%s url=%s\n", __FUNCTION__, message, url);
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void linphone_gpe_notify_recv(LinphoneCore *lc, char *event_package, char *event_body)
{
	LinphoneGPEUI *ui=(LinphoneGPEUI*)lc->data;
	if (ui->main_window.window==NULL) return;
	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();

	if (strcmp(event_package, "presence") == 0) {
	  event_notify_buddies(lc, event_package, event_body);
	} else if (strcmp(event_package, "conference") == 0) {
	  event_notify_conference(lc, event_package, event_body);
	}

	if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void stub(){
}

LinphoneCoreVTable linphone_gpe_vtable=
{
	show: linphone_gpe_show,
	inv_recv: linphone_gpe_inv_recv,
	notify_recv: linphone_gpe_notify_recv,
	bye_recv : stub,
	display_status : linphone_gpe_display_status,
	display_message : linphone_gpe_display_message,
	display_warning : linphone_gpe_display_warning,
	display_url : linphone_gpe_display_url,
	display_question : stub
};

static gboolean linphone_gpe_iterate(LinphoneCore *lc)
{
  linphone_core_iterate(lc);
  return TRUE;
}

void linphone_gpe_init(LinphoneGPEUI *ui,LinphoneCore *lc)
{
	fprintf(stderr, "linphone_gpe_init\n");
	linphone_gpe_ui_init(ui,lc);
	linphone_core_init(lc,&linphone_gpe_vtable,NULL,(gpointer)ui);
	ui->timeout_id=gtk_timeout_add(500,(GtkFunction)linphone_gpe_iterate,(gpointer)lc);
}

void linphone_gpe_uninit(LinphoneGPEUI *ui)
{
	LinphoneCore *lc=ui->core;
	linphone_gpe_ui_uninit(ui);
	linphone_core_uninit(lc);
	gtk_timeout_remove (ui->timeout_id);
}


