
#ifndef LINPHONE_GPE_H
#define LINPHONE_GPE_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <linphonecore.h>

#include "support.h"
#include "propertybox.h"
#include "presence.h"
#include "../gnome/addressbook.h"

typedef struct _LinphoneMainWindow
{
     GtkWidget *window;
     GtkWidget *status_bar;
     GtkWidget *addressentry;
     GtkWidget *optioncontrols;
     GtkWidget *buddies;
     GtkWidget *conference;
     PresenceBox presencebox;
}LinphoneMainWindow;

typedef struct _LinphoneGPEUI
{
     LinphoneMainWindow main_window;
     LinphonePropertyBox propbox;
     AddressBook	addressbook;
     LinphoneCore *core;
     guint timeout_id;
}LinphoneGPEUI;


void linphone_gpe_ui_init(LinphoneGPEUI *ui,LinphoneCore *core);
void linphone_gpe_ui_uninit(LinphoneGPEUI *ui);

void linphone_gpe_init(LinphoneGPEUI *ui,LinphoneCore *lc);
void linphone_gpe_uninit(LinphoneGPEUI *ui);

extern LinphoneGPEUI *uiobj;

#endif
