/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "msilbcdec.h"
#include "msilbcenc.h"
#include "mscodec.h"
#include <stdlib.h>
#include <stdio.h>

#ifdef HAVE_GLIB
#include <gmodule.h>
#endif

extern MSFilter * ms_ilbc_encoder_new(void);

MSCodecInfo ilbc_info={
	{
		"iLBC codec",
		0,
		MS_FILTER_AUDIO_CODEC,
		ms_ilbc_encoder_new,
		"A speech codec suitable for robust voice communication over IP"
	},
	ms_ilbc_encoder_new,
	ms_ilbc_decoder_new,
	480,
	50,
	15200,
	8000,
	97,
	"iLBC",
	1,
	1,
};

extern MSFilter * ms_ilbc_encoder_new();

void ms_ilbc_codec_init()
{
	ms_filter_register(MS_FILTER_INFO(&ilbc_info));
}

#ifdef HAVE_GLIB
gchar * g_module_check_init(GModule *module)
{
	ms_ilbc_codec_init();
	
	return NULL;
}
#else
gchar * g_module_check_init()
{
	ms_ilbc_codec_init();
	
	return NULL;
}
#endif


static MSILBCDecoderClass *ms_ilbc_decoder_class=NULL;

MSFilter * ms_ilbc_decoder_new(void)
{
	MSILBCDecoder *r;
	
	r=g_new(MSILBCDecoder,1);
	ms_ilbc_decoder_init(r);
	if (ms_ilbc_decoder_class==NULL)
	{
		ms_ilbc_decoder_class=g_new(MSILBCDecoderClass,1);
		ms_ilbc_decoder_class_init(ms_ilbc_decoder_class);
	}
	MS_FILTER(r)->klass=MS_FILTER_CLASS(ms_ilbc_decoder_class);
	return(MS_FILTER(r));
}
	

int ms_ilbc_decoder_set_property(MSILBCDecoder *obj, MSFilterProperty prop, int *value)
{
	if (obj->running){
		ms_warning("ms_ilbc_decoder_set_property: cannot call this function when running!");
		return -1;
	}
	switch(prop){
		case MS_FILTER_PROPERTY_BITRATE:
			obj->bitrate=value[0];
		break;
	}
	return 0;
}
int ms_ilbc_decoder_get_property(MSILBCDecoder *obj, MSFilterProperty prop, int *value)
{
	switch(prop){
		case MS_FILTER_PROPERTY_BITRATE:
			value[0] = obj->bitrate;
		break;
	}
	return 0;
}

void ms_ilbc_decoder_setup(MSILBCDecoder *r) 
{
	MSFilterClass *klass = NULL;
	fprintf(stderr, "%s: bitrate=%d\n", __FUNCTION__, r->bitrate);
	switch (r->bitrate) {
	case 15200:
		r->ms_per_frame = 20;
		r->samples_per_frame = BLOCKL_20MS;
		r->bytes_per_compressed_frame = NO_OF_BYTES_30MS;
		break;
	case 13333:
		r->ms_per_frame = 30;
		r->samples_per_frame = BLOCKL_30MS;
		r->bytes_per_compressed_frame = NO_OF_BYTES_30MS;
		break;
	}
	MS_FILTER(r)->r_mingran = r->bytes_per_compressed_frame;
	klass = MS_FILTER(r)->klass;
	MS_FILTER_CLASS(klass)->r_maxgran= r->bytes_per_compressed_frame;
	MS_FILTER_CLASS(klass)->w_maxgran= r->samples_per_frame*2;

	initDecode(&r->ilbc_dec, r->ms_per_frame /* ms frames */, /* user enhancer */ 0);
}


/* FOR INTERNAL USE*/
void ms_ilbc_decoder_init(MSILBCDecoder *r)
{
	/* default bitrate */
	r->bitrate = 15200;
	r->ms_per_frame = 20;
	r->samples_per_frame = BLOCKL_20MS;
	r->bytes_per_compressed_frame = BLOCKL_20MS;

	ms_filter_init(MS_FILTER(r));
	MS_FILTER(r)->infifos=r->f_inputs;
	MS_FILTER(r)->outfifos=r->f_outputs;
	MS_FILTER(r)->r_mingran = r->bytes_per_compressed_frame;
	memset(r->f_inputs,0,sizeof(MSFifo*)*MSILBCDECODER_MAX_INPUTS);
	memset(r->f_outputs,0,sizeof(MSFifo*)*MSILBCDECODER_MAX_INPUTS);
}

void ms_ilbc_decoder_class_init(MSILBCDecoderClass *klass)
{
	ms_filter_class_init(MS_FILTER_CLASS(klass));
	ms_filter_class_set_name(MS_FILTER_CLASS(klass),"ILBCDec");
	MS_FILTER_CLASS(klass)->max_finputs=MSILBCDECODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->max_foutputs=MSILBCDECODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->r_maxgran= ILBC_MAX_BYTES_PER_COMPRESSED_FRAME;
	MS_FILTER_CLASS(klass)->w_maxgran= ILBC_MAX_SAMPLES_PER_FRAME*2;
	MS_FILTER_CLASS(klass)->destroy=(MSFilterDestroyFunc)ms_ilbc_decoder_destroy;
	MS_FILTER_CLASS(klass)->set_property=(MSFilterPropertyFunc)ms_ilbc_decoder_set_property;
	MS_FILTER_CLASS(klass)->set_property=(MSFilterPropertyFunc)ms_ilbc_decoder_get_property;
	MS_FILTER_CLASS(klass)->setup=(MSFilterSetupFunc)ms_ilbc_decoder_setup;
	MS_FILTER_CLASS(klass)->process=(MSFilterProcessFunc)ms_ilbc_decoder_process;
	MS_FILTER_CLASS(klass)->info=(MSFilterInfo*)&ilbc_info;
}
	
void ms_ilbc_decoder_process(MSILBCDecoder *r)
{
	MSFifo *fi,*fo;
	int err1;
	void *src=NULL,*dst=NULL;
	float speech[ILBC_SAMPLES_PER_FRAME];
	gchar bits[ILBC_MAX_BYTES_PER_COMPRESSED_FRAME];
	
	/* process output fifos, but there is only one for this class of filter*/
	
	r->running = 1;

	fi=r->f_inputs[0];
	fo=r->f_outputs[0];
	if (fi!=NULL)
	{
		err1=ms_fifo_get_read_ptr(fi, r->bytes_per_compressed_frame, &src);
		if (err1>0)
		{
			err1=ms_fifo_get_write_ptr(fo, r->samples_per_frame*2, &dst);
			if (dst!=NULL)
			{
				ilbc_read_bits(src, bits, r->bytes_per_compressed_frame);
				iLBC_decode(speech, bits, &r->ilbc_dec, /* mode */1);
				ilbc_write_16bit_samples((gint16*)dst, speech, r->samples_per_frame);
			}
		}
	}
}

void ms_ilbc_decoder_uninit(MSILBCDecoder *obj)
{
}

void ms_ilbc_decoder_destroy( MSILBCDecoder *obj)
{
	ms_ilbc_decoder_uninit(obj);
	g_free(obj);
}
