


#include <stdlib.h>
#include <stdio.h>
#include <pthread.h>

#define ALLOCTABLE_SIZE 100000

static void  *alloctable[ALLOCTABLE_SIZE];
static int allocindex=0;
pthread_mutex_t mutex=PTHREAD_MUTEX_INITIALIZER;
void sfree(void *addr);




void * smalloc(int size)
{
	char *p;
	pthread_mutex_lock(&mutex);
	p=alloctable[allocindex]=malloc(size);
	allocindex++;
	if (allocindex==ALLOCTABLE_SIZE){
		printf("Alloc table too short...\n");
		abort();
	}
	pthread_mutex_unlock(&mutex);
	return p;
}

void *scalloc(int n, int size)
{
	char *p;
	pthread_mutex_lock(&mutex);
	p=alloctable[allocindex]=calloc(n,size);
	allocindex++;
	if (allocindex==ALLOCTABLE_SIZE){
		printf("Alloc table too short...\n");
		abort();
	}
	pthread_mutex_unlock(&mutex);
	return p;
}

void * srealloc(void *addr, int size)
{
	int i;
	if (addr==NULL ){
		return smalloc(size);
	}
	if ( size==0) {
		sfree(addr);
		return;
	}
	pthread_mutex_lock(&mutex);
	for (i=0;i<allocindex;i++){
		if (addr==alloctable[i]){
			alloctable[i]=realloc(addr,size);
			pthread_mutex_unlock(&mutex);
			return alloctable[i];
		}
	}
	printf("Bad realloc(%p,%i).\n",addr,size);
	abort();
	pthread_mutex_unlock(&mutex);
	return NULL;
}

void sfree(void *addr)
{
	int i;
	if (addr==NULL) return;
	pthread_mutex_lock(&mutex);
	for (i=0;i<allocindex;i++){
		if (addr==alloctable[i]){
			allocindex--;
			alloctable[i]=alloctable[allocindex];
			alloctable[allocindex]=NULL;
			pthread_mutex_unlock(&mutex);
			return;
		}
	}
	printf("Bad sfree(%p).\n",addr);
	abort();
	pthread_mutex_unlock(&mutex);
}
