/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "osipua.h"
#include <osip/sdp.h>
#include "osipmanager.h"
#include "resolver.h"
#include "utils.h"
#include "uatransaction.h"


void ist_kill_transaction(transaction_t * trn)
{
	osip_trace (OSIP_INFO1,("Transaction %i killed.\n", trn->transactionid));
	ua_transaction_free (trn);
}

/* this function processes invite that are not part of Dialog at the moment */
void
on_first_invite (transaction_t * trn, sip_t *sipmsg)
{
	int err=0, pos;
	OsipDialog *call;
	OsipUA *ua;
	body_t *body;
	
	/* send a 100 trying */
	osip_trace (OSIP_INFO1, ("Sending 100 trying.\n"));
	respond_to_request (def_manager->config, trn, 100);
	/* we must find a user agent interested by this new call */
	call = osip_dialog_new_from_incoming_trn (trn);
	if (call != NULL)
	{			/* the call-leg was created, there is a user agent accepting it */
		ua = osip_dialog_get_ua (call);
/* get first body, hoping it is a sdp.... more
things to do here*/
		if (ua->presence_mode != 200)
/* if the ua has presence features... */
		{
			sip_t *response;
			int i;
			i = osip_dialog_generate_response_default(
								  call,
								  ua->presence_mode,
								  trn->orig_request,&response);
			if (i==0)
			  {
			    char *val;

			    if ((ua->presence_mode == 486
				 || ua->presence_mode == 480
				 || ua->presence_mode == 600)
				&& ua->presence_delay > 0)
			      {
				val = smalloc (8);
				sprintf (val, "%i",
					 ua->presence_delay);
				msg_setheader (response,
					       "Retry-After", val);
				sfree (val);
			      }
			    if ((ua->presence_mode == 302
				 || ua->presence_mode == 380)
				&& ua->presence_contact_url != NULL)
			      {
				int i;
				i = msg_setcontact (response,
						    ua->
						    presence_contact_url);
				if (i != 0)
				  osip_trace (OSIP_ERROR,
					      ("Error in contact url: %s\n",
					       ua->
					       presence_contact_url));
			      }
			    osip_dialog_send_response (call, trn,
						       response);
				osip_dialog_set_state(call,DIALOG_TERMINATED);
			}
			else
			{
				osip_trace (OSIP_WARNING,
					    ("Could not create response for current status\n"));
			}
			return;
		}
/* check if we have some bodies in the request */
		pos = 0;
		while (msg_getbody (sipmsg, pos, &body)>=0)
		{
			BodyHandler *bh;
			BodyContext *bc;
			char *mime;
			content_type_t *ctt;
			if (body->content_type==NULL){
				/*try using the content type*/
				ctt=msg_getcontent_type(sipmsg);
				if (ctt==NULL){
					osip_trace(OSIP_WARNING,("There is no content-type !"));
					/* do something better here */
					break;
				}
				mime=content_type_get_type(ctt);
			}else mime=content_type_get_type(body->content_type);
			osip_trace (OSIP_INFO1,
				    ("Found body %s.\n",mime));
			bh = osip_ua_find_handler (ua,mime);
			sfree(mime);
			if (bh == NULL)
			{
				osip_trace (OSIP_WARNING,("Could not find a body handler .\n"));
/* Aymeric: 415 Unsupported Media Type
Here media is SDP see draft-...rfc2543-05.txt */
				respond_to_request (ua->config, trn, 415);
				return;
			}
			osip_trace(OSIP_INFO1,("Creating a new body context.\n"));
			bc=body_handler_create_context(bh,call);
			osip_dialog_add_body_context(call,bc);
			/* invoke the body handler */
			body_context_notify_inc_request(bc,sipmsg,body->body);
			pos++;
		}
/* inform the user about this invite*/
		if (ua->invite != NULL)
			err = ua->invite (call, trn,sipmsg,
					  (void *) NULL);
/* if err==0 send 180 ringing since we are successfully informing the user...*/
		if (err == 0)
		  {
		    int i;
		    sip_t *answer;
		    /* Not to be sent twice...
		       osip_dialog_respond (call, trn, 180); */
		    i = osip_dialog_generate_response_default( call, 180,
							      sipmsg,&answer);
		    if (i!=0)
		      {
			osip_trace(OSIP_WARNING,("on_first_invite: error - could not create a 180 Ringing."));
			return ;
		      }
		    osip_dialog_send_response(call, trn, answer);
		  }

	}else{
		osip_trace(OSIP_WARNING,("on_first_invite: error - could not create a new dialog."));
	}
}

/* LIK: Transfer call related functionality */
void
on_other_invite (OsipDialog *call, transaction_t * trn, sip_t *sipmsg)
{
	OsipUA *ua;
	body_t *body;
	sip_t *answer;
	int i; 
	char *s;
	int pos = 0;
	
	ua = osip_dialog_get_ua(call);

	while (msg_getbody(sipmsg, pos, &body)>=0) {
	    if ( (body->body != NULL) &&
		 ((s=strstr(body->body, "c=IN IP4 0.0.0.0")) != NULL)) {
		
		/* We were told to mute ourselves so do it */
		if (ua->mute_function != NULL)
		    ua->mute_function(call, NULL, NULL, (void*)1);

		call->status = DIALOG_MUTING;
		i = osip_dialog_generate_response_default(call, 200, 
							  sipmsg, 
							  &answer);
		if (i!=0) {
		    osip_trace(OSIP_WARNING, ("on_other_invite: error in response to mute request\n"));
		    return;
		}
		osip_dialog_send_response(call, trn, answer);
		return; /* We are done responding to the mute message */
	    }
	    pos++;
	}
	
	/* We were told to unmute ourselves so do it */
	if (ua->mute_function != NULL)
	    ua->mute_function(call, NULL, NULL, (void*)0);
	
	call->status = DIALOG_ESTABLISHED;
	i = osip_dialog_generate_response_default(call, 200, 
						  sipmsg, 
						  &answer);
	if (i!=0) {
	    osip_trace(OSIP_WARNING, ("on_other_invite: error in response to mute request\n"));
	    return;
	}
	osip_dialog_send_response(call, trn, answer);
}

void ist_invite_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *call;
	int error;
	
	osip_trace (OSIP_INFO1, ("OnEvent_New_IncomingInvite!\n"));
	error = osip_dialog_find (sipmsg,&call);
	if (error==1){
		on_other_invite(call,trn,sipmsg);
	}
	else if (error==0)
	{
		on_first_invite(trn,sipmsg);	
	}
	else
	{
		/* the transaction/request has to be ignored, it is probably a retransmission not caught by osip*/
		/* put the transaction in the free list */
		osip_remove_ict(trn->config,trn);
		fifo_add(&def_manager->garbage_trn,(void*)trn);
	}
}

void ist_ack_received(transaction_t * trn, sip_t *sipmsg)
{
	OsipDialog *call;
	OsipUA *ua;
	int state;

	osip_trace (OSIP_INFO1, ("OnEvent_New_IncomingAck!\n"));

	call = ua_transaction_get_dialog (trn);
	if (call != NULL)
	{

		/* an existing call-leg was found, so process it */
		ua = osip_dialog_get_ua (call);
		if ((state=osip_dialog_get_state (call)) == DIALOG_INVITED
		    && call->dialog!=NULL )
		{
		        dialog_set_state(call->dialog, DIALOG_CONFIRMED);
				osip_dialog_set_state (call, DIALOG_ESTABLISHED);
			/* indicate the user of the beginning of the audio session ??? */

		}
		else {
			if ( (state!=DIALOG_TERMINATED) &&
			     (state!=DIALOG_MUTING)) 
			    osip_trace(OSIP_WARNING,("ist_ack_received: dialog in bad state (%i)\n",state));
		}
	}
	else
	{
		osip_trace (OSIP_WARNING,
				("Ack for an inexistant call-leg !\n"));
		/* do not respond */
	}

	return;		/* ok */
}
