/***************************************************************************
    events.c  -  buddy/dialog/conference event package handling
                             -------------------
    begin                : November 5 2003
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libxml/parser.h>
#include <libxml/xpath.h>

#include "linphone.h"
#include "support.h"
#include "events.h"

enum buddy_list_columns {
     BL_CONTACT_COLUMN,
     BL_STATE_COLUMN,
     BL_LOCATION_COLUMN,
     BL_NCOLUMNS
};

enum conference_list_columns {
     CL_CONTACT_COLUMN,
     CL_STATE_COLUMN,
     CL_NCOLUMNS
};

enum location_list_columns {
     LL_CONTACT_COLUMN,
     LL_STATE_COLUMN,
     LL_NCOLUMNS
};

xmlDocPtr event_body_parse(char *event_body)
{
     return xmlParseMemory(event_body, strlen(event_body));
}

/*
 * apply procedure f to each xmlNodePtr in doc matched by xpath
 */
void xpath_map(xmlDocPtr doc, char *xpath, void (*f)(xmlNodePtr, void *), void *data)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  printf("No result\n");
	  return;
     }
     nodeset = result->nodesetval;
     for (i=0; i < nodeset->nodeNr; i++) {
	  xmlNodePtr node = nodeset->nodeTab[i];
	  printf("name[%d]: %s\n", i, node->name);
	  f(node, data);
     }
     xmlXPathFreeContext(context);
}

xmlNodePtr xpath_get_node(xmlDocPtr doc, char *xpath)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     xmlNodePtr node;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  printf("xpath_get_node: no result\n");
	  return;
     }
     nodeset = result->nodesetval;
     node = nodeset->nodeTab[0];
     xmlXPathFreeContext(context);
     return node;
}

xmlAttrPtr xmlNodeGetAttrByName(xmlNodePtr node, const char *name)
{
     xmlAttrPtr attr = node->properties;
     while (attr) {
	  if (xmlStrcmp(attr->name, name) == 0)
	       return attr;
	  attr = attr->next;
     }
     return NULL;
}

xmlNodePtr xmlNodeGetChildByName(xmlNodePtr node, const char *name)
{
     xmlNodePtr cur = node->children;
     while (cur) {
	  if (xmlStrcmp(cur->name, name) == 0)
	       return cur;
	  cur = cur->next;
     }
     return NULL;
}

void buddies_treeview_init(GtkWidget *buddies_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;

     store = gtk_list_store_new (BL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(buddies_treeview),GTK_TREE_MODEL(store));

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Contact",
							renderer,
							"text", BL_CONTACT_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("State",
							renderer,
							"text", BL_STATE_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Location",
							renderer,
							"text", BL_LOCATION_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);
}

void conference_treeview_init(GtkWidget *conference_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;

     store = gtk_list_store_new (CL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(conference_treeview),GTK_TREE_MODEL(store));

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Contact",
							renderer,
							"text", CL_CONTACT_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (conference_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("State",
							renderer,
							"text", CL_STATE_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (conference_treeview), column);
}

void event_notify_buddies(LinphoneCore *lc, char *event_package, char *content_type, char *event_body)
{
     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.buddies));
     xmlDocPtr doc = event_body_parse(event_body);
     xmlNodePtr presence = xpath_get_node(doc, "//presence");
     xmlAttrPtr sipuri = NULL;
     xmlNodePtr basic = xpath_get_node(doc, "//presence/tuple/status/basic");
     xmlNodePtr location = xpath_get_node(doc, "//presence/tuple/location/loc");
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     char *sipuri_text = NULL;
     char *basic_text = NULL;
     char *location_text = NULL;
     int r;
     if (!presence || ! basic || !location) {
	  fprintf(stderr, "event_notify_buddies: doc->children->name=%s\n", doc->children->name);
	  return;
     }
     sipuri = xmlNodeGetAttrByName(presence, "entity");
     sipuri_text = xmlNodeGetContent(sipuri->children);
     basic_text = xmlNodeGetContent(basic->children);
     location_text = xmlNodeGetContent(location->children);

     fprintf(stderr, "event_notify_buddies: sipuri=%p:%s basic=%p:%s location=%p:%s\n",
	     sipuri, sipuri_text, basic, basic_text, location, location_text);

     r = gtk_tree_model_get_iter_first(model, &iter);
     while (r) {
	  char *as = NULL;
	  char *dnstring = NULL;
	  gtk_tree_model_get(model, &iter, BL_CONTACT_COLUMN, &dnstring, -1);
	  if (strcmp(dnstring, sipuri_text) == 0) {
	       /* update this one */
	       gtk_list_store_set(list_store, &iter, BL_STATE_COLUMN, strdup(basic_text), -1);
	       gtk_list_store_set(list_store, &iter, BL_LOCATION_COLUMN, strdup(location_text), -1);
	       return;
	  }
	  r = gtk_tree_model_iter_next(model, &iter);
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, BL_CONTACT_COLUMN,
			strdup(sipuri_text),-1);
     gtk_list_store_set(list_store, &iter, BL_STATE_COLUMN,
			strdup(basic_text),-1);
     gtk_list_store_set(list_store, &iter, BL_LOCATION_COLUMN,
			strdup(location_text),-1);
}


void event_update_conference_user(xmlNodePtr user, void *lc_)
{
     LinphoneCore *lc = lc_;
     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.conference));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     char *sipuri_text = NULL;
     char *display_name_text = NULL;
     char *activity_status_text = NULL;
     int r;

     xmlAttrPtr sipuri = xmlNodeGetAttrByName(user, "uri");
     xmlAttrPtr display_name = xmlNodeGetAttrByName(user, "display-name");
     xmlNodePtr activity_status = xmlNodeGetChildByName(user, "activity-status");
     xmlNodePtr history_status = xmlNodeGetChildByName(user, "history-status");
     if (sipuri_text)
	  sipuri_text = xmlNodeGetContent(sipuri->children);
     if (display_name)
	  display_name_text = xmlNodeGetContent(display_name->children);
     if (activity_status)
	  activity_status_text = xmlNodeGetContent(activity_status);

     fprintf(stderr, "event_update_conference_user: uri=%s display-name=%s activity-status=%s\n",
	     sipuri_text, display_name_text, activity_status_text);
     
     if (1) {
	  r = gtk_tree_model_get_iter_first(model, &iter);
	  while (r) {
	       char *as = NULL;
	       char *dnstring = NULL;
	       gtk_tree_model_get(model, &iter, CL_CONTACT_COLUMN, &dnstring, -1);
	       if (strcmp(dnstring, display_name_text) == 0) {
		    /* update this one */
		    gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN, strdup(activity_status_text), -1);
		    return;
	       }
	       r = gtk_tree_model_iter_next(model, &iter);
	  }
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, CL_CONTACT_COLUMN,
			strdup(display_name_text),-1);
     gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN,
			strdup(activity_status_text),-1);

}

void event_notify_conference(LinphoneCore *lc, char *event_package, char *content_type, char *event_body)
{
     xmlDocPtr doc = event_body_parse(event_body);
     xmlNodePtr conference_info = NULL;
     xmlAttrPtr entity = NULL;
     
     fprintf(stderr, "event_body=%s, doc=%p\n\n", event_body, doc);
     if (!doc) return;
     conference_info = xpath_get_node(doc, "//conference-info");
     fprintf(stderr, "conference_info=%p\n", conference_info);

     if (conference_info) {
	  entity = xmlNodeGetAttrByName(conference_info, "entity");
	  fprintf(stderr, "event_notify_conference: entity=%s\n", 
		  xmlNodeGetContent(entity->children));
	  xpath_map(doc, "//conference-info/user", event_update_conference_user, lc);
     }

}
