/***************************************************************************
    events.c  -  buddy/dialog/conference event package handling
                             -------------------
    begin                : November 5 2003
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libxml/parser.h>
#include <libxml/xpath.h>

#include "linphone-gpe.h"
#include "support.h"
#include "events.h"

enum buddy_list_columns {
     BL_CONTACT_COLUMN,
     BL_STATE_COLUMN,
     BL_LOCATION_COLUMN,
     BL_NCOLUMNS
};

enum conference_list_columns {
     CL_CONTACT_COLUMN,
     CL_STATE_COLUMN,
     CL_NCOLUMNS
};

enum location_list_columns {
     LL_CONTACT_COLUMN,
     LL_STATE_COLUMN,
     LL_NCOLUMNS
};

xmlDocPtr event_body_parse(char *event_body)
{
     return xmlParseMemory(event_body, strlen(event_body));
}

/*
 * apply procedure f to each xmlNodePtr in doc matched by xpath
 */
void xpath_map(xmlDocPtr doc, char *xpath, void (*f)(xmlNodePtr, void *), void *data)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  fprintf(stderr, "xpath_map: no result for xpath=%s\n", xpath);
	  return;
     }
     nodeset = result->nodesetval;
     for (i=0; i < nodeset->nodeNr; i++) {
	  xmlNodePtr node = nodeset->nodeTab[i];
	  printf("name[%d]: %s\n", i, node->name);
	  f(node, data);
     }
     xmlXPathFreeContext(context);
}

xmlNodePtr xpath_get_node(xmlDocPtr doc, char *xpath)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     xmlNodePtr node;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  fprintf(stderr, "xpath_get_node: no result for xpath=%s\n", xpath);
	  return NULL;
     }
     nodeset = result->nodesetval;
     node = nodeset->nodeTab[0];
     xmlXPathFreeContext(context);
     return node;
}

xmlAttrPtr xmlNodeGetAttrByName(xmlNodePtr node, const char *name)
{
     xmlAttrPtr attr = node->properties;
     fprintf(stderr, "getattrbyname: node=%p:%s attr=%p name=%s\n", node, node->name, attr, name);
     while (attr) {
	  fprintf(stderr, "  getattrbyname: node=%s attr=%s\n", node->name, attr->name);
	  if (xmlStrcmp(attr->name, name) == 0)
	       return attr;
	  attr = attr->next;
     }
     return NULL;
}

xmlNodePtr xmlNodeGetChildByName(xmlNodePtr node, const char *name)
{
     xmlNodePtr cur = node->children;
     while (cur) {
	  if (xmlStrcmp(cur->name, name) == 0)
	       return cur;
	  cur = cur->next;
     }
     return NULL;
}

xmlNodePtr xmlNodeGetNodeByName(xmlNodePtr node, const char *name, const char *ns)
{
	xmlNodePtr cur = node;
	while (cur) {
		xmlNodePtr match = NULL;
		if (xmlStrcmp(cur->name, name) == 0) {
			if (!ns || (cur->ns && xmlStrcmp(cur->ns->prefix, ns) == 0))
				return cur;
		}
		match = xmlNodeGetNodeByName(cur->children, name, ns);
		if (match)
			return match;
		cur = cur->next;
	}
	return NULL;
}

xmlNodePtr xmlDocGetNodeByName(xmlDocPtr doc, const char *name, const char *ns)
{
	xmlNodePtr cur = doc->children;
	return xmlNodeGetNodeByName(cur, name, ns);
}

void xmlNodeMapByName(xmlNodePtr node, const char *name, const char *ns, 
		      void (f)(xmlNodePtr, void*), void *data)
{
	xmlNodePtr cur = node;
	if (!f)
		return;
	while (cur) {
		xmlNodePtr match = NULL;
		if (xmlStrcmp(cur->name, name) == 0) {
			if (!ns || (cur->ns && xmlStrcmp(cur->ns->prefix, ns) == 0))
				f(cur, data);
		}
		/* visit children */
		xmlNodeMapByName(cur->children, name, ns, f, data);

		cur = cur->next;
	}
}

xmlNodePtr xmlDocMapByName(xmlDocPtr doc, const char *name, const char *ns,
			   void (f)(xmlNodePtr, void*), void *data )
{
	xmlNodePtr cur = doc->children;
	xmlNodeMapByName(cur, name, ns, f, data);
}

void buddies_treeview_init(GtkWidget *buddies_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;

     store = gtk_list_store_new (BL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(buddies_treeview),GTK_TREE_MODEL(store));

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Contact",
							renderer,
							"text", BL_CONTACT_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("State",
							renderer,
							"text", BL_STATE_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Location",
							renderer,
							"text", BL_LOCATION_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);
}

void conference_treeview_init(GtkWidget *conference_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;

     store = gtk_list_store_new (CL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(conference_treeview),GTK_TREE_MODEL(store));

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("Contact",
							renderer,
							"text", CL_CONTACT_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (conference_treeview), column);

     renderer = gtk_cell_renderer_text_new ();
     column = gtk_tree_view_column_new_with_attributes ("State",
							renderer,
							"text", CL_STATE_COLUMN,
							NULL);
     gtk_tree_view_column_set_resizable(column, 1);
     gtk_tree_view_column_set_clickable(column, 1);
     gtk_tree_view_append_column (GTK_TREE_VIEW (conference_treeview), column);
}

void event_update_buddy_list(LinphoneCore *lc, GList *buddies)
{
     while (buddies != NULL) {
	  if (buddies->data) {
	       event_update_buddy(lc, buddies->data, NULL, NULL);
	       linphone_core_subscribe(lc, buddies->data, "presence", "application/pidf+xml");
	  }
	  buddies = g_list_next(buddies);
     }
}

void event_update_buddy(LinphoneCore *lc, gchar *sipuri, gchar *basic, gchar *location)
{

     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.buddies));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     int r;

     r = gtk_tree_model_get_iter_first(model, &iter);
     while (r) {
	  char *as = NULL;
	  char *dnstring = NULL;
	  gtk_tree_model_get(model, &iter, BL_CONTACT_COLUMN, &dnstring, -1);
	  if (strcmp(dnstring, sipuri) == 0) {
	       /* update this one */
	       goto update;
	  }
	  r = gtk_tree_model_iter_next(model, &iter);
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, BL_CONTACT_COLUMN,
			strdup(sipuri),-1);
     /* also add it to lc->buddy_list */
     if (0)
	  if (!g_list_find_custom(lc->ui_conf.buddy_list, sipuri, strcmp))
	       lc->ui_conf.buddy_list = g_list_append(lc->ui_conf.buddy_list, g_strdup(sipuri));

 update:
     if (basic)
	  gtk_list_store_set(list_store, &iter, BL_STATE_COLUMN,
			     strdup(basic),-1);
     if (location)
	  gtk_list_store_set(list_store, &iter, BL_LOCATION_COLUMN,
			     strdup(location),-1);

}

void event_notify_buddies(LinphoneCore *lc, gchar *event_package, char *content_type, gchar *event_body)
{
     xmlDocPtr doc = NULL;
     GtkTreeIter iter;

     char *sipuri_text = NULL;
     char *basic_text = "unknown";
     char *location_text = "noplace";
     int r;

     doc = event_body_parse(event_body);
     fprintf(stderr, "content_type=%s bodytext=%s\n", content_type, event_body);
     if (!doc) {
	  fprintf(stderr, "event_notify_buddies: could not parse body\n %s\n", event_body);
	  return;
     }
     if (strcmp(content_type, "application/pidf+xml") == 0) {
	  xmlNodePtr presence = xmlDocGetNodeByName(doc, "presence", NULL);
	  xmlNodePtr tuple = xmlDocGetNodeByName(doc, "tuple", NULL);
	  xmlNodePtr basic = xmlDocGetNodeByName(doc, "basic", NULL);
	  xmlNodePtr location = xmlDocGetNodeByName(doc, "loc", NULL);
	  xmlAttrPtr sipuri_attr = NULL;
	  fprintf(stderr, "doc=%p doc->children=%p presence=%p basic=%p location=%p\n", 
		  doc, doc->children, presence, basic, location);
	  fprintf(stderr, "presence->props=%p tuple=%p tuple->props=%p\n",
		  presence->properties, tuple, tuple->properties);
	  if (!presence || !basic) {
	       fprintf(stderr, "event_notify_buddies: doc->name=%s\n", doc->name);
	       return;
	  }
	  sipuri_attr = xmlNodeGetAttrByName(presence, "entity");
	  if (sipuri_attr) {
	       sipuri_text = xmlNodeGetContent(sipuri_attr->children);
	  } else {
	       /* try again */
	       xmlNodePtr contact = xmlDocGetNodeByName(doc, "contact", NULL);
	       if (contact)
		    sipuri_text = xmlNodeGetContent(contact->children);
	  }
	  if (basic)
	       basic_text = xmlNodeGetContent(basic->children);
	  if (location)
	       location_text = xmlNodeGetContent(location->children);
     } else {
	  /* xpidf */
	  xmlNodePtr presence = xmlDocGetNodeByName(doc, "presence", NULL);
	  xmlNodePtr address = xmlDocGetNodeByName(doc, "address", NULL);
	  xmlNodePtr status = xmlDocGetNodeByName(doc, "status", NULL);
	  if (address) {
	       xmlAttrPtr uriattr = xmlNodeGetAttrByName(address, "uri");
	       if (uriattr) {
		    sipuri_text = xmlNodeGetContent(uriattr->children);
	       }
	  }
	  if (status) {
	       xmlAttrPtr statusattr = xmlNodeGetAttrByName(status, "status");
	       if (statusattr) {
		    basic_text = xmlNodeGetContent(statusattr->children);
	       }
	  }
     }

     fprintf(stderr, "event_notify_buddies: sipuri=%s basic=%s location=%s\n",
	     sipuri_text, basic_text, location_text);

     if (sipuri_text)
	  event_update_buddy(lc, sipuri_text, basic_text, location_text);

}


void event_update_conference_user(xmlNodePtr user, void *lc_)
{
     LinphoneCore *lc = lc_;
     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.conference));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     char *sipuri_text = NULL;
     char *display_name_text = NULL;
     char *activity_status_text = NULL;
     int r;

     xmlAttrPtr sipuri = xmlNodeGetAttrByName(user, "uri");
     xmlAttrPtr display_name = xmlNodeGetAttrByName(user, "display-name");
     xmlNodePtr activity_status = xmlNodeGetChildByName(user, "activity-status");
     xmlNodePtr history_status = xmlNodeGetChildByName(user, "history-status");
     if (sipuri_text)
	  sipuri_text = xmlNodeGetContent(sipuri->children);
     if (display_name)
	  display_name_text = xmlNodeGetContent(display_name->children);
     if (activity_status)
	  activity_status_text = xmlNodeGetContent(activity_status);

     fprintf(stderr, "event_update_conference_user: uri=%s display-name=%s activity-status=%s\n",
	     sipuri_text, display_name_text, activity_status_text);
     
     if (1) {
	  r = gtk_tree_model_get_iter_first(model, &iter);
	  while (r) {
	       char *as = NULL;
	       char *dnstring = NULL;
	       gtk_tree_model_get(model, &iter, CL_CONTACT_COLUMN, &dnstring, -1);
	       if (strcmp(dnstring, display_name_text) == 0) {
		    /* update this one */
		    gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN, strdup(activity_status_text), -1);
		    return;
	       }
	       r = gtk_tree_model_iter_next(model, &iter);
	  }
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, CL_CONTACT_COLUMN,
			strdup(display_name_text),-1);
     gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN,
			strdup(activity_status_text),-1);

}

void event_notify_conference(LinphoneCore *lc, char *event_package, char *content_type, char *event_body)
{
     xmlDocPtr doc = event_body_parse(event_body);
     xmlNodePtr conference_info = NULL;
     xmlAttrPtr entity = NULL;
     
     fprintf(stderr, "event_body=%s, doc=%p\n\n", event_body, doc);
     if (!doc) return;
     conference_info = xmlDocGetNodeByName(doc, "conference-info", NULL);
     fprintf(stderr, "conference_info=%p\n", conference_info);

     if (conference_info) {
	  entity = xmlNodeGetAttrByName(conference_info, "entity");
	  fprintf(stderr, "event_notify_conference: entity=%s\n", 
		  xmlNodeGetContent(entity->children));
	  xmlDocMapByName(doc, "user", NULL, event_update_conference_user, lc);
     }

}

