/*
  The mediastreamer library aims at providing modular media processing and I/O
	for linphone, but also for any telephony application.
  Copyright (C) 2001  Simon MORLAT simon.morlat@linphone.org
  										
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "msavencoder.h"


static MSAVEncoderClass *ms_avencoder_class=NULL;

MSFilter *ms_h263_encoder_new()
{
	return ms_AVencoder_new_with_codec(CODEC_ID_H263);
}

MSFilter *ms_mpeg_encoder_new()
{
	return ms_AVencoder_new_with_codec(CODEC_ID_MPEG1VIDEO);
}

MSFilter *ms_mpeg4_encoder_new()
{
	return ms_AVencoder_new_with_codec(CODEC_ID_MPEG4);
}

MSFilter * ms_AVencoder_new_with_codec(enum CodecID codec_id)
{
	MSAVEncoder *enc;
	AVCodec *avc;
	enc=g_malloc(sizeof(MSAVEncoder));
	if (ms_avencoder_class==NULL)
	{
		 ms_avencoder_class=g_malloc(sizeof(MSAVEncoderClass));
		 ms_AVencoder_class_init(ms_avencoder_class);
	}
	MS_FILTER(enc)->klass=(MSFilterClass*)ms_avencoder_class;
	avc=avcodec_find_encoder(codec_id);
	if (avc==NULL) g_error("unknown av codec.");
	ms_AVencoder_init(enc,avc);
	return MS_FILTER(enc);
}


void ms_AVencoder_init(MSAVEncoder *enc, AVCodec *codec)
{
	gint error;
	AVCodecContext *c=&enc->av_context;
	
	ms_filter_init(MS_FILTER(enc));
	MS_FILTER(enc)->inqueues=enc->q_inputs;
	MS_FILTER(enc)->outqueues=enc->q_outputs;
	/* put default values */
    memset(c, 0, sizeof(AVCodecContext));

    /* put sample parameters */
    c->bit_rate = 400000;
    /* resolution must be a multiple of two */
    c->width = 352;  
    c->height = 288;
    /* frames per second */
    c->frame_rate = 8 * FRAME_RATE_BASE;  
    c->gop_size = 5; /* emit one intra frame every five frames */
	
	enc->av_opened=0;
	enc->av_codec=codec;
	enc->tmpbuf=NULL;
}

void ms_AVencoder_class_init(MSAVEncoderClass *klass)
{
	ms_filter_class_init(MS_FILTER_CLASS(klass));
	MS_FILTER_CLASS(klass)->max_qinputs=MSAVENCODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->max_qoutputs=MSAVENCODER_MAX_INPUTS;
	MS_FILTER_CLASS(klass)->r_maxgran=0;
	MS_FILTER_CLASS(klass)->w_maxgran=0;
	MS_FILTER_CLASS(klass)->destroy=(MSFilterDestroyFunc)ms_AVencoder_destroy;
	MS_FILTER_CLASS(klass)->process=(MSFilterProcessFunc)ms_AVencoder_process;
	ms_filter_class_set_name(MS_FILTER_CLASS(klass),"AVEncoder");
	
}

void ms_AVencoder_uninit(MSAVEncoder *enc)
{
	avcodec_close(&enc->av_context);
	if (enc->tmpbuf!=NULL) {
		ms_buffer_destroy(enc->tmpbuf);
		enc->tmpbuf=NULL;
	}
		
}
void ms_AVencoder_destroy( MSAVEncoder *obj)
{
	ms_AVencoder_uninit(obj);
	g_free(obj);
}


void ms_AVencoder_process(MSAVEncoder *r)
{
	AVPicture orig;
	AVPicture pict;
	AVCodecContext *c=&r->av_context;
	MSQueue *inq,*outq;
	MSMessage *inm,*outm;
	MSBuffer *buf=NULL;
	gint error;
	gint osize;
	
	inq=r->q_inputs[0];
	outq=r->q_outputs[0];
	
	/* get a picture from the input queue */
	inm=ms_queue_get(inq);
	g_return_if_fail(inm!=NULL);

	if (!r->av_opened){
		error=avcodec_open(c, r->av_codec);
		ms_trace("image format is %i.",c->pix_fmt);
		if (error!=0) {
			g_warning("avcodec_open() failed: %i",error);
			return;
		}else r->av_opened=1;
	}
	/* convert image if necessary */
	if (r->input_pix_fmt!=c->pix_fmt){
		ms_trace("Changing picture format.");
		avpicture_fill(&orig,inm->data,r->input_pix_fmt,c->width,c->height);
		/* allocate a new image */
		if (r->tmpbuf==NULL) 
			r->tmpbuf=ms_buffer_new(avpicture_get_size(c->pix_fmt,c->width,c->height));
		avpicture_fill(&pict,r->tmpbuf->buffer,c->pix_fmt,c->width,c->height);
		img_convert(&pict,c->pix_fmt,&orig,r->input_pix_fmt,c->width,c->height);
		//if (pict.data[0]==NULL) g_error("img_convert failed.");
	}
	else 
	{
		avpicture_fill(&pict,inm->data,c->pix_fmt,c->width,c->height);
	}
	osize=100000;
	outm=ms_message_new(osize); /*REVIST: how to know the output buffer size ? */
    error=avcodec_encode_video(c,outm->data,osize,&pict);
    if (error<=0) ms_warning("ms_AVencoder_process: error %i.",error);
	else {
		outm->size=error;
	}
	ms_queue_put(outq,outm);
	
    ms_message_destroy(inm);
}

gint ms_AVencoder_set_format(MSAVEncoder *enc, gchar *fmt)
{
	gint format;
	if (strcmp(fmt,"YUV420P")==0) format=PIX_FMT_YUV420P;
	else if (strcmp(fmt,"YUV422")==0) format=PIX_FMT_YUV422;
	else if (strcmp(fmt,"RGB24")==0) format=PIX_FMT_RGB24;	
	else if (strcmp(fmt,"BGR24")==0) format=PIX_FMT_BGR24;
	else if (strcmp(fmt,"YUV422P")==0) format=PIX_FMT_YUV422P;
	else if (strcmp(fmt,"YUV444P")==0) format=PIX_FMT_YUV444P;
	else {
		g_warning("ms_AVdecoder_set_format: unsupported format %s.",fmt);
		return -1;
	}
	enc->input_pix_fmt=format;
	
	return 0;
}

