 /*
  * The osipua library is a library based on oSIP that implements CallLeg and User Agent
  * level.
  * Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  * Aymeric MOIZARD jack@atosc.org
  *
  * Copyright (C) 2003 Hewlett-Packard Company
  *
  * This library is free software; you can redistribute it and/or
  * modify it under the terms of the GNU Lesser General Public
  * License as published by the Free Software Foundation; either
  * version 2.1 of the License, or (at your option) any later version.
  * 
  * This library is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  * Lesser General Public License for more details.
  * 
  * You should have received a copy of the GNU Lesser General Public
  * License along with this library; if not, write to the Free Software
  * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
  */

#include "cpimhandler.h"
#include "utils.h"

#ifdef INET6
#include <netdb.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

#ifdef HAVE_IFADDRS_H
#include <ifaddrs.h>
#endif
#endif

int
cpim_payload_init (CpimPayload * payload)
{
	memset (payload, 0, sizeof (CpimPayload));
	return 0;
}

void
cpim_payload_uninit (CpimPayload * payload)
{

}

static CpimHandlerClass *cpim_handler_class = NULL;

void
cpim_handler_init (CpimHandler * config)
{
	memset (config, 0, sizeof (CpimHandler));
	body_handler_init (BODY_HANDLER (config));
}

static void
stub ()
{
}

void
cpim_handler_class_init (CpimHandlerClass * klass, char *mimetype)
{
	BodyHandlerClass *bklass = BODY_HANDLER_CLASS (klass);
	body_handler_class_init (bklass);
	bklass->mime_type = mimetype;
	bklass->_body_context_new = (BodyContextNewFunc) cpim_context_new;
	bklass->_init = (BodyHandlerFunc) stub;

}

BodyHandler *
cpim_handler_new (char *mimetype)
{
	CpimHandler *obj;
	if (cpim_handler_class == NULL)
	{
		cpim_handler_class = smalloc (sizeof (CpimHandlerClass));
		cpim_handler_class_init (cpim_handler_class, mimetype);
	}
	obj = smalloc (sizeof (CpimHandler));
	cpim_handler_init (obj);
	BODY_HANDLER (obj)->klass = BODY_HANDLER_CLASS (cpim_handler_class);
	return BODY_HANDLER (obj);
}


void
cpim_handler_uninit (CpimHandler * config)
{

}

void
cpim_handler_destroy (CpimHandler * obj)
{
	cpim_handler_uninit (obj);
	sfree (obj);
}

