#include <string.h>
#include <unistd.h>
#include <signal.h>
#include "osipua.h"
#include "sdphandler.h"
#include <osip/port.h>

/* this is a small test program for the osipua library */

void server(void);
void client(char *url);
void stop_func(int signum);
int invite_cb(OsipDialog *cl,transaction_t *trn, sip_t *msg,void*p);
int bye_cb(OsipDialog *cl,transaction_t *trn, sip_t *msg,void*p);
int invite_accepted_cb(OsipDialog *cl,transaction_t *trn, sip_t *msg,void*p);
int notify_cb(OsipDialog *cl,transaction_t *trn, sip_t *msg,void*p);
int run_cond=1;


static char *usage="usage: osipua_tester [-c] [-s] <sip url>\n";

char *local_sipurl;

int main(int argc, char *argv[])
{
	url_t *url;
	int err;
	char *loc,*rem;
	
	url_init(&url);
	osipua_init();
	signal(SIGINT,stop_func);
	if (argc<2)
	{
		printf(usage);
		return(-1);
	}
	
	/* get local address */
	loc=getenv("SIPURL");
	if (loc!=NULL){
		err=url_parse(url,loc);
		if (err<0){
			printf("Env variable SIPURL is set to a bad formuled sip url: %s\n",loc);
			return -1;
		}
		url_free(url);
		sfree(url);
		local_sipurl=sgetcopy(loc);
	}
	else
	{
		printf("Env variable SIPURL is not set. Using <sip:toto@127.0.0.1> as a default local sip url.\n");
		local_sipurl=sgetcopy("<sip:toto@127.0.0.1>");
	}
	TRACE_INITIALIZE(OSIP_INFO4,NULL);
	if (strcmp(argv[1],"-s")==0) server();
	else if (strcmp(argv[1],"-c")==0) {
		if (argc<3) {
			printf(usage);
			return -1;
		}
		rem=sgetcopy(argv[2]);
		url_init(&url);
		err=url_parse(url,rem);
		if (err<0){
			printf("Bad sip url: %s\n",argv[2]);
			return -1;
		}
		url_free(url);
		client(rem);
	}
	else return(-1);
	return(0);
}

int codec_pt[3]={0,3,8};
char *codec_rtpmap[3]={"PCMU/8000/1","GSM/8000/1","PCMA/8000/1"};

int set_audio_offer(SdpHandler *sdph, SdpContext *ctx)
{
	SdpPayload payload;
	int i;
	for (i=0;i<3;i++){
		sdp_payload_init(&payload);
		payload.localport=8888;
		payload.pt=codec_pt[i];
		payload.a_rtpmap=codec_rtpmap[i];
		sdp_handler_add_audio_payload(sdph,ctx,&payload);
	}
	return 0;
}

void client(char *callee)
{
	OsipUA *ua;
	OsipDialog *dialog;
	BodyHandler *sdph;
	BodyHandler *cpimh;

	/* create the ua */
	ua=osip_ua_new();
	osip_ua_set_contact(ua,local_sipurl);
	osip_ua_set_max_dialogs(ua,1);
	/* set some callbacks */
	osip_ua_signal_connect(ua,"INVITE_ACCEPTED",invite_accepted_cb);
	osip_ua_signal_connect(ua,"BYE",bye_cb);
	osip_ua_signal_connect(ua,"NOTIFY",notify_cb);

	/* create a sdp handler and bind it to the ua */
	sdph=sdp_handler_new();
	sdp_handler_set_write_offer_fcn(SDP_HANDLER(sdph),set_audio_offer,NULL);
	osip_ua_add_body_handler(ua,sdph);
	
	/* create a cpim handler and bind it to the ua */
	cpimh=cpim_handler_new();
	osip_ua_add_body_handler(ua,cpimh);
	
	// dialog=osip_dialog_new(ua);
	// osip_dialog_invite(dialog,callee,"application/sdp");

	dialog=osip_dialog_new(ua);
	fprintf(stderr, "callee=%s\n", callee);
	dialog->expires = 3600; /* fixme: arbitrary subscription time */
	osip_dialog_subscribe(dialog, callee, "presence", "application/pidf+xml");

	osip_trace(OSIP_INFO3,("info: sleeping...\n"));
	while (run_cond) sleep(1);
	//scanf("%i",&err);
	dialog=osip_ua_get_dialog(ua,0);
	if (dialog!=NULL){
		osip_dialog_bye(dialog);
		sleep(1);	/* to wait for the 200 OK */
	}
	osip_trace(OSIP_INFO1,("info: exiting...\n"));
	osip_ua_destroy(ua);
	exit(1);
}

int accept_audio_codecs(SdpHandler *sdph,SdpContext *ctx,SdpPayload *payload)
{
	/* accept everything...*/
	payload->localport=9999;
	return 0;
}

void server(void)
{
	OsipUA *ua;
	BodyHandler *sdph;
	OsipDialog *dia;
	/* create the ua */
	ua=osip_ua_new();
	/* set a sending socket different to let client and server running on the same host */
	osip_manager_set_send_port(ua->manager,5070);
	osip_ua_set_contact(ua,local_sipurl);
	osip_ua_set_max_dialogs(ua,1);
	/* set some callbacks */
	osip_ua_signal_connect(ua,"INVITE",invite_cb);
	osip_ua_signal_connect(ua,"BYE",bye_cb);
	
	/* create a sdp handler to give the ua some sdp capabilities */
	sdph=sdp_handler_new();
	sdp_handler_set_accept_offer_fcn(SDP_HANDLER(sdph),accept_audio_codecs,NULL);
	osip_ua_add_body_handler(ua,sdph);

	osip_trace(OSIP_INFO1,("sleeping...\n"));
	while (run_cond) sleep(1);	
	/* end the pending dialog, if exist */
	dia=osip_ua_get_dialog(ua,0);
	if (dia!=NULL){
		osip_dialog_bye(dia);
		sleep(1);	/* to wait for the 200 OK */
	}
	//scanf("%i",&err);
	osip_trace(OSIP_INFO1,("exiting...\n"));
	osip_ua_destroy(ua);
	exit(1);
}

int invite_cb(OsipDialog *cl,transaction_t *trn, sip_t *sipmsg,void*p)
{
	char *from;
	
	from_2char(sipmsg->from,&from);
	osip_trace(OSIP_INFO1,("Receiving invite from %s.\n",from));
	sfree(from);
	sleep(1);
	osip_trace(OSIP_INFO1,("Accepting invite.\n"));
	osip_dialog_accept_invite(cl,trn);
	return(0);
}

int bye_cb(OsipDialog *cl,transaction_t *trn,sip_t *sipmsg,void*p)
{
	char *from;
	from_2char(sipmsg->from,&from);
	osip_trace(OSIP_INFO1,("info: Receiving bye from %s.\n",from));
	sfree(from);
	return(0);
}	

int notify_cb(OsipDialog *cl,transaction_t *trn,sip_t *sipmsg,void*p)
{
	char *from;
	from_2char(sipmsg->from,&from);
	osip_trace(OSIP_INFO1,("info: Receiving notify from %s.\n",from));
	sfree(from);
	return(0);
}	

int invite_accepted_cb(OsipDialog *cl,transaction_t *trn,sip_t *msg,void*p)
{
	
	osip_trace(OSIP_INFO1,("info: Invite accepted by remote server!\n"));
	
	return(0);
}

void stop_func(int signum)
{
	run_cond=0;
}

