/*
linphone
Copyright (C) 2000  Simon MORLAT (simon.morlat@free.fr)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#ifndef OSIPUACB_H
#define OSIPUACB_H
#include <osipua.h>
#include "../osipua/src/sdphandler.h"

int invite_accepted_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int bye_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int failure_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int invite_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int informative_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int subscribe_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int subscribe_accepted_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int notify_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int message_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int mute_func_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int byetransfer_func_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int refertransfer_func_cb(OsipDialog *, transaction_t *, sip_t *, void *);
int notifytransfer_func_cb(OsipDialog *, transaction_t *, sip_t *, void *);


/* these are the SdpHandler callbacks: we are called in to be aware of the content
of the SDP messages exchanged */

int set_audio_offer(SdpHandler *sdph,SdpContext *ctx);
int set_video_offer(SdpHandler *sdph,SdpContext *ctx);
int accept_audio_offer(SdpHandler *sdph,SdpContext *ctx,SdpPayload *payload);
int accept_video_offer(SdpHandler *sdph,SdpContext *ctx,SdpPayload *payload);
int read_audio_answer(SdpHandler *sdph,SdpContext *ctx,SdpPayload *payload);
int read_video_answer(SdpHandler *sdph,SdpContext *ctx,SdpPayload *payload);

#endif
