/***************************************************************************
    xml.c  -  xml utilities 
                             -------------------
    begin                : November 5 2003
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <libxml/parser.h>
#include <libxml/xpath.h>

/*
 * apply procedure f to each xmlNodePtr in doc matched by xpath
 */
void xpath_map(xmlDocPtr doc, char *xpath, void (*f)(xmlNodePtr, void *), void *data)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  fprintf(stderr, "xpath_map: no result for xpath=%s\n", xpath);
	  return;
     }
     nodeset = result->nodesetval;
     for (i=0; i < nodeset->nodeNr; i++) {
	  xmlNodePtr node = nodeset->nodeTab[i];
	  printf("name[%d]: %s\n", i, node->name);
	  f(node, data);
     }
     xmlXPathFreeContext(context);
}

xmlNodePtr xpath_get_node(xmlDocPtr doc, char *xpath)
{
     xmlXPathContextPtr context;
     xmlXPathObjectPtr result;
     xmlNodeSetPtr nodeset;
     xmlNodePtr node;
     int i;

     context = xmlXPathNewContext(doc);
     result = xmlXPathEvalExpression(xpath, context);
     if(xmlXPathNodeSetIsEmpty(result->nodesetval)){
	  fprintf(stderr, "xpath_get_node: no result for xpath=%s\n", xpath);
	  return NULL;
     }
     nodeset = result->nodesetval;
     node = nodeset->nodeTab[0];
     xmlXPathFreeContext(context);
     return node;
}

xmlAttrPtr xmlNodeGetAttrByName(xmlNodePtr node, const char *name)
{
     if (node == NULL)
	  return NULL;
     xmlAttrPtr attr = node->properties;
     fprintf(stderr, "getattrbyname: node=%p:%s attr=%p name=%s\n", node, node->name, attr, name);
     while (attr) {
	  fprintf(stderr, "  getattrbyname: node=%s attr=%s\n", node->name, attr->name);
	  if (xmlStrcmp(attr->name, name) == 0)
	       return attr;
	  attr = attr->next;
     }
     return NULL;
}

char *xmlNodeGetAttrContentByName(xmlNodePtr node, const char *name)
{
     xmlAttrPtr attr = xmlNodeGetAttrByName(node, name);
     if (attr)
	  return xmlNodeGetContent(attr->children);
     else
	  return NULL;
}


xmlNodePtr xmlNodeGetChildByName(xmlNodePtr node, const char *name)
{
     xmlNodePtr cur = node->children;
     while (cur) {
	  if (xmlStrcmp(cur->name, name) == 0)
	       return cur;
	  cur = cur->next;
     }
     return NULL;
}

xmlNodePtr xmlNodeGetNodeByName(xmlNodePtr node, const char *name, const char *ns)
{
	xmlNodePtr cur = node;
	while (cur) {
		xmlNodePtr match = NULL;
		if (xmlStrcmp(cur->name, name) == 0) {
			if (!ns || (cur->ns && xmlStrcmp(cur->ns->prefix, ns) == 0))
				return cur;
		}
		match = xmlNodeGetNodeByName(cur->children, name, ns);
		if (match)
			return match;
		cur = cur->next;
	}
	return NULL;
}

xmlNodePtr xmlDocGetNodeByName(xmlDocPtr doc, const char *name, const char *ns)
{
	xmlNodePtr cur = doc->children;
	return xmlNodeGetNodeByName(cur, name, ns);
}

char *xmlDocGetNodeContentByName(xmlDocPtr doc, const char *name, const char *ns)
{
	xmlNodePtr node = xmlDocGetNodeByName(doc, name, ns);
	if (node)
		return xmlNodeGetContent(node->children);
	else
		return NULL;
}

void xmlNodeMapByName(xmlNodePtr node, const char *name, const char *ns, 
		      void (f)(xmlNodePtr, void*), void *data)
{
	xmlNodePtr cur = node;
	if (!f)
		return;
	while (cur) {
		xmlNodePtr match = NULL;
		if (xmlStrcmp(cur->name, name) == 0) {
			if (!ns || (cur->ns && xmlStrcmp(cur->ns->prefix, ns) == 0))
				f(cur, data);
		}
		/* visit children */
		xmlNodeMapByName(cur->children, name, ns, f, data);

		cur = cur->next;
	}
}

xmlNodePtr xmlDocMapByName(xmlDocPtr doc, const char *name, const char *ns,
			   void (f)(xmlNodePtr, void*), void *data )
{
	xmlNodePtr cur = doc->children;
	xmlNodeMapByName(cur, name, ns, f, data);
}
