#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "mediastream.h"
#include "linphone-gpe.h"
#include "events.h"

#define get_core()	(uiobj->core)
#define get_main_window() (&uiobj->main_window)
#define get_uiobj()	(uiobj)

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_phone_number_activate                       (GtkMenuItem     *menuitem,
						gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     GtkWidget *addressentry=get_main_window()->addressentry;
     gtk_entry_set_text(GTK_ENTRY(addressentry), user_data);
}

void
on_call_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (lc->call==NULL){
	  gchar *sipuri;
	  GtkWidget *placed_calls_menu = lookup_widget(GTK_WIDGET(menuitem), "placed_calls_menu");
	  /* we have no dialog in progress */
	  /* get the url to call */
	  sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
	  gtk_widget_set_sensitive(ui->main_window.call, FALSE);
	  gtk_widget_set_sensitive(ui->main_window.release, TRUE);
	  linphone_core_invite(lc,sipuri);
	  phone_menu_add_item(lc, placed_calls_menu, sipuri, linphone_core_set_placed_calls_list);
	  g_free(sipuri);
     } else {
	  linphone_core_accept_dialog(lc,NULL);
     }
}

void
on_answer_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (lc->call!=NULL){
	  gchar *sipuri;
	  GtkWidget *received_calls_menu = lookup_widget(GTK_WIDGET(menuitem), "received_calls_menu");
	  /* we have no dialog in progress */
	  /* get the url to call */
	  sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
	  phone_menu_add_item(lc, received_calls_menu, sipuri, linphone_core_set_received_calls_list);

	  linphone_core_accept_dialog(lc,NULL);

	  g_free(sipuri);
     }
}

void
on_cancel_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_enter();
     if (lc->call!=NULL) {
	  gtk_widget_show(ui->main_window.call);
	  gtk_widget_show(ui->main_window.release);
	  gtk_widget_hide(ui->main_window.answer);
	  gtk_widget_hide(ui->main_window.cancel);
	  gtk_widget_set_sensitive(ui->main_window.call, TRUE);
	  gtk_widget_set_sensitive(ui->main_window.release, FALSE);
	  linphone_core_terminate_dialog(lc,NULL);
     }
     if (!linphone_core_is_in_main_thread(ui->core)) gdk_threads_leave();
}

void
on_transfer_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_release_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     if (lc->call!=NULL) {
	  linphone_core_terminate_dialog(lc,NULL);
	  gtk_widget_set_sensitive(ui->main_window.call, TRUE);
	  gtk_widget_set_sensitive(ui->main_window.release, FALSE);
     }

}


void
on_conference_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_dtmf_1_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"1");
}
void
on_dtmf_2_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"2");
}
void
on_dtmf_3_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"3");
}
void
on_dtmf_4_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"4");
}
void
on_dtmf_5_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"5");
}
void
on_dtmf_6_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"6");
}
void
on_dtmf_7_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"7");
}
void
on_dtmf_8_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"8");
}
void
on_dtmf_9_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"9");
}
void
on_dtmf_star_clicked                      (GtkButton       *button,
					   gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"*");
}
void
on_dtmf_0_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"0");
}
void
on_dtmf_pound_clicked                      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_append_text(GTK_ENTRY(addressentry),"#");
}


void
on_subscribe_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     gchar *sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
     // event_update_buddy(lc, sipuri, NULL, NULL, NULL);
     linphone_core_subscribe(lc, sipuri, "presence", "application/cpim-pidf+xml");	
}


void
on_unsubscribe_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     gchar *sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
     linphone_core_unsubscribe(lc, sipuri);	
}


void
on_address_book_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_missed_calls_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_received_calls_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_placed_calls_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_keypad_back_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gchar *text = gtk_editable_get_chars(GTK_EDITABLE(addressentry), 0, -1);
	gtk_editable_delete_text(GTK_EDITABLE(addressentry), strlen(text)-1, -1);
}


void
on_keypad_clear_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkWidget *addressentry=get_main_window()->addressentry;
	gtk_entry_set_text(GTK_ENTRY(addressentry),"");
}


void
on_item4_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_item1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_linphone_gpe_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
	gtk_main_quit();
}


void
on_mute_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	LinphoneCore *lc=get_core();
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 1;
	}
}


void
on_unmute_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	LinphoneCore *lc=get_core();
	if (lc->audiostream != NULL && lc->audiostream->timer != NULL) {
		lc->audiostream->timer->mute = 0;
	}

}

void
on_settings_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	linphone_property_box_init(&uiobj->propbox);
}

void
on_properties_destroy                  (GtkObject       *object,
                                        gpointer         user_data)
{
	linphone_property_box_uninit(&uiobj->propbox);
}


void
on_properties_close_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	LinphoneCore *lc = get_core();
	linphone_property_box_apply(&uiobj->propbox, lc);
	gtk_widget_destroy(GTK_WIDGET(&uiobj->propbox.prop)); 
}


void
on_properties_apply_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
	LinphoneCore *lc = get_core();
	linphone_property_box_apply(&uiobj->propbox, lc);
}


void
on_properties_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
}

void
on_message_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();
     gchar *sipuri=gtk_editable_get_chars(GTK_EDITABLE(ui->main_window.addressentry),0,-1);
     linphone_gpe_message_page(ui->main_window.notebook, sipuri);
}

void on_message_send_clicked(GtkButton       *button,
			     gpointer         user_data)
{
     LinphoneGPEUI *ui=get_uiobj();
     LinphoneCore *lc=get_core();

     GtkWidget *text_entry = user_data;

     gchar *sipuri = g_object_get_data(G_OBJECT(text_entry), "sipuri");
     GtkWidget *text_view = g_object_get_data(G_OBJECT(text_entry), "text_view");

     gchar *msg=gtk_editable_get_chars(GTK_EDITABLE(text_entry),0,-1);
     
     linphone_gpe_message_append(text_view, msg);

     /* now send the message */
     linphone_core_message(lc, sipuri, "text/plain", msg);

     gtk_editable_delete_text(GTK_EDITABLE(text_entry), 0, -1);

}




void
on_addressentry_activate               (GtkEntry        *entry,
                                        gpointer         user_data)
{

}


void
on_question_yes_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_question_no_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{

}


