/*
  The osipua library is a library based on oSIP that implements CallLeg and User Agent
  level.
  Copyright (C) 2001  Simon MORLAT simon.morlat@free.fr
  											Aymeric MOIZARD jack@atosc.org
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "cpimhandler.h"
#include <osip/smsg.h>
#include "utils.h"

static CpimContextClass *cpim_context_class=NULL;

void cpim_context_init(CpimContext *obj, CpimHandler *info)
{
	body_context_init(BODY_CONTEXT(obj), BODY_HANDLER(info));
	obj->state=CPIM_CONTEXT_STATE_INIT;
}

void cpim_context_class_init(CpimContextClass *klass)
{
	BodyContextClass *bcc=BODY_CONTEXT_CLASS(klass);
	body_context_class_init(bcc);
	bcc->_destroy=(BodyContextDestroyFunc)cpim_context_destroy;
}

BodyContext *cpim_context_new(CpimHandler *info)
{
	CpimContext *obj=smalloc(sizeof(CpimContext));
	if (cpim_context_class==NULL)
	{
		cpim_context_class=smalloc(sizeof(CpimContextClass));
		cpim_context_class_init(cpim_context_class);
	}
	BODY_CONTEXT(obj)->klass=BODY_CONTEXT_CLASS(cpim_context_class);
	cpim_context_init(obj,info);
	return BODY_CONTEXT(obj);
}

void cpim_context_uninit(CpimContext *obj)
{

}

void cpim_context_destroy(CpimContext *obj)
{
	cpim_context_uninit(obj);
	sfree(obj);
}




