/***************************************************************************
    xml.h  -  xml utilities 
                             -------------------
    begin                : November 5 2003
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _COREAPI_XML_H_
#define _COREAPI_XML_H_

#include <libxml/parser.h>
#include <libxml/xpath.h>

void xpath_map(xmlDocPtr doc, char *xpath, void (*f)(xmlNodePtr, void *), void *data);
xmlNodePtr xpath_get_node(xmlDocPtr doc, char *xpath);
xmlAttrPtr xmlNodeGetAttrByName(xmlNodePtr node, const char *name);
char *xmlNodeGetAttrContentByName(xmlNodePtr node, const char *name);
xmlNodePtr xmlNodeGetChildByName(xmlNodePtr node, const char *name);
xmlNodePtr xmlNodeGetNodeByName(xmlNodePtr node, const char *name, const char *ns);
xmlNodePtr xmlDocGetNodeByName(xmlDocPtr doc, const char *name, const char *ns);
char *xmlDocGetNodeContentByName(xmlDocPtr doc, const char *name, const char *ns);
void xmlNodeMapByName(xmlNodePtr node, const char *name, const char *ns, 
		      void (f)(xmlNodePtr, void*), void *data);
xmlNodePtr xmlDocMapByName(xmlDocPtr doc, const char *name, const char *ns,
			   void (f)(xmlNodePtr, void*), void *data );


#endif /* _COREAPI_XML_H_ */
