

#ifndef LINPHONE_H
#define LINPHONE_H

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <linphonecore.h>

#include "support.h"
#include "propertybox.h"
#include "presence.h"
#include "addressbook.h"
#include "friends.h"

typedef struct _LinphoneMainWindow
{
	GtkWidget *window;
	GtkWidget *status_bar;
	GtkWidget *addressentry;
	GtkWidget *transferentry;
	GtkWidget *optioncontrols;
	GtkWidget *dtmfentry;
	GtkWidget *buddies;
	GtkWidget *conference;
	PresenceBox presencebox;
	FriendList friendlist;
}LinphoneMainWindow;

typedef struct _LinphoneGnomeUI
{
	LinphoneMainWindow main_window;
	LinphonePropertyBox propbox;
	AddressBook	addressbook;
	LinphoneCore *core;
	guint timeout_id;
}LinphoneGnomeUI;


void linphone_gnome_ui_init(LinphoneGnomeUI *ui,LinphoneCore *core);
void linphone_gnome_ui_uninit(LinphoneGnomeUI *ui);

void linphone_gnome_init(LinphoneGnomeUI *ui,LinphoneCore *lc);
void linphone_gnome_uninit(LinphoneGnomeUI *ui);

extern LinphoneGnomeUI *uiobj;

#endif
