/***************************************************************************
    events.c  -  buddy/dialog/conference event package handling
                             -------------------
    begin                : November 5 2003
    copyright            : (C) 2003 by Hewlett-Packard Company
    email                : jamey.hicks@hp.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <xml.h>
#include "linphone-gpe.h"
#include "support.h"
#include "events.h"

enum buddy_list_columns {
     BL_AOR_COLUMN,
     BL_CONTACT_COLUMN,
     BL_STATE_COLUMN,
     BL_ROOM_COLUMN,
     BL_LOCATION_COLUMN,
     BL_NCOLUMNS
};

const char *buddy_list_column_names[] = {
  "Buddy",
  "Contact",
  "State",
  "Room",
  "Location"
};

enum conference_list_columns {
     CL_CONTACT_COLUMN,
     CL_STATE_COLUMN,
     CL_NCOLUMNS
};

const char *conference_list_column_names[] = {
     "Contact",
     "State",
};

enum location_list_columns {
     LL_CONTACT_COLUMN,
     LL_DISPLAY_NAME_COLUMN,
     LL_NCOLUMNS
};

const char *location_list_column_names[] = {
     "Contact",
     "Name"
};

xmlDocPtr event_body_parse(char *event_body)
{
     return xmlParseMemory(event_body, strlen(event_body));
}

void buddies_treeview_init(GtkWidget *buddies_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;
     int i;

     store = gtk_list_store_new (BL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(buddies_treeview),GTK_TREE_MODEL(store));

     for (i = 0; i < BL_NCOLUMNS; i++) {
	  renderer = gtk_cell_renderer_text_new ();
	  column = gtk_tree_view_column_new_with_attributes (buddy_list_column_names[i],
								   renderer,
								   "text", i,
								   NULL);
	  gtk_tree_view_column_set_resizable(column, 1);
	  gtk_tree_view_column_set_clickable(column, 1);
	  gtk_tree_view_append_column (GTK_TREE_VIEW (buddies_treeview), column);
	  if (i == 0)
	       gtk_tree_view_set_expander_column(GTK_TREE_VIEW (buddies_treeview), column);
     }
}

void conference_treeview_init(GtkWidget *conference_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;
     int i;

     store = gtk_list_store_new (CL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(conference_treeview),GTK_TREE_MODEL(store));

     
     for (i = 0; i < CL_NCOLUMNS; i++) {
	  renderer = gtk_cell_renderer_text_new ();
	  column = gtk_tree_view_column_new_with_attributes (conference_list_column_names[i],
							     renderer,
							     "text", i,
							     NULL);
	  gtk_tree_view_column_set_resizable(column, 1);
	  gtk_tree_view_column_set_clickable(column, 1);
	  gtk_tree_view_append_column (GTK_TREE_VIEW (conference_treeview), column);
     }
}

void event_notify_winfo(LinphoneCore *lc, gchar *event_package, char *content_type, gchar *event_body)
{
     xmlDocPtr doc = NULL;
     GtkTreeIter iter;

     char *sipuri_text = NULL;
     char *contact_text = NULL;
     char *basic_text = "unknown";
     char *location_text = "noplace";
     int r;

     doc = event_body_parse(event_body);
     fprintf(stderr, "winfo content_type=%s bodytext=%s\n", content_type, event_body);
     if (!doc) {
	  fprintf(stderr, "event_notify_winfo: could not parse body\n %s\n", event_body);
	  return;
     }
}

void event_update_buddy_list(LinphoneCore *lc, GList *buddies)
{
     while (buddies != NULL) {
	  if (buddies->data) {
	       // event_update_buddy(lc, buddies->data, NULL, NULL, NULL);
	       linphone_core_subscribe(lc, buddies->data, "presence", "application/cpim-pidf+xml");
	  }
	  buddies = g_list_next(buddies);
     }
}

void event_update_buddy(LinphoneCore *lc, gchar *sipuri, gchar *contact, gchar *basic, gchar *location, gchar *room)
{

     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.buddies));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     int r;

     fprintf(stderr, "event_update_buddy: sipuri=%s contact=%s\n", sipuri, contact);

     if (!contact)
       contact = sipuri;

     r = gtk_tree_model_get_iter_first(model, &iter);
     while (r) {
	  char *as = NULL;
	  char *dnstring = NULL;
	  gtk_tree_model_get(model, &iter, BL_AOR_COLUMN, &dnstring, -1);
	  if (strcmp(dnstring, sipuri) == 0) {
	       /* update this one */
	       goto update;
	  }
	  r = gtk_tree_model_iter_next(model, &iter);
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, BL_AOR_COLUMN,
			strdup(sipuri),-1);
     gtk_list_store_set(list_store, &iter, BL_CONTACT_COLUMN,
			strdup(contact),-1);
     /* also add it to lc->buddy_list */
     if (0)
	  if (!g_list_find_custom(lc->ui_conf.buddy_list, sipuri, strcmp))
	       lc->ui_conf.buddy_list = g_list_append(lc->ui_conf.buddy_list, g_strdup(sipuri));

 update:
     if (basic)
	  gtk_list_store_set(list_store, &iter, BL_STATE_COLUMN,
			     strdup(basic),-1);
     if (location)
	  gtk_list_store_set(list_store, &iter, BL_LOCATION_COLUMN,
			     strdup(location),-1);
     if (room)
	  gtk_list_store_set(list_store, &iter, BL_ROOM_COLUMN,
			     strdup(room),-1);
}

void event_notify_buddies(LinphoneCore *lc, gchar *event_package, char *content_type, gchar *event_body)
{
     xmlDocPtr doc = NULL;
     GtkTreeIter iter;

     char *sipuri_text = NULL;
     char *contact_text = NULL;
     char *basic_text = "unknown";
     char *location_text = "unknown";
     char *room_text = "";
     int r;

     fprintf(stderr, "event_notify_buddies: lc=%p event_package=%p content_type=%p event_body=%p\n",
	     lc, event_package, content_type, event_body);
     fprintf(stderr, "event_notify_buddies: event_package=%s content_type=%s event_body=%s\n",
	     event_package, content_type, event_body);

     doc = event_body_parse(event_body);
     fprintf(stderr, "content_type=%s bodytext=%s\n", content_type, event_body);
     if (!doc) {
	  fprintf(stderr, "event_notify_buddies: could not parse body\n %s\n", event_body);
	  return;
     }
     if (strcmp(content_type, "application/cpim-pidf+xml") == 0) {
	  xmlNodePtr presence = xmlDocGetNodeByName(doc, "presence", NULL);
	  xmlNodePtr site = xmlDocGetNodeByName(doc, "site", NULL);
	  xmlNodePtr floor = xmlDocGetNodeByName(doc, "floor", NULL);
	  xmlNodePtr x = xmlDocGetNodeByName(doc, "x", NULL);
	  xmlNodePtr y = xmlDocGetNodeByName(doc, "y", NULL);
	  xmlNodePtr radius = xmlDocGetNodeByName(doc, "radius", NULL);

	  contact_text = xmlDocGetNodeContentByName(doc, "contact", NULL);
	  basic_text = xmlDocGetNodeContentByName(doc, "basic", NULL);
	  location_text = xmlDocGetNodeContentByName(doc, "loc", NULL);
	  room_text = xmlDocGetNodeContentByName(doc, "room", NULL);

	  xmlAttrPtr sipuri_attr = NULL;
	  fprintf(stderr, "doc=%p doc->children=%p presence=%p basic=%s location=%s room=%s\n", 
		  doc, doc->children, presence, basic_text, location_text, room_text);
	  if (presence)
	    fprintf(stderr, "presence->props=%p\n",
		    presence->properties);
	  if (!presence || !basic_text) {
	       fprintf(stderr, "event_notify_buddies: doc->name=%s\n", doc->name);
	       return;
	  }
	  sipuri_attr = xmlNodeGetAttrByName(presence, "entity");
	  if (sipuri_attr) {
	       sipuri_text = xmlNodeGetContent(sipuri_attr->children);
	  } else {
	       char *entity = strstr(event_body, "entity=\"");
	       if (entity) {
		    char *entityend;
		    int len;
		    entity += strlen("entity=\"");
		    entityend = strchr(entity, '\"');
		    if (entityend) {
			 len = entityend - entity;
			 sipuri_text = malloc(len + 1);
			 strncpy(sipuri_text, entity, len);
			 sipuri_text[len] = 0;
			 fprintf(stderr, "found entity with strstr: entity=%s\n", sipuri_text);
		    }
	       }
	  }
     } else {
	  /* xpidf */
	  xmlNodePtr presence = xmlDocGetNodeByName(doc, "presence", NULL);
	  xmlNodePtr address = xmlDocGetNodeByName(doc, "address", NULL);
	  xmlNodePtr status = xmlDocGetNodeByName(doc, "status", NULL);
	  if (address) {
	       xmlAttrPtr uriattr = xmlNodeGetAttrByName(address, "uri");
	       if (uriattr) {
		    sipuri_text = xmlNodeGetContent(uriattr->children);
	       }
	  }
	  if (status) {
	       xmlAttrPtr statusattr = xmlNodeGetAttrByName(status, "status");
	       if (statusattr) {
		    basic_text = xmlNodeGetContent(statusattr->children);
	       }
	  }
     }

     fprintf(stderr, "event_notify_buddies: sipuri=%s basic=%s location=%s\n",
	     sipuri_text, basic_text, location_text);

     if (sipuri_text)
	  event_update_buddy(lc, sipuri_text, contact_text, basic_text, location_text, room_text);

}


void event_update_conference_user(xmlNodePtr user, void *lc_)
{
     LinphoneCore *lc = lc_;
     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.conference));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     char *sipuri_text = NULL;
     char *display_name_text = NULL;
     char *activity_status_text = NULL;
     int r;

     xmlAttrPtr sipuri = xmlNodeGetAttrByName(user, "uri");
     xmlAttrPtr display_name = xmlNodeGetAttrByName(user, "display-name");
     xmlNodePtr activity_status = xmlNodeGetChildByName(user, "activity-status");
     xmlNodePtr history_status = xmlNodeGetChildByName(user, "history-status");
     if (sipuri_text)
	  sipuri_text = xmlNodeGetContent(sipuri->children);
     if (display_name)
	  display_name_text = xmlNodeGetContent(display_name->children);
     if (activity_status)
	  activity_status_text = xmlNodeGetContent(activity_status);

     fprintf(stderr, "event_update_conference_user: uri=%s display-name=%s activity-status=%s\n",
	     sipuri_text, display_name_text, activity_status_text);
     
     if (1) {
	  r = gtk_tree_model_get_iter_first(model, &iter);
	  while (r) {
	       char *as = NULL;
	       char *dnstring = NULL;
	       gtk_tree_model_get(model, &iter, CL_CONTACT_COLUMN, &dnstring, -1);
	       if (strcmp(dnstring, display_name_text) == 0) {
		    /* update this one */
		    gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN, strdup(activity_status_text), -1);
		    return;
	       }
	       r = gtk_tree_model_iter_next(model, &iter);
	  }
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, CL_CONTACT_COLUMN,
			strdup(display_name_text),-1);
     gtk_list_store_set(list_store, &iter, CL_STATE_COLUMN,
			strdup(activity_status_text),-1);

}

void event_notify_conference(LinphoneCore *lc, char *event_package, char *content_type, char *event_body)
{
     xmlDocPtr doc = event_body_parse(event_body);
     xmlNodePtr conference_info = NULL;
     xmlAttrPtr entity = NULL;
     
     fprintf(stderr, "event_body=%s, doc=%p\n\n", event_body, doc);
     if (!doc) return;
     conference_info = xmlDocGetNodeByName(doc, "conference-info", NULL);
     fprintf(stderr, "conference_info=%p\n", conference_info);

     if (conference_info) {
	  entity = xmlNodeGetAttrByName(conference_info, "entity");
	  fprintf(stderr, "event_notify_conference: entity=%s\n", 
		  xmlNodeGetContent(entity->children));
	  xmlDocMapByName(doc, "user", NULL, event_update_conference_user, lc);
     }

}

void location_treeview_init(GtkWidget *location_treeview, GtkWidget *main_window, LinphoneCore *lc)
{
     GtkListStore *store;
     GtkTreeIter iter;
     GtkCellRenderer *renderer;
     GtkTreeViewColumn *column;
     GtkTreeSelection *select;
     GList *list;
     int i;

     store = gtk_list_store_new (LL_NCOLUMNS, G_TYPE_STRING, G_TYPE_STRING);
     gtk_tree_view_set_model(GTK_TREE_VIEW(location_treeview),GTK_TREE_MODEL(store));

     for (i = 0; i < LL_NCOLUMNS; i++) {
	  renderer = gtk_cell_renderer_text_new ();
	  column = gtk_tree_view_column_new_with_attributes (location_list_column_names[i],
							     renderer,
							     "text", i,
							     NULL);
	  gtk_tree_view_column_set_resizable(column, 1);
	  gtk_tree_view_column_set_clickable(column, 1);
	  gtk_tree_view_append_column (GTK_TREE_VIEW (location_treeview), column);
     }
}

void event_update_location_user(xmlNodePtr user, void *lc_)
{
     LinphoneCore *lc = lc_;
     GtkTreeModel *model = gtk_tree_view_get_model(GTK_TREE_VIEW(uiobj->main_window.location));
     GtkTreeIter iter;
     GtkListStore *list_store = GTK_LIST_STORE(model);
     int r;

     char *sipuri = xmlNodeGetAttrContentByName(user, "entity");
     char *display_name = xmlNodeGetAttrContentByName(user, "display-name");

     fprintf(stderr, "event_update_location_user: entity=%s display-name=%s\n",
	     sipuri, display_name);
     
     if (!sipuri)
	  return;

     if (1) {
	  r = gtk_tree_model_get_iter_first(model, &iter);
	  while (r) {
	       char *uristring = NULL;
	       gtk_tree_model_get(model, &iter, LL_CONTACT_COLUMN, &uristring, -1);
	       if (strcmp(uristring, sipuri) == 0) {
		    return;
	       }
	       r = gtk_tree_model_iter_next(model, &iter);
	  }
     }

     /* otherwise, add new entry */
     gtk_list_store_append(list_store, &iter);
     gtk_list_store_set(list_store, &iter, LL_CONTACT_COLUMN,
			strdup(sipuri),-1);
     if (display_name)
	  gtk_list_store_set(list_store, &iter, LL_DISPLAY_NAME_COLUMN,
			     strdup(display_name),-1);
}

void event_notify_location(LinphoneCore *lc, char *event_package, char *content_type, char *event_body)
{
     xmlDocPtr doc = event_body_parse(event_body);
     xmlNodePtr location_info = NULL;
     
     fprintf(stderr, "event_body=%s, doc=%p\n\n", event_body, doc);
     if (!doc) return;
     location_info = xmlDocGetNodeByName(doc, "locationinfo", NULL);
     fprintf(stderr, "location_info=%p\n", location_info);

     if (location_info) {
	  char *entity = xmlNodeGetAttrContentByName(location_info, "entity");
	  fprintf(stderr, "event_notify_location: entity=%s\n", entity);
	  xmlDocMapByName(doc, "user", NULL, event_update_location_user, lc);
     }

}

