/***************************************************************************
                          presence.c  -  code for the presence box
                             -------------------
    begin                : Mon Dec 17 2001
    copyright            : (C) 2001 by Simon Morlat
    email                : simon.morlat@linphone.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "linphone-gpe.h"
#include "callbacks.h"
#include "support.h"


void presence_box_init(PresenceBox *p, GtkWidget *main_window,LinphoneCore *lc)
{
	GtkWidget *r;
	p->lc=lc;
	p->contact_field_label=lookup_widget(main_window,"contact_field_label");
	p->contact_field=lookup_widget(main_window,"contact_field");
	p->minutesaway_label=lookup_widget(main_window,"minutesaway_label");
	p->minutesaway=lookup_widget(main_window,"minutesaway");
	p->presence_validate=lookup_widget(main_window,"presence_validate");
	r=lookup_widget(main_window,"presence_reachable");
	if (r)
	  gtk_menu_item_activate(GTK_MENU_ITEM(r));
	p->location_entry=lookup_widget(main_window,"location_combo_entry");
	gtk_widget_set_sensitive(p->presence_validate,FALSE);
}

void presence_box_changed(PresenceBox *p)
{
	fprintf(stderr, "presence_validate=%p\n", p->presence_validate);

	switch (p->toggled_button) {
	case PRESENCE_MODE_REACHABLE:
	case PRESENCE_MODE_BUSY:
	case PRESENCE_MODE_NOT_DISTURB:
	  gtk_widget_set_sensitive(p->minutesaway,FALSE);
	  gtk_widget_set_sensitive(p->contact_field,FALSE);
	  gtk_widget_hide(p->minutesaway);
	  gtk_widget_hide(p->minutesaway_label);
	  gtk_widget_hide(p->contact_field);
	  gtk_widget_hide(p->contact_field_label);
	  break;
	case PRESENCE_MODE_AWAY:
	  gtk_widget_set_sensitive(p->minutesaway,TRUE);
	  gtk_widget_set_sensitive(p->contact_field,FALSE);
	  gtk_widget_show(p->minutesaway);
	  gtk_widget_show(p->minutesaway_label);
	  gtk_widget_hide(p->contact_field);
	  gtk_widget_hide(p->contact_field_label);
	  break;
	case PRESENCE_MODE_MOVED:
	case PRESENCE_MODE_ALT_SERVICE:
	  gtk_widget_set_sensitive(p->minutesaway,FALSE);
	  gtk_widget_set_sensitive(p->contact_field,TRUE);
	  gtk_widget_hide(p->minutesaway);
	  gtk_widget_hide(p->minutesaway_label);
	  gtk_widget_show(p->contact_field);
	  gtk_widget_show(p->contact_field_label);
	  break;
	}

	gtk_widget_set_sensitive(p->presence_validate,TRUE);
	fprintf(stderr, "presence_box_changed done\n");

}

#define get_presence_box() (&(uiobj)->main_window.presencebox)


void
on_presence_reachable_activate         (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	  gtk_widget_set_sensitive(p->contact_field,FALSE);
	p->toggled_button=PRESENCE_MODE_REACHABLE;
	presence_box_changed(p);
}


void
on_presence_busy_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	  gtk_widget_set_sensitive(p->contact_field,FALSE);
	p->toggled_button=PRESENCE_MODE_BUSY;
	if (p->minutesaway)
	  gtk_widget_set_sensitive(p->minutesaway,TRUE);
	presence_box_changed(p);
}


void
on_minutesaway_changed                 (GtkEditable *editable,gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	presence_box_changed(p);
}


void
on_presence_away_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	  gtk_widget_set_sensitive(p->contact_field,FALSE);
	if (p->minutesaway)
	  gtk_widget_set_sensitive(p->minutesaway,TRUE);
	p->toggled_button=PRESENCE_MODE_AWAY;
	presence_box_changed(p);
}


void
on_presence_dnd_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	gtk_widget_set_sensitive(p->contact_field,FALSE);
	if (p->minutesaway)
	  gtk_widget_set_sensitive(p->minutesaway,FALSE);
	p->toggled_button=PRESENCE_MODE_NOT_DISTURB;
	presence_box_changed(p);
}


void
on_presence_moved_temporarily_activate (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	  gtk_widget_set_sensitive(p->contact_field,TRUE);
	if (p->minutesaway)
	  gtk_widget_set_sensitive(p->minutesaway,FALSE);
	p->toggled_button=PRESENCE_MODE_MOVED;
	presence_box_changed(p);
}


void
on_presence_another_phone_activate     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	if (p->contact_field)
	gtk_widget_set_sensitive(p->contact_field,TRUE);
	if (p->minutesaway)
	  gtk_widget_set_sensitive(p->minutesaway,FALSE);
	p->toggled_button=PRESENCE_MODE_ALT_SERVICE;
	presence_box_changed(p);
}


void
on_contact_field_changed               (GtkEditable *entry,gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	presence_box_changed(p);
}

	
void
on_location_combo_entry_changed        (GtkEditable     *editable,
                                        gpointer         user_data)
{
	PresenceBox *p=get_presence_box();
	presence_box_changed(p);
}

void presence_box_apply(PresenceBox *p)
{
	gchar *tmp,*contact=NULL;
	int presence=200,minutes_away=-1;
	gchar *location = NULL;
	/* retrieve the minutes away */
	tmp = gtk_editable_get_chars (GTK_EDITABLE(p->minutesaway),0,-1);
	if (tmp!=NULL && strlen(tmp)>0)
	{
		minutes_away = satoi(tmp);
		g_free(tmp);
	}
	/* retrieve the alternate contact url */
	tmp = gtk_editable_get_chars (GTK_EDITABLE(p->contact_field),0,-1);
	if (tmp!=NULL && strlen(tmp)>0)
	{
		contact=tmp;
	}
	/* set presence mode */
	switch(p->toggled_button)
	{
	case PRESENCE_MODE_REACHABLE:
		presence=200;
		break;
		
	case PRESENCE_MODE_BUSY:
		presence=486;
		break;
		
	case PRESENCE_MODE_AWAY:
		presence=480;
		break;
		
	case PRESENCE_MODE_NOT_DISTURB:
		presence=600;
		break;
		
	case PRESENCE_MODE_MOVED:
		presence=302;
		break;
		
	case PRESENCE_MODE_ALT_SERVICE:
		presence=380;
		break;
	default:
		g_warning("unknown presence mode.\n");
	}	
	/* retrieve the alternate contact url */
	tmp = gtk_editable_get_chars (GTK_EDITABLE(p->location_entry),0,-1);
	if (tmp!=NULL && strlen(tmp)>0)
	{
		location=tmp;
	}
	linphone_core_set_presence_info(p->lc,minutes_away,contact,presence,location);
	gtk_widget_set_sensitive(p->presence_validate,FALSE);
}

void
on_presence_validate_clicked           (GtkButton *button, gpointer         user_data)
{
	/*retrieve the PresenceBox object */
	PresenceBox *p=get_presence_box();
	presence_box_apply(p);
}



