#ifndef _TESTING_H
#define _TESTING_H

/* Testing code. */
#ifdef JUST_TESTING

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <stdarg.h>
#include <sys/utsname.h>
#include <asm/unistd.h>
#include <sys/types.h>
#include <dirent.h>

int modtest_uname(struct utsname *buf)
{
	strcpy(buf->sysname, "Linux");
	strcpy(buf->nodename, "fakenodename");
	strcpy(buf->release, getenv("MODTEST_UNAME"));
	strcpy(buf->version, "Fakeversion");
	strcpy(buf->machine, "fakemachine");
	return 0;
}

long modtest_create_module(const char *name, size_t size)
{
	if (getenv("MODTEST_DO_CREATE_MODULE"))
		return 0;
	errno = ENOSYS;
	return -1;
}

static long int modtest_syscall(long int __sysno, ...)
{
	va_list ap;

	switch (__sysno) {
	case __NR_init_module: {
		void *map;
		size_t size;
		char *optstring;

		va_start(ap, __sysno);
		map = va_arg(ap, void *);
		size = va_arg(ap, size_t);
		optstring = va_arg(ap, char *);

		if (getenv("MODTEST_DUMP_INIT")) {
			while (size) {
				int ret;
				ret = write(2, map, size);
				if (ret < 0) exit(1);
				size -= ret;
				map += ret;
			}
		} else		
			printf("INIT_MODULE: %u %s\n", size, optstring);
		break;
	}
	case __NR_delete_module: {
		char *modname;
		unsigned int flags;
		char flagnames[100];

		va_start(ap, __sysno);
		modname = va_arg(ap, char *);
		flags = va_arg(ap, unsigned int);

		flagnames[0] = '\0';
		if (flags & O_EXCL)
			strcat(flagnames, "EXCL ");
		if (flags & O_TRUNC)
			strcat(flagnames, "TRUNC ");
		if (flags & O_NONBLOCK)
			strcat(flagnames, "NONBLOCK ");
		if (flags & ~(O_EXCL|O_TRUNC|O_NONBLOCK))
			strcat(flagnames, "UNKNOWN ");

		printf("DELETE_MODULE: %s %s\n", modname, flagnames);
		break;
	}
	default:
		printf("UNKNOWN SYSCALL: %lu\n", __sysno);
		break;
	}

	return 0;
}

static const char *modtest_mapname(const char *path)
{
	unsigned int i;
	char envname[64];

	for (i = 0; ; i++) {
		char *name; 
		sprintf(envname, "MODTEST_OVERRIDE%u", i);
		name = getenv(envname);
		if (!name)
			break;
		if (strcmp(path, name) == 0) {
			sprintf(envname, "MODTEST_OVERRIDE_WITH%u", i);
			return getenv(envname);
		}
	}
	return path;
}

void *modtest_fopen(const char *path, const char *mode)
{
	return fopen(modtest_mapname(path), mode);
}

int modtest_open(const char *path, int flags, mode_t mode)
{
	return open(modtest_mapname(path), flags, mode);
}

int modtest_stat(const char *file_name, struct stat *buf)
{
	return stat(modtest_mapname(file_name), buf);
}

DIR *modtest_opendir(const char *name)
{
	return opendir(modtest_mapname(name));
}

int modtest_system(const char *string)
{
	if (getenv("MODTEST_DO_SYSTEM"))
		return system(string);
	printf("SYSTEM: %s\n", string);
	return 0;
}

int modtest_rename(const char *oldpath, const char *newpath)
{
	return rename(modtest_mapname(oldpath), modtest_mapname(newpath));
}


/* create_module call */
#undef create_module
#define create_module modtest_create_module

#define uname modtest_uname
#define syscall modtest_syscall
#define open modtest_open
#define fopen modtest_fopen
#define stat(name, ptr) modtest_stat(name, ptr)
#define opendir modtest_opendir
#define system modtest_system
#define rename modtest_rename

#endif /* JUST_TESTING */
#endif /* _TESTING_H */

