<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="struct">
    <name>OApplicationFactory</name>
    <filename>structOApplicationFactory.html</filename>
    <templarg>Product</templarg>
    <base>ApplicationInterface</base>
    <member kind="function">
      <type>QRESULT</type>
      <name>queryInterface</name>
      <anchor>a0</anchor>
      <arglist>(const QUuid &amp;uuid, QUnknownInterface **iface)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QWidget *</type>
      <name>createMainWindow</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;appName, QWidget *parent, const char *name, Qt::WFlags f)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QStringList</type>
      <name>applications</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OCheckItem</name>
    <filename>classOCheckItem.html</filename>
    <base>QTableItem</base>
    <member kind="enumeration">
      <name>Size</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OCheckItem</name>
      <anchor>a0</anchor>
      <arglist>(QTable *t, const QString &amp;sortkey)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setChecked</name>
      <anchor>a1</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>toggle</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isChecked</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKey</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>key</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paint</name>
      <anchor>a6</anchor>
      <arglist>(QPainter *p, const QColorGroup &amp;cg, const QRect &amp;cr, bool selected)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OClickableLabel</name>
    <filename>classOClickableLabel.html</filename>
    <base>QLabel</base>
    <member kind="slot">
      <type>void</type>
      <name>setOn</name>
      <anchor>i0</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clicked</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>toggled</name>
      <anchor>l1</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OClickableLabel</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags fl=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToggleButton</name>
      <anchor>a1</anchor>
      <arglist>(bool t)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mousePressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b1</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mouseMoveEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OColorButton</name>
    <filename>classOColorButton.html</filename>
    <base>QPushButton</base>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>setColor</name>
      <anchor>i0</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>colorSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OColorButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const QColor &amp;=black, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OColorButton</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QColor</type>
      <name>color</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>updateColor</name>
      <anchor>j0</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OColorPanelButton</name>
    <filename>classOColorPanelButton.html</filename>
    <base>QFrame</base>
    <member kind="signal">
      <type>void</type>
      <name>selected</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OColorPanelButton</name>
      <anchor>a0</anchor>
      <arglist>(const QColor &amp;color, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~OColorPanelButton</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActive</name>
      <anchor>a2</anchor>
      <arglist>(bool active)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enterEvent</name>
      <anchor>a3</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>leaveEvent</name>
      <anchor>a4</anchor>
      <arglist>(QEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>paintEvent</name>
      <anchor>a5</anchor>
      <arglist>(QPaintEvent *e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>a6</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OColorPopupMenu</name>
    <filename>classOColorPopupMenu.html</filename>
    <base>QPopupMenu</base>
    <member kind="signal">
      <type>void</type>
      <name>colorSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OColorPopupMenu</name>
      <anchor>a0</anchor>
      <arglist>(const QColor &amp;color, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~OColorPopupMenu</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>buttonSelected</name>
      <anchor>j0</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>moreColorClicked</name>
      <anchor>j1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OFileDialog</name>
    <filename>classOFileDialog.html</filename>
    <base>QDialog</base>
    <member kind="function">
      <type></type>
      <name>OFileDialog</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;caption, QWidget *, int mode, int selector, const QString &amp;dirName, const QString &amp;fileName=QString::null, const MimeTypes &amp;mimetypes=MimeTypes())</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>mimetype</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileName</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DocLnk</type>
      <name>selectedDocument</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getOpenFileName</name>
      <anchor>e0</anchor>
      <arglist>(int selector, const QString &amp;startDir=QString::null, const QString &amp;fileName=QString::null, const MimeTypes &amp;mime=MimeTypes(), QWidget *wid=0, const QString &amp;caption=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>getSaveFileName</name>
      <anchor>e1</anchor>
      <arglist>(int selector, const QString &amp;startDir=QString::null, const QString &amp;fileName=QString::null, const MimeTypes &amp;mimefilter=MimeTypes(), QWidget *wid=0, const QString &amp;caption=QString::null)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OFileSelector</name>
    <filename>classOFileSelector.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>Mode</name>
      <anchor>w14</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Selector</name>
      <anchor>w15</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dirSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fileSelected</name>
      <anchor>l1</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fileSelected</name>
      <anchor>l2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>newSelected</name>
      <anchor>l3</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeMe</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>ok</name>
      <anchor>l5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>cancel</name>
      <anchor>l6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OFileSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, int mode, int selector, const QString &amp;dirName, const QString &amp;fileName, const MimeTypes &amp;mimetypes=MimeTypes(), bool newVisible=FALSE, bool closeVisible=FALSE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OFileSelector</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;mimeFilter, QWidget *parent, const char *name=0, bool newVisible=TRUE, bool closeVisible=FALSE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~OFileSelector</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const DocLnk *</type>
      <name>selected</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>selectedName</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>selectedPath</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>directory</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DocLnk</type>
      <name>selectedDocument</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fileCount</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reread</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mode</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>selector</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNewVisible</name>
      <anchor>a12</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCloseVisible</name>
      <anchor>a13</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNameVisible</name>
      <anchor>a14</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>OFileViewFileListView</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OFileView</name>
    <filename>classOFileView.html</filename>
    <member kind="signal">
      <type>void</type>
      <name>fileSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>fileSelected</name>
      <anchor>l1</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>contextMenu</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>changedDir</name>
      <anchor>l3</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>changedDir</name>
      <anchor>l4</anchor>
      <arglist>(const QDir &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OFileView</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *widget, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addFile</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;mine, QFileInfo *info, bool isSymlink=FALSE)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addDir</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;mine, QFileInfo *info, bool isSymlink=FALSE)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>addSymlink</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;mime, QFileInfo *info, bool isSymlink=FALSE)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>cd</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;path)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OFontMenu</name>
    <filename>classOFontMenu.html</filename>
    <base>QPopupMenu</base>
    <member kind="signal">
      <type>void</type>
      <name>fontChanged</name>
      <anchor>l0</anchor>
      <arglist>(int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OFontMenu</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name, const QList&lt; QWidget &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a1</anchor>
      <arglist>(Config *cfg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>restore</name>
      <anchor>a2</anchor>
      <arglist>(Config *cfg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWidgets</name>
      <anchor>a3</anchor>
      <arglist>(const QList&lt; QWidget &gt; &amp;list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addWidget</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *wid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>forceSize</name>
      <anchor>a5</anchor>
      <arglist>(QWidget *wid, int size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeWidget</name>
      <anchor>a6</anchor>
      <arglist>(QWidget *wid)</arglist>
    </member>
    <member kind="function">
      <type>const QList&lt; QWidget &gt; &amp;</type>
      <name>widgets</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OFontSelector</name>
    <filename>classOFontSelector.html</filename>
    <base>QWidget</base>
    <member kind="signal">
      <type>void</type>
      <name>fontSelected</name>
      <anchor>l0</anchor>
      <arglist>(const QFont &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OFontSelector</name>
      <anchor>a0</anchor>
      <arglist>(bool withpreview, QWidget *parent=0, const char *name=0, WFlags fl=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>selectedFont</name>
      <anchor>a2</anchor>
      <arglist>(QString &amp;family, QString &amp;style, int &amp;size)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>selectedFont</name>
      <anchor>a3</anchor>
      <arglist>(QString &amp;family, QString &amp;style, int &amp;size, QString &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>QFont</type>
      <name>selectedFont</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setSelectedFont</name>
      <anchor>a5</anchor>
      <arglist>(const QFont &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setSelectedFont</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;family, const QString &amp;style, int size, const QString &amp;charset=0)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fontFamily</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fontStyle</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fontSize</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fontCharSet</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fontFamilyClicked</name>
      <anchor>j0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fontStyleClicked</name>
      <anchor>j1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>fontSizeClicked</name>
      <anchor>j2</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *re)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OProcess</name>
    <filename>classOProcess.html</filename>
    <base>QObject</base>
    <member kind="enumeration">
      <name>Communication</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RunMode</name>
      <anchor>w11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DontCare</name>
      <anchor>w11w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NotifyOnExit</name>
      <anchor>w11w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>Block</name>
      <anchor>w11w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>processExited</name>
      <anchor>l0</anchor>
      <arglist>(OProcess *proc)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStdout</name>
      <anchor>l1</anchor>
      <arglist>(OProcess *proc, char *buffer, int buflen)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStdout</name>
      <anchor>l2</anchor>
      <arglist>(int fd, int &amp;len)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>receivedStderr</name>
      <anchor>l3</anchor>
      <arglist>(OProcess *proc, char *buffer, int buflen)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>wroteStdin</name>
      <anchor>l4</anchor>
      <arglist>(OProcess *proc)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OProcess</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OProcess</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;arg0, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OProcess</name>
      <anchor>a2</anchor>
      <arglist>(const QStringList &amp;args, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OProcess</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setExecutable</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;proc)</arglist>
    </member>
    <member kind="function">
      <type>OProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>OProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a6</anchor>
      <arglist>(const char *arg)</arglist>
    </member>
    <member kind="function">
      <type>OProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a7</anchor>
      <arglist>(const QCString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>OProcess &amp;</type>
      <name>operator&lt;&lt;</name>
      <anchor>a8</anchor>
      <arglist>(const QStringList &amp;args)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearArguments</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>start</name>
      <anchor>a10</anchor>
      <arglist>(RunMode runmode=NotifyOnExit, Communication comm=NoCommunication)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>kill</name>
      <anchor>a11</anchor>
      <arglist>(int signo=SIGTERM)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRunning</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>pid_t</type>
      <name>pid</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>suspend</name>
      <anchor>a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>resume</name>
      <anchor>a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>normalExit</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exitStatus</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeStdin</name>
      <anchor>a18</anchor>
      <arglist>(const char *buffer, int buflen)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flushStdin</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStdin</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStdout</name>
      <anchor>a21</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>closeStderr</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; QCString &gt; &amp;</type>
      <name>args</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRunPrivileged</name>
      <anchor>a24</anchor>
      <arglist>(bool keepPrivileges)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>runPrivileged</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnvironment</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;name, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWorkingDirectory</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseShell</name>
      <anchor>a28</anchor>
      <arglist>(bool useShell, const char *shell=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>detach</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>quote</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotChildOutput</name>
      <anchor>j0</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotChildError</name>
      <anchor>j1</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="slot" protection="public">
      <type>void</type>
      <name>slotSendData</name>
      <anchor>j2</anchor>
      <arglist>(int dummy)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>setupEnvironment</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>setupCommunication</name>
      <anchor>b1</anchor>
      <arglist>(Communication comm)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>commSetupDoneP</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual int</type>
      <name>commSetupDoneC</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>processHasExited</name>
      <anchor>b4</anchor>
      <arglist>(int state)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>commClose</name>
      <anchor>b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>childOutput</name>
      <anchor>b6</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>childError</name>
      <anchor>b7</anchor>
      <arglist>(int fdno)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QValueList&lt; QCString &gt;</type>
      <name>arguments</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>RunMode</type>
      <name>run_mode</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>runs</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>pid_t</type>
      <name>pid_</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>status</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>keepPrivs</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>out</name>
      <anchor>p6</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>in</name>
      <anchor>p7</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>err</name>
      <anchor>p8</anchor>
      <arglist>[2]</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>innot</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>outnot</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QSocketNotifier *</type>
      <name>errnot</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>Communication</type>
      <name>communication</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>const char *</type>
      <name>input_data</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>input_sent</name>
      <anchor>p14</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>input_total</name>
      <anchor>p15</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>OProcessController</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OProcessController</name>
    <filename>classOProcessController.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>slotDoHousekeeping</name>
      <anchor>i0</anchor>
      <arglist>(int socket)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addOProcess</name>
      <anchor>a2</anchor>
      <arglist>(OProcess *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeOProcess</name>
      <anchor>a3</anchor>
      <arglist>(OProcess *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>theSigCHLDHandler</name>
      <anchor>e0</anchor>
      <arglist>(int signal)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setupHandlers</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>resetHandlers</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>OProcessController *</type>
      <name>theOProcessController</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ORecurranceWidget</name>
    <filename>classORecurranceWidget.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>slotSetRType</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>endDateChanged</name>
      <anchor>i1</anchor>
      <arglist>(int, int, int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotNoEnd</name>
      <anchor>i2</anchor>
      <arglist>(bool unused)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setStartDate</name>
      <anchor>i3</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRecurrence</name>
      <anchor>i4</anchor>
      <arglist>(const ORecur &amp;recur, const QDate &amp;start)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setRecurrence</name>
      <anchor>i5</anchor>
      <arglist>(const ORecur &amp;recur)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ORecurranceWidget</name>
      <anchor>a0</anchor>
      <arglist>(bool startOnMonday, const QDate &amp;start, QWidget *parent=0, const char *name=0, bool modal=TRUE, WFlags fl=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ORecurranceWidget</name>
      <anchor>a1</anchor>
      <arglist>(bool startOnMonday, const ORecur &amp;rp, const QDate &amp;start, QWidget *parent=0, const char *name=0, bool modal=TRUE, WFlags=0)</arglist>
    </member>
    <member kind="function">
      <type>ORecur</type>
      <name>recurrence</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>endDate</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTabBar</name>
    <filename>classOTabBar.html</filename>
    <base>QTabBar</base>
    <member kind="function">
      <type></type>
      <name>OTabBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *=0, const char *=0)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>paintLabel</name>
      <anchor>b0</anchor>
      <arglist>(QPainter *, const QRect &amp;, QTab *, bool) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTabInfo</name>
    <filename>classOTabInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>OTabInfo</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OTabInfo</name>
      <anchor>a1</anchor>
      <arglist>(int id, QWidget *control, const QString &amp;icon, const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>label</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>control</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>icon</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIcon</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;icon)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTabInfoList</name>
    <filename>classOTabInfoList.html</filename>
  </compound>
  <compound kind="class">
    <name>OTabWidget</name>
    <filename>classOTabWidget.html</filename>
    <base>QWidget</base>
    <member kind="enumeration">
      <name>TabStyle</name>
      <anchor>w7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TabPosition</name>
      <anchor>w8</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>currentChanged</name>
      <anchor>l0</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OTabWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *=0, const char *=0, TabStyle=Global, TabPosition=Top)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~OTabWidget</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addTab</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *, const QString &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePage</name>
      <anchor>a3</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>changeTab</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *, const QString &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>TabStyle</type>
      <name>tabStyle</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabStyle</name>
      <anchor>a6</anchor>
      <arglist>(TabStyle)</arglist>
    </member>
    <member kind="function">
      <type>TabPosition</type>
      <name>tabPosition</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTabPosition</name>
      <anchor>a8</anchor>
      <arglist>(TabPosition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentTab</name>
      <anchor>a9</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentTab</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentTab</name>
      <anchor>a11</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>QSize</type>
      <name>sizeHint</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentTab</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QWidget *</type>
      <name>currentWidget</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>resizeEvent</name>
      <anchor>b0</anchor>
      <arglist>(QResizeEvent *)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTicker</name>
    <filename>classOTicker.html</filename>
    <base>QLabel</base>
    <member kind="signal">
      <type>void</type>
      <name>mousePressed</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OTicker</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~OTicker</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setText</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBackgroundColor</name>
      <anchor>a3</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setForegroundColor</name>
      <anchor>a4</anchor>
      <arglist>(const QColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrame</name>
      <anchor>a5</anchor>
      <arglist>(int style)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUpdateTime</name>
      <anchor>a6</anchor>
      <arglist>(int timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScrollLength</name>
      <anchor>a7</anchor>
      <arglist>(int length)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>timerEvent</name>
      <anchor>b0</anchor>
      <arglist>(QTimerEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>drawContents</name>
      <anchor>b1</anchor>
      <arglist>(QPainter *p)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>mouseReleaseEvent</name>
      <anchor>b2</anchor>
      <arglist>(QMouseEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTimePicker</name>
    <filename>classOTimePicker.html</filename>
    <base>QWidget</base>
    <member kind="slot">
      <type>void</type>
      <name>setHour</name>
      <anchor>i0</anchor>
      <arglist>(int h)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMinute</name>
      <anchor>i1</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTime</name>
      <anchor>i2</anchor>
      <arglist>(const QTime &amp;)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setTime</name>
      <anchor>i3</anchor>
      <arglist>(int h, int m)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>timeChanged</name>
      <anchor>l0</anchor>
      <arglist>(const QTime &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OTimePicker</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, WFlags fl=0)</arglist>
    </member>
    <member kind="function">
      <type>QTime</type>
      <name>time</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OTimePickerDialog</name>
    <filename>classOTimePickerDialog.html</filename>
    <member kind="slot">
      <type>void</type>
      <name>setTime</name>
      <anchor>i0</anchor>
      <arglist>(const QTime &amp;time)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setHour</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;hour)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>setMinute</name>
      <anchor>i2</anchor>
      <arglist>(const QString &amp;minute)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OTimePickerDialog</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=NULL, WFlags fl=0)</arglist>
    </member>
    <member kind="function">
      <type>QTime</type>
      <name>time</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TodayConfigWidget</name>
    <filename>classTodayConfigWidget.html</filename>
    <base>QWidget</base>
    <member kind="function">
      <type></type>
      <name>TodayConfigWidget</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>writeConfig</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>TodayPluginInterface</name>
    <filename>structTodayPluginInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual TodayPluginObject *</type>
      <name>guiPart</name>
      <anchor>a0</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TodayPluginObject</name>
    <filename>classTodayPluginObject.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>pluginName</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual double</type>
      <name>versionNumber</name>
      <anchor>a2</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>pixmapNameWidget</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QWidget *</type>
      <name>widget</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *parent)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>pixmapNameConfig</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual TodayConfigWidget *</type>
      <name>configWidget</name>
      <anchor>a6</anchor>
      <arglist>(QWidget *)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>appName</name>
      <anchor>a7</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>excludeFromRefresh</name>
      <anchor>a8</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>refresh</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>reinitialize</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>OWait</name>
    <filename>classOWait.html</filename>
    <base>QDialog</base>
    <member kind="slot">
      <type>void</type>
      <name>hide</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>OWait</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0, bool dispIcon=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>show</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimerLength</name>
      <anchor>a3</anchor>
      <arglist>(int length)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Opie::ODevice</name>
    <filename>classOpie_1_1ODevice.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>buttonMappingChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>modelString</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OModel</type>
      <name>model</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OModel</type>
      <name>series</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>vendorString</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OVendor</type>
      <name>vendor</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>systemString</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OSystem</type>
      <name>system</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>systemVersionString</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Transformation</type>
      <name>rotation</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ODirection</type>
      <name>direction</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setSoftSuspend</name>
      <anchor>a11</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>suspend</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setDisplayStatus</name>
      <anchor>a13</anchor>
      <arglist>(bool on)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setDisplayBrightness</name>
      <anchor>a14</anchor>
      <arglist>(int brightness)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>displayBrightnessResolution</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setDisplayContrast</name>
      <anchor>a16</anchor>
      <arglist>(int contrast)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>displayContrastResolution</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>alarmSound</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>keySound</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>touchSound</name>
      <anchor>a20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QValueList&lt; OLed &gt;</type>
      <name>ledList</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QValueList&lt; OLedState &gt;</type>
      <name>ledStateList</name>
      <anchor>a22</anchor>
      <arglist>(OLed led) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual OLedState</type>
      <name>ledState</name>
      <anchor>a23</anchor>
      <arglist>(OLed led) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>setLedState</name>
      <anchor>a24</anchor>
      <arglist>(OLed led, OLedState st)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>hasLightSensor</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>readLightSensor</name>
      <anchor>a26</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>lightSensorResolution</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>hasHingeSensor</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual OHingeStatus</type>
      <name>readHingeSensor</name>
      <anchor>a29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QStrList &amp;</type>
      <name>allowedCpuFrequencies</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setCurrentCpuFrequency</name>
      <anchor>a31</anchor>
      <arglist>(uint index)</arglist>
    </member>
    <member kind="function">
      <type>const QValueList&lt; ODeviceButton &gt; &amp;</type>
      <name>buttons</name>
      <anchor>a32</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const ODeviceButton *</type>
      <name>buttonForKeycode</name>
      <anchor>a33</anchor>
      <arglist>(ushort keyCode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remapPressedAction</name>
      <anchor>a34</anchor>
      <arglist>(int button, const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remapHeldAction</name>
      <anchor>a35</anchor>
      <arglist>(int button, const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
    <member kind="function">
      <type>uint</type>
      <name>buttonHoldTime</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>ODevice *</type>
      <name>inst</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchor>b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>initButtons</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>reloadButtonMapping</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>virtual_hook</name>
      <anchor>b4</anchor>
      <arglist>(int id, void *data)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>ODeviceData *</type>
      <name>d</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Opie::ODeviceButton</name>
    <filename>classOpie_1_1ODeviceButton.html</filename>
    <member kind="function">
      <type>ushort</type>
      <name>keycode</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>userText</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>pixmap</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OQCopMessage</type>
      <name>factoryPresetPressedAction</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OQCopMessage</type>
      <name>pressedAction</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OQCopMessage</type>
      <name>factoryPresetHeldAction</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>OQCopMessage</type>
      <name>heldAction</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setKeycode</name>
      <anchor>a9</anchor>
      <arglist>(ushort keycode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserText</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixmap</name>
      <anchor>a11</anchor>
      <arglist>(const QPixmap &amp;picture)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFactoryPresetPressedAction</name>
      <anchor>a12</anchor>
      <arglist>(const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPressedAction</name>
      <anchor>a13</anchor>
      <arglist>(const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFactoryPresetHeldAction</name>
      <anchor>a14</anchor>
      <arglist>(const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHeldAction</name>
      <anchor>a15</anchor>
      <arglist>(const OQCopMessage &amp;qcopMessage)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Opie::XMLElement</name>
    <filename>classOpie_1_1XMLElement.html</filename>
    <member kind="typedef">
      <type>QMap&lt; QString, QString &gt;</type>
      <name>AttributeMap</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>XMLElement</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>appendChild</name>
      <anchor>a2</anchor>
      <arglist>(XMLElement *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertAfter</name>
      <anchor>a3</anchor>
      <arglist>(XMLElement *newChild, XMLElement *refChild)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertBefore</name>
      <anchor>a4</anchor>
      <arglist>(XMLElement *newChild, XMLElement *refChild)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeChild</name>
      <anchor>a5</anchor>
      <arglist>(XMLElement *child)</arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>parent</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>firstChild</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>nextChild</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>prevChild</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>lastChild</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTagName</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;tag)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tagName</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;val)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>value</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttributes</name>
      <anchor>a15</anchor>
      <arglist>(const AttributeMap &amp;attrs)</arglist>
    </member>
    <member kind="function">
      <type>AttributeMap</type>
      <name>attributes</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>AttributeMap &amp;</type>
      <name>attributes</name>
      <anchor>a17</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>attribute</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttribute</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;attr, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a20</anchor>
      <arglist>(QTextStream &amp;stream, uint indent=0)</arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>namedItem</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>XMLElement *</type>
      <name>clone</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>XMLElement *</type>
      <name>load</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;fileName)</arglist>
    </member>
  </compound>
</tagfile>
