<?xml version='1.0' encoding='ISO-8859-1' standalone='yes'?>
<tagfile>
  <compound kind="class">
    <name>AlarmServer</name>
    <filename>classAlarmServer.html</filename>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addAlarm</name>
      <anchor>e0</anchor>
      <arglist>(QDateTime when, const QCString &amp;channel, const QCString &amp;msg, int data=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>deleteAlarm</name>
      <anchor>e1</anchor>
      <arglist>(QDateTime when, const QCString &amp;channel, const QCString &amp;msg, int data=0)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend int</type>
      <name>initApplication</name>
      <anchor>n0</anchor>
      <arglist>(int, char **)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPEApplication</name>
    <filename>classQPEApplication.html</filename>
    <base>QApplication</base>
    <member kind="enumeration">
      <name>StylusMode</name>
      <anchor>w9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>InputMethodHint</name>
      <anchor>w10</anchor>
      <arglist></arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clientMoused</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>timeChanged</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>clockChanged</name>
      <anchor>l2</anchor>
      <arglist>(bool pm)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>micChanged</name>
      <anchor>l3</anchor>
      <arglist>(bool muted)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>volumeChanged</name>
      <anchor>l4</anchor>
      <arglist>(bool muted)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>appMessage</name>
      <anchor>l5</anchor>
      <arglist>(const QCString &amp;msg, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>weekChanged</name>
      <anchor>l6</anchor>
      <arglist>(bool startOnMonday)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>dateFormatChanged</name>
      <anchor>l7</anchor>
      <arglist>(DateFormat)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>flush</name>
      <anchor>l8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>reload</name>
      <anchor>l9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QPEApplication</name>
      <anchor>a0</anchor>
      <arglist>(int &amp;argc, char **argv, Type=GuiClient)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QPEApplication</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyStyle</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMainWidget</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *, bool nomax=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>showMainDocumentWidget</name>
      <anchor>a5</anchor>
      <arglist>(QWidget *, bool nomax=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keepRunning</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>keyboardGrabbed</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exec</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>qpeDir</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>documentDir</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>defaultRotation</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setDefaultRotation</name>
      <anchor>e3</anchor>
      <arglist>(int r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setCurrentRotation</name>
      <anchor>e4</anchor>
      <arglist>(int r)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setCurrentMode</name>
      <anchor>e5</anchor>
      <arglist>(int x, int y, int depth)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>grabKeyboard</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>ungrabKeyboard</name>
      <anchor>e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setStylusOperation</name>
      <anchor>e8</anchor>
      <arglist>(QWidget *, StylusMode)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>StylusMode</type>
      <name>stylusOperation</name>
      <anchor>e9</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setInputMethodHint</name>
      <anchor>e10</anchor>
      <arglist>(QWidget *, InputMethodHint)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>InputMethodHint</type>
      <name>inputMethodHint</name>
      <anchor>e11</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showDialog</name>
      <anchor>e12</anchor>
      <arglist>(QDialog *, bool nomax=FALSE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>execDialog</name>
      <anchor>e13</anchor>
      <arglist>(QDialog *, bool nomax=FALSE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showWidget</name>
      <anchor>e14</anchor>
      <arglist>(QWidget *, bool nomax=FALSE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setKeepRunning</name>
      <anchor>e15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>qwsEventFilter</name>
      <anchor>b0</anchor>
      <arglist>(QWSEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>internalSetStyle</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;style)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>prepareForTermination</name>
      <anchor>b2</anchor>
      <arglist>(bool willrestart)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>restart</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>shutdown</name>
      <anchor>b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>eventFilter</name>
      <anchor>b5</anchor>
      <arglist>(QObject *, QEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>timerEvent</name>
      <anchor>b6</anchor>
      <arglist>(QTimerEvent *)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>raiseAppropriateWindow</name>
      <anchor>b7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>tryQuit</name>
      <anchor>b8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>polish</name>
      <anchor>b9</anchor>
      <arglist>(QWidget *)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>ApplicationInterface</name>
    <filename>structApplicationInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QWidget *</type>
      <name>createMainWindow</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;appName, QWidget *parent=0, const char *name=0, Qt::WFlags f=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QStringList</type>
      <name>applications</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>AppLnk</name>
    <filename>classAppLnk.html</filename>
    <member kind="function">
      <type></type>
      <name>AppLnk</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AppLnk</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;file)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AppLnk</name>
      <anchor>a2</anchor>
      <arglist>(const AppLnk &amp;copy)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppLnk</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>name</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QPixmap &amp;</type>
      <name>pixmap</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QPixmap &amp;</type>
      <name>bigPixmap</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>icon</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>exec</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>type</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>rotation</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>comment</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>file</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>linkFile</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>mimeTypes</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>mimeTypeIcons</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QArray&lt; int &gt; &amp;</type>
      <name>categories</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>fileKnown</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>linkFileKnown</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>execute</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>execute</name>
      <anchor>a22</anchor>
      <arglist>(const QStringList &amp;args) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFiles</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeLinkFile</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setName</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;docname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setExec</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;exec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFile</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLinkFile</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setComment</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;comment)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;mimetype)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRotation</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;rot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setIcon</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCategories</name>
      <anchor>a33</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>writeLink</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProperty</name>
      <anchor>a35</anchor>
      <arglist>(const QString &amp;key, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>property</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>AppLnk &amp;</type>
      <name>operator=</name>
      <anchor>a37</anchor>
      <arglist>(const AppLnk &amp;other)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setSmallIconSize</name>
      <anchor>e0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setBigIconSize</name>
      <anchor>e1</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>smallIconSize</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>bigIconSize</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>invoke</name>
      <anchor>b0</anchor>
      <arglist>(const QStringList &amp;args) const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>ensureLinkExists</name>
      <anchor>b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>storeLink</name>
      <anchor>b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mName</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPixmap</type>
      <name>mPixmap</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QPixmap</type>
      <name>mBigPixmap</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mExec</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mType</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mRotation</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mComment</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mFile</name>
      <anchor>p7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mLinkFile</name>
      <anchor>p8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mIconFile</name>
      <anchor>p9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>mMimeTypes</name>
      <anchor>p10</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>mMimeTypeIcons</name>
      <anchor>p11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>int</type>
      <name>mId</name>
      <anchor>p12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>AppLnkPrivate *</type>
      <name>d</name>
      <anchor>p13</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public" static="yes">
      <type>int</type>
      <name>lastId</name>
      <anchor>t0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>AppLnkSet</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>AppLnkSet</name>
    <filename>classAppLnkSet.html</filename>
    <member kind="function">
      <type></type>
      <name>AppLnkSet</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>AppLnkSet</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~AppLnkSet</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const AppLnk *</type>
      <name>find</name>
      <anchor>a3</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>const AppLnk *</type>
      <name>findExec</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;execname) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>types</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>typeName</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>typePixmap</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>typeBigPixmap</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchor>a9</anchor>
      <arglist>(AppLnk *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchor>a10</anchor>
      <arglist>(AppLnk *)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QList&lt; AppLnk &gt; &amp;</type>
      <name>children</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>detachChildren</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QList&lt; AppLnk &gt;</type>
      <name>mApps</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>mFile</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QStringList</type>
      <name>typs</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>AppLnkSetPrivate *</type>
      <name>d</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="public">
      <type>friend class</type>
      <name>AppLnk</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Calendar</name>
    <filename>classCalendar.html</filename>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>nameOfMonth</name>
      <anchor>e0</anchor>
      <arglist>(int m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>nameOfDay</name>
      <anchor>e1</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QValueList&lt; Day &gt;</type>
      <name>daysOfMonth</name>
      <anchor>e2</anchor>
      <arglist>(int year, int month, bool startWithMonday=FALSE)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Categories</name>
    <filename>classCategories.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>categoryAdded</name>
      <anchor>l0</anchor>
      <arglist>(const Categories &amp;, const QString &amp;, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>categoryRemoved</name>
      <anchor>l1</anchor>
      <arglist>(const Categories &amp;, const QString &amp;, int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>categoryRenamed</name>
      <anchor>l2</anchor>
      <arglist>(const Categories &amp;, const QString &amp;, int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Categories</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Categories</name>
      <anchor>a1</anchor>
      <arglist>(const Categories &amp;copyFrom)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Categories</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Categories &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Categories &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addCategory</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;catname)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addCategory</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;catname, int uid)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addGlobalCategory</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;catname)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addGlobalCategory</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;catname, int uid)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeCategory</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;appName, const QString &amp;catName, bool checkGlobal=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeCategory</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;appName, int uid)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeGlobalCategory</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;catName)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>removeGlobalCategory</name>
      <anchor>a12</anchor>
      <arglist>(int uid)</arglist>
    </member>
    <member kind="function">
      <type>QArray&lt; int &gt;</type>
      <name>ids</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;app, const QStringList &amp;labels) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;app, const QString &amp;cat) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>label</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;app, int id) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>labels</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;app, bool includeGlobal=TRUE, ExtraLabels extra=NoExtra) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>labels</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;app, const QArray&lt; int &gt; &amp;catids) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>displaySingle</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;app, const QArray&lt; int &gt; &amp;catids, DisplaySingle display) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>globalCategories</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>renameCategory</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;oldName, const QString &amp;newName)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>renameGlobalCategory</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;oldName, const QString &amp;newName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGlobal</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;catname, bool value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isGlobal</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;catname) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exists</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;catname) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exists</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;catname) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>save</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;fname) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;fname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QMap&lt; QString, CategoryGroup &gt; &amp;</type>
      <name>appGroupMap</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const CategoryGroup &amp;</type>
      <name>globalGroup</name>
      <anchor>a30</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>CategoryGroup</name>
    <filename>classCategoryGroup.html</filename>
    <member kind="function">
      <type></type>
      <name>CategoryGroup</name>
      <anchor>a1</anchor>
      <arglist>(const CategoryGroup &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>add</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add</name>
      <anchor>a4</anchor>
      <arglist>(int uid, const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchor>a6</anchor>
      <arglist>(int uid)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>rename</name>
      <anchor>a7</anchor>
      <arglist>(int uid, const QString &amp;newLabel)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>rename</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;oldLabel, const QString &amp;newLabel)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a9</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;label) const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>label</name>
      <anchor>a11</anchor>
      <arglist>(int id) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>id</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;label) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>labels</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>labels</name>
      <anchor>a14</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;catids) const </arglist>
    </member>
    <member kind="function">
      <type>const QMap&lt; int, QString &gt; &amp;</type>
      <name>idMap</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>Categories</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>CategoryMenu</name>
    <filename>classCategoryMenu.html</filename>
    <base>QPopupMenu</base>
    <member kind="slot">
      <type>void</type>
      <name>reload</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>categoryChange</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CategoryMenu</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;appName, bool, QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~CategoryMenu</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isSelected</name>
      <anchor>a2</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;cUids) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentCategory</name>
      <anchor>a3</anchor>
      <arglist>(int newCatUid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentCategoryAll</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentCategoryUnfiled</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>CategorySelect</name>
    <filename>classCategorySelect.html</filename>
    <base>QHBox</base>
    <member kind="slot">
      <type>void</type>
      <name>slotNewCat</name>
      <anchor>i0</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalSelected</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CategorySelect</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CategorySelect</name>
      <anchor>a1</anchor>
      <arglist>(QWidget *parent, const char *name, int width)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CategorySelect</name>
      <anchor>a2</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;vlCats, const QString &amp;appName, QWidget *parent=0, const char *name=0, int width=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>CategorySelect</name>
      <anchor>a3</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;vlCats, const QString &amp;appName, const QString &amp;visibleName, QWidget *parent=0, const char *name=0, int width=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~CategorySelect</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const QArray&lt; int &gt; &amp;</type>
      <name>currentCategories</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentCategory</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentCategory</name>
      <anchor>a7</anchor>
      <arglist>(int newCatUid)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>setCategories</name>
      <anchor>a8</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;vlCats, const QString &amp;appName)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>setCategories</name>
      <anchor>a9</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;vlCats, const QString &amp;appName, const QString &amp;visibleName)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRemoveCategoryEdit</name>
      <anchor>a10</anchor>
      <arglist>(bool remove)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAllCategories</name>
      <anchor>a11</anchor>
      <arglist>(bool add)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFixedWidth</name>
      <anchor>a12</anchor>
      <arglist>(int width)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Config</name>
    <filename>classConfig.html</filename>
    <member kind="typedef">
      <type>QMap&lt; QString, QString &gt;</type>
      <name>ConfigGroup</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Domain</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Config</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name, Domain domain=User)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Config</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a2</anchor>
      <arglist>(const Config &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a3</anchor>
      <arglist>(const Config &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValid</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasKey</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasGroup</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;gname) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>groupList</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGroup</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;gname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;key, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;key, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntryCrypt</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;key, const QString &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;key, int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>writeEntry</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;key, const QStringList &amp;lst, const QChar &amp;sep)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeEntry</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntry</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryCrypt</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryDirect</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt=QString::null) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readNumEntry</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;key, int deflt=-1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readBoolEntry</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;key, bool deflt=FALSE) const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readListEntry</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;key, const QChar &amp;sep) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntry</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryCrypt</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>readEntryDirect</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;key, const QString &amp;deflt)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>readNumEntry</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;key, int deflt)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readBoolEntry</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;key, bool deflt)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>readListEntry</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;key, const QChar &amp;sep)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearGroup</name>
      <anchor>a27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;fn=QString::null)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>read</name>
      <anchor>b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>parse</name>
      <anchor>b1</anchor>
      <arglist>(const QString &amp;line)</arglist>
    </member>
    <member kind="function" protection="public" static="yes">
      <type>QString</type>
      <name>configFilename</name>
      <anchor>f0</anchor>
      <arglist>(const QString &amp;name, Domain)</arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMap&lt; QString, ConfigGroup &gt;</type>
      <name>groups</name>
      <anchor>p0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QMap&lt; QString, ConfigGroup &gt;::Iterator</type>
      <name>git</name>
      <anchor>p1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>filename</name>
      <anchor>p2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>lang</name>
      <anchor>p3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>QString</type>
      <name>glang</name>
      <anchor>p4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>bool</type>
      <name>changed</name>
      <anchor>p5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="public">
      <type>ConfigPrivate *</type>
      <name>d</name>
      <anchor>p6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Contact</name>
    <filename>classContact.html</filename>
    <base>Qtopia::Record</base>
    <member kind="function">
      <type></type>
      <name>Contact</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Contact</name>
      <anchor>a1</anchor>
      <arglist>(const QMap&lt; int, QString &gt; &amp;fromMap)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Contact</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTitle</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFirstName</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMiddleName</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLastName</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSuffix</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileAs</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFileAs</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDefaultEmail</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertEmail</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeEmail</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearEmails</name>
      <anchor>a13</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertEmails</name>
      <anchor>a14</anchor>
      <arglist>(const QStringList &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeStreet</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeCity</name>
      <anchor>a16</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeState</name>
      <anchor>a17</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeZip</name>
      <anchor>a18</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeCountry</name>
      <anchor>a19</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomePhone</name>
      <anchor>a20</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeFax</name>
      <anchor>a21</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeMobile</name>
      <anchor>a22</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHomeWebpage</name>
      <anchor>a23</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompany</name>
      <anchor>a24</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessStreet</name>
      <anchor>a25</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessCity</name>
      <anchor>a26</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessState</name>
      <anchor>a27</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessZip</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessCountry</name>
      <anchor>a29</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessWebpage</name>
      <anchor>a30</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setJobTitle</name>
      <anchor>a31</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDepartment</name>
      <anchor>a32</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOffice</name>
      <anchor>a33</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessPhone</name>
      <anchor>a34</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessFax</name>
      <anchor>a35</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessMobile</name>
      <anchor>a36</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBusinessPager</name>
      <anchor>a37</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProfession</name>
      <anchor>a38</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAssistant</name>
      <anchor>a39</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setManager</name>
      <anchor>a40</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSpouse</name>
      <anchor>a41</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setGender</name>
      <anchor>a42</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBirthday</name>
      <anchor>a43</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAnniversary</name>
      <anchor>a44</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNickname</name>
      <anchor>a45</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setChildren</name>
      <anchor>a46</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNotes</name>
      <anchor>a47</anchor>
      <arglist>(const QString &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchor>a48</anchor>
      <arglist>(const QString &amp;regexp) const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fullName</name>
      <anchor>a49</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>title</name>
      <anchor>a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>firstName</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>middleName</name>
      <anchor>a52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>lastName</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>suffix</name>
      <anchor>a54</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>fileAs</name>
      <anchor>a55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>defaultEmail</name>
      <anchor>a56</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>emailList</name>
      <anchor>a57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeStreet</name>
      <anchor>a58</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeCity</name>
      <anchor>a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeState</name>
      <anchor>a60</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeZip</name>
      <anchor>a61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeCountry</name>
      <anchor>a62</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homePhone</name>
      <anchor>a63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeFax</name>
      <anchor>a64</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeMobile</name>
      <anchor>a65</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>homeWebpage</name>
      <anchor>a66</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>displayHomeAddress</name>
      <anchor>a67</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>company</name>
      <anchor>a68</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessStreet</name>
      <anchor>a69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessCity</name>
      <anchor>a70</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessState</name>
      <anchor>a71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessZip</name>
      <anchor>a72</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessCountry</name>
      <anchor>a73</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessWebpage</name>
      <anchor>a74</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>jobTitle</name>
      <anchor>a75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>department</name>
      <anchor>a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>office</name>
      <anchor>a77</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessPhone</name>
      <anchor>a78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessFax</name>
      <anchor>a79</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessMobile</name>
      <anchor>a80</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>businessPager</name>
      <anchor>a81</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>profession</name>
      <anchor>a82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>assistant</name>
      <anchor>a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>manager</name>
      <anchor>a84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>displayBusinessAddress</name>
      <anchor>a85</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>spouse</name>
      <anchor>a86</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>gender</name>
      <anchor>a87</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>birthday</name>
      <anchor>a88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>anniversary</name>
      <anchor>a89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>nickname</name>
      <anchor>a90</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>children</name>
      <anchor>a91</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>childrenList</name>
      <anchor>a92</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>notes</name>
      <anchor>a93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>groups</name>
      <anchor>a94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>groupList</name>
      <anchor>a95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toRichText</name>
      <anchor>a96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; int, QString &gt;</type>
      <name>toMap</name>
      <anchor>a97</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>field</name>
      <anchor>a98</anchor>
      <arglist>(int key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>saveJournal</name>
      <anchor>a99</anchor>
      <arglist>(journal_action action, const QString &amp;key=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a100</anchor>
      <arglist>(QString &amp;buf) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUid</name>
      <anchor>a101</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCard</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, const QValueList&lt; Contact &gt; &amp;contacts)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCard</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;filename, const Contact &amp;c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QValueList&lt; Contact &gt;</type>
      <name>readVCard</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>fields</name>
      <anchor>e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>trfields</name>
      <anchor>e4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>DataSet</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>AbEditor</name>
      <anchor>n1</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>AbTable</name>
      <anchor>n2</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>AddressBookAccessPrivate</name>
      <anchor>n3</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>XMLIO</name>
      <anchor>n4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QCopEnvelope</name>
    <filename>classQCopEnvelope.html</filename>
    <base>QDataStream</base>
    <member kind="function">
      <type></type>
      <name>QCopEnvelope</name>
      <anchor>a0</anchor>
      <arglist>(const QCString &amp;channel, const QCString &amp;message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QCopEnvelope</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDawg</name>
    <filename>classQDawg.html</filename>
    <member kind="function">
      <type></type>
      <name>QDawg</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QDawg</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>readFile</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read</name>
      <anchor>a3</anchor>
      <arglist>(QIODevice *dev)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write</name>
      <anchor>a4</anchor>
      <arglist>(QIODevice *dev) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>createFromWords</name>
      <anchor>a5</anchor>
      <arglist>(QIODevice *dev)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>createFromWords</name>
      <anchor>a6</anchor>
      <arglist>(const QStringList &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>allWords</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>contains</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>countWords</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Node *</type>
      <name>root</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>dump</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>nodebits</name>
      <anchor>s0</anchor>
      <arglist></arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>QDawgPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QDawg::Node</name>
    <filename>classQDawg_1_1Node.html</filename>
    <member kind="function">
      <type>QChar</type>
      <name>letter</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isWord</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLast</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Node *</type>
      <name>next</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Node *</type>
      <name>jump</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>QDawgPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPEDialogListener</name>
    <filename>classQPEDialogListener.html</filename>
    <base>QObject</base>
    <member kind="function">
      <type></type>
      <name>QPEDialogListener</name>
      <anchor>a0</anchor>
      <arglist>(QDialog *di)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QPEDialogListener</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DocLnk</name>
    <filename>classDocLnk.html</filename>
    <base>AppLnk</base>
    <member kind="function">
      <type></type>
      <name>DocLnk</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocLnk</name>
      <anchor>a1</anchor>
      <arglist>(const DocLnk &amp;o)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocLnk</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;file)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocLnk</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;file, bool may_be_desktopfile)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DocLnk</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>exec</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>invoke</name>
      <anchor>b0</anchor>
      <arglist>(const QStringList &amp;args) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>DocLnkSet</name>
    <filename>classDocLnkSet.html</filename>
    <base>AppLnkSet</base>
    <member kind="function">
      <type></type>
      <name>DocLnkSet</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>DocLnkSet</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;dir, const QString &amp;mimefilter=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>const QList&lt; DocLnk &gt; &amp;</type>
      <name>children</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>appendFrom</name>
      <anchor>a3</anchor>
      <arglist>(DocLnkSet &amp;other)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>EffectiveEvent</name>
    <filename>classEffectiveEvent.html</filename>
    <member kind="function">
      <type></type>
      <name>EffectiveEvent</name>
      <anchor>a1</anchor>
      <arglist>(const Event &amp;event, const QDate &amp;startDate, Position pos=StartEnd)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>EffectiveEvent</name>
      <anchor>a2</anchor>
      <arglist>(const EffectiveEvent &amp;)</arglist>
    </member>
    <member kind="function">
      <type>EffectiveEvent &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const EffectiveEvent &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a5</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchor>a6</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a7</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a8</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchor>a9</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchor>a10</anchor>
      <arglist>(const EffectiveEvent &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStart</name>
      <anchor>a11</anchor>
      <arglist>(const QTime &amp;start)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnd</name>
      <anchor>a12</anchor>
      <arglist>(const QTime &amp;end)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEvent</name>
      <anchor>a13</anchor>
      <arglist>(Event e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDate</name>
      <anchor>a14</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEffectiveDates</name>
      <anchor>a15</anchor>
      <arglist>(const QDate &amp;from, const QDate &amp;to)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>description</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>location</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>notes</name>
      <anchor>a18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const Event &amp;</type>
      <name>event</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QTime &amp;</type>
      <name>start</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QTime &amp;</type>
      <name>end</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QDate &amp;</type>
      <name>date</name>
      <anchor>a22</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>length</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchor>a24</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>startDate</name>
      <anchor>a25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>endDate</name>
      <anchor>a26</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Event</name>
    <filename>classEvent.html</filename>
    <base>Qtopia::Record</base>
    <member kind="enumeration">
      <name>RepeatType</name>
      <anchor>w17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SoundTypeChoice</name>
      <anchor>w20</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Event</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Event</name>
      <anchor>a1</anchor>
      <arglist>(const QMap&lt; int, QString &gt; &amp;map)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Event</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; int, QString &gt;</type>
      <name>toMap</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a4</anchor>
      <arglist>(const Event &amp;e1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;=</name>
      <anchor>a5</anchor>
      <arglist>(const Event &amp;e1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a6</anchor>
      <arglist>(const Event &amp;e1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchor>a7</anchor>
      <arglist>(const Event &amp;e1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;=</name>
      <anchor>a8</anchor>
      <arglist>(const Event &amp;e1) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a9</anchor>
      <arglist>(const Event &amp;e) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDescription</name>
      <anchor>a10</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>description</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLocation</name>
      <anchor>a12</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>location</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNotes</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;n)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>notes</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setType</name>
      <anchor>a16</anchor>
      <arglist>(Type t)</arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>type</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAllDay</name>
      <anchor>a18</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isAllDay</name>
      <anchor>a19</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStart</name>
      <anchor>a20</anchor>
      <arglist>(const QDateTime &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStart</name>
      <anchor>a21</anchor>
      <arglist>(time_t time)</arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>start</name>
      <anchor>a22</anchor>
      <arglist>(bool actual=FALSE) const </arglist>
    </member>
    <member kind="function">
      <type>time_t</type>
      <name>startTime</name>
      <anchor>a23</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnd</name>
      <anchor>a24</anchor>
      <arglist>(const QDateTime &amp;e)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEnd</name>
      <anchor>a25</anchor>
      <arglist>(time_t time)</arglist>
    </member>
    <member kind="function">
      <type>QDateTime</type>
      <name>end</name>
      <anchor>a26</anchor>
      <arglist>(bool actual=FALSE) const </arglist>
    </member>
    <member kind="function">
      <type>time_t</type>
      <name>endTime</name>
      <anchor>a27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeZone</name>
      <anchor>a28</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>timeZone</name>
      <anchor>a29</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlarm</name>
      <anchor>a30</anchor>
      <arglist>(int minutes, SoundTypeChoice)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearAlarm</name>
      <anchor>a31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAlarm</name>
      <anchor>a32</anchor>
      <arglist>(bool b, int minutes, SoundTypeChoice)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasAlarm</name>
      <anchor>a33</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>alarmDelay</name>
      <anchor>a34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>alarmTime</name>
      <anchor>a35</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SoundTypeChoice</type>
      <name>alarmSound</name>
      <anchor>a36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RepeatType</type>
      <name>repeatType</name>
      <anchor>a37</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>frequency</name>
      <anchor>a38</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>weekOffset</name>
      <anchor>a39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>repeatTill</name>
      <anchor>a40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>repeatForever</name>
      <anchor>a41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>repeatOnWeekDay</name>
      <anchor>a42</anchor>
      <arglist>(int day) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeatType</name>
      <anchor>a43</anchor>
      <arglist>(RepeatType)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrequency</name>
      <anchor>a44</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeatTill</name>
      <anchor>a45</anchor>
      <arglist>(const QDate &amp;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeatForever</name>
      <anchor>a46</anchor>
      <arglist>(bool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeatOnWeekDay</name>
      <anchor>a47</anchor>
      <arglist>(int day, bool enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeat</name>
      <anchor>a48</anchor>
      <arglist>(bool b, const RepeatPattern &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRepeat</name>
      <anchor>a49</anchor>
      <arglist>(const RepeatPattern &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasRepeat</name>
      <anchor>a50</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const RepeatPattern &amp;</type>
      <name>repeatPattern</name>
      <anchor>a51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>RepeatPattern &amp;</type>
      <name>repeatPattern</name>
      <anchor>a52</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>doRepeat</name>
      <anchor>a53</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a54</anchor>
      <arglist>(QString &amp;buf)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchor>a55</anchor>
      <arglist>(const QRegExp &amp;r) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCalendar</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, const QValueList&lt; Event &gt; &amp;events)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCalendar</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;filename, const Event &amp;event)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QValueList&lt; Event &gt;</type>
      <name>readVCalendar</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>week</name>
      <anchor>e3</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>occurrence</name>
      <anchor>e4</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>char</type>
      <name>day</name>
      <anchor>e5</anchor>
      <arglist>(int dayOfWeek)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>dayOfWeek</name>
      <anchor>e6</anchor>
      <arglist>(char day)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>monthDiff</name>
      <anchor>e7</anchor>
      <arglist>(const QDate &amp;first, const QDate &amp;second)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Event::RepeatPattern</name>
    <filename>structEvent_1_1RepeatPattern.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a1</anchor>
      <arglist>(const RepeatPattern &amp;right) const </arglist>
    </member>
    <member kind="function">
      <type>QDate</type>
      <name>endDate</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setEndDate</name>
      <anchor>a3</anchor>
      <arglist>(const QDate &amp;dt)</arglist>
    </member>
    <member kind="variable">
      <type>RepeatType</type>
      <name>type</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>frequency</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>position</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>days</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>hasEndDate</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>time_t</type>
      <name>endDateUTC</name>
      <anchor>o5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>time_t</type>
      <name>createTime</name>
      <anchor>o6</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FileManager</name>
    <filename>classFileManager.html</filename>
    <member kind="function">
      <type></type>
      <name>FileManager</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileManager</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>saveFile</name>
      <anchor>a2</anchor>
      <arglist>(const DocLnk &amp;, const QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>saveFile</name>
      <anchor>a3</anchor>
      <arglist>(const DocLnk &amp;, const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadFile</name>
      <anchor>a4</anchor>
      <arglist>(const DocLnk &amp;, QByteArray &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>loadFile</name>
      <anchor>a5</anchor>
      <arglist>(const DocLnk &amp;, QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copyFile</name>
      <anchor>a6</anchor>
      <arglist>(const AppLnk &amp;src, const AppLnk &amp;dest)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copyFile</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;src, const QString &amp;dest)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>renameFile</name>
      <anchor>a8</anchor>
      <arglist>(const QString &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QIODevice *</type>
      <name>openFile</name>
      <anchor>a9</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QIODevice *</type>
      <name>saveFile</name>
      <anchor>a10</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>exists</name>
      <anchor>a11</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>bool</type>
      <name>ensurePathExists</name>
      <anchor>b0</anchor>
      <arglist>(const QString &amp;fn)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FileSelector</name>
    <filename>classFileSelector.html</filename>
    <base>QVBox</base>
    <member kind="signal">
      <type>void</type>
      <name>fileSelected</name>
      <anchor>l0</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>newSelected</name>
      <anchor>l1</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>closeMe</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileSelector</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;mimefilter, QWidget *parent, const char *name=0, bool newVisible=TRUE, bool closeVisible=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileSelector</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNewVisible</name>
      <anchor>a2</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCloseVisible</name>
      <anchor>a3</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTypeComboVisible</name>
      <anchor>a4</anchor>
      <arglist>(bool b=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCategorySelectVisible</name>
      <anchor>a5</anchor>
      <arglist>(bool b=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reread</name>
      <anchor>a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>fileCount</name>
      <anchor>a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>DocLnk</type>
      <name>selectedDocument</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QValueList&lt; DocLnk &gt;</type>
      <name>fileList</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FileSystem</name>
    <filename>classFileSystem.html</filename>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>disk</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>path</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>name</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>options</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>blockSize</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>totalBlocks</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>long</type>
      <name>availBlocks</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRemovable</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isWritable</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>StorageInfo</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FindDialog</name>
    <filename>classFindDialog.html</filename>
    <base>QDialog</base>
    <member kind="slot">
      <type>void</type>
      <name>slotNotFound</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>slotWrapAround</name>
      <anchor>i1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalFindClicked</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;txt, bool caseSensitive, bool backwards, int category)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>signalFindClicked</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;txt, const QDate &amp;dt, bool caseSensitive, bool backwards, int category)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>findText</name>
      <anchor>a0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseDate</name>
      <anchor>a1</anchor>
      <arglist>(bool show)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDate</name>
      <anchor>a2</anchor>
      <arglist>(const QDate &amp;dt)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>FontDatabase</name>
    <filename>classFontDatabase.html</filename>
    <base>QFontDatabase</base>
    <member kind="function">
      <type></type>
      <name>FontDatabase</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>families</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>loadRenderers</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>FontFactoryInterface</name>
    <filename>structFontFactoryInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QFontFactory *</type>
      <name>fontFactory</name>
      <anchor>a0</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Global</name>
    <filename>classGlobal.html</filename>
    <member kind="function" static="yes">
      <type>const QDawg &amp;</type>
      <name>fixedDawg</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QDawg &amp;</type>
      <name>addedDawg</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>const QDawg &amp;</type>
      <name>dawg</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addWords</name>
      <anchor>e3</anchor>
      <arglist>(const QStringList &amp;word)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>addWords</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;dictname, const QStringList &amp;word)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>createDocDir</name>
      <anchor>e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>findDocuments</name>
      <anchor>e6</anchor>
      <arglist>(DocLnkSet *folder, const QString &amp;mimefilter=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>applicationFileName</name>
      <anchor>e7</anchor>
      <arglist>(const QString &amp;appname, const QString &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setBuiltinCommands</name>
      <anchor>e8</anchor>
      <arglist>(Command *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>execute</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;exec, const QString &amp;document=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>setDocument</name>
      <anchor>e10</anchor>
      <arglist>(QWidget *receiver, const QString &amp;document)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>terminateBuiltin</name>
      <anchor>e11</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>terminate</name>
      <anchor>e12</anchor>
      <arglist>(const AppLnk *)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>isBuiltinCommand</name>
      <anchor>e13</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>applyStyle</name>
      <anchor>e14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>statusMessage</name>
      <anchor>e15</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QWidget *</type>
      <name>shutdown</name>
      <anchor>e16</anchor>
      <arglist>(bool=FALSE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QWidget *</type>
      <name>restart</name>
      <anchor>e17</anchor>
      <arglist>(bool=FALSE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>hideInputMethod</name>
      <anchor>e18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>showInputMethod</name>
      <anchor>e19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeHWClock</name>
      <anchor>e20</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>shellQuote</name>
      <anchor>e21</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>stringQuote</name>
      <anchor>e22</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>Global::Command</name>
    <filename>structGlobal_1_1Command.html</filename>
    <member kind="variable">
      <type>const char *</type>
      <name>file</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QWidget *(*</type>
      <name>func</name>
      <anchor>o1</anchor>
      <arglist>)(bool)</arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>maximized</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>documentary</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>ImageCodecInterface</name>
    <filename>structImageCodecInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QStringList</type>
      <name>keys</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>installIOHandler</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;format)=0</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>InputMethodInterface</name>
    <filename>structInputMethodInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QWidget *</type>
      <name>inputMethod</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, Qt::WFlags f)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>resetState</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPixmap *</type>
      <name>icon</name>
      <anchor>a2</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>onKeyPress</name>
      <anchor>a4</anchor>
      <arglist>(QObject *receiver, const char *slot)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Ir</name>
    <filename>classIr.html</filename>
    <base>QObject</base>
    <member kind="signal">
      <type>void</type>
      <name>done</name>
      <anchor>l0</anchor>
      <arglist>(Ir *)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Ir</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;filename, const QString &amp;description, const QString &amp;mimetype=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send</name>
      <anchor>a2</anchor>
      <arglist>(const DocLnk &amp;doc, const QString &amp;description)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>supported</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QLibrary</name>
    <filename>classQLibrary.html</filename>
    <member kind="enumeration">
      <name>Policy</name>
      <anchor>w3</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QLibrary</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;filename, Policy=Delayed)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QLibrary</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>resolve</name>
      <anchor>a2</anchor>
      <arglist>(const char *)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unload</name>
      <anchor>a3</anchor>
      <arglist>(bool force=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isLoaded</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPolicy</name>
      <anchor>a5</anchor>
      <arglist>(Policy pol)</arglist>
    </member>
    <member kind="function">
      <type>Policy</type>
      <name>policy</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>library</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QRESULT</type>
      <name>queryInterface</name>
      <anchor>a8</anchor>
      <arglist>(const QUuid &amp;, QUnknownInterface **)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void *</type>
      <name>resolve</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, const char *)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>MediaPlayerPluginInterface</name>
    <filename>structMediaPlayerPluginInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual MediaPlayerDecoder *</type>
      <name>decoder</name>
      <anchor>a0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual MediaPlayerEncoder *</type>
      <name>encoder</name>
      <anchor>a1</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>MenuAppletInterface</name>
    <filename>structMenuAppletInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>position</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QIconSet</type>
      <name>icon</name>
      <anchor>a2</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>text</name>
      <anchor>a3</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPopupMenu *</type>
      <name>popup</name>
      <anchor>a4</anchor>
      <arglist>(QWidget *parent) const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>activated</name>
      <anchor>a5</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPEMenuBar</name>
    <filename>classQPEMenuBar.html</filename>
    <base>QMenuBar</base>
    <member kind="function">
      <type></type>
      <name>QPEMenuBar</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QPEMenuBar</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>keyPressEvent</name>
      <anchor>b0</anchor>
      <arglist>(QKeyEvent *e)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>activateItem</name>
      <anchor>b1</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>goodbye</name>
      <anchor>b2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>int</type>
      <name>getOldFocus</name>
      <anchor>b3</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MenuButton</name>
    <filename>classMenuButton.html</filename>
    <base>QPushButton</base>
    <member kind="slot">
      <type>void</type>
      <name>select</name>
      <anchor>i0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>select</name>
      <anchor>i1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>selected</name>
      <anchor>l0</anchor>
      <arglist>(int)</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>selected</name>
      <anchor>l1</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MenuButton</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MenuButton</name>
      <anchor>a1</anchor>
      <arglist>(const QStringList &amp;items, QWidget *parent, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>currentItem</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currentText</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertItems</name>
      <anchor>a5</anchor>
      <arglist>(const QStringList &amp;items)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertItem</name>
      <anchor>a6</anchor>
      <arglist>(const QIconSet &amp;icon, const QString &amp;text=QString::null)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertItem</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;text)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insertSeparator</name>
      <anchor>a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLabel</name>
      <anchor>a9</anchor>
      <arglist>(const QString &amp;label)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>count</name>
      <anchor>a10</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchor>a11</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>text</name>
      <anchor>a12</anchor>
      <arglist>(int id)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUseLabel</name>
      <anchor>a13</anchor>
      <arglist>(bool b)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPEMessageBox</name>
    <filename>classQPEMessageBox.html</filename>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>confirmDelete</name>
      <anchor>e0</anchor>
      <arglist>(QWidget *parent, const QString &amp;caption, const QString &amp;object)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>MimeType</name>
    <filename>classMimeType.html</filename>
    <member kind="function">
      <type></type>
      <name>MimeType</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;ext_or_id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>MimeType</name>
      <anchor>a1</anchor>
      <arglist>(const DocLnk &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>id</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>description</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>pixmap</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QPixmap</type>
      <name>bigPixmap</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const AppLnk *</type>
      <name>application</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>appsFolderName</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>updateApplications</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>clear</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>registerApp</name>
      <anchor>e3</anchor>
      <arglist>(const AppLnk &amp;)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Network</name>
    <filename>classNetwork.html</filename>
    <member kind="function" static="yes">
      <type>void</type>
      <name>start</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;service=QString::null, const QString &amp;password=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>stop</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>settingsDir</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>serviceName</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;service)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>serviceType</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;service)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>serviceNeedsPassword</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;service)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>connectChoiceChange</name>
      <anchor>e6</anchor>
      <arglist>(QObject *receiver, const char *slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>choices</name>
      <anchor>e7</anchor>
      <arglist>(QListBox *=0, const QString &amp;dir=QString::null)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeProxySettings</name>
      <anchor>e8</anchor>
      <arglist>(Config &amp;cfg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>NetworkInterface *</type>
      <name>loadPlugin</name>
      <anchor>e9</anchor>
      <arglist>(const QString &amp;type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>int</type>
      <name>addStateWidgets</name>
      <anchor>e10</anchor>
      <arglist>(QWidget *parent)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>createServer</name>
      <anchor>e11</anchor>
      <arglist>(QObject *parent)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>networkOnline</name>
      <anchor>e12</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Node</name>
    <filename>classNode.html</filename>
    <member kind="function">
      <type>void</type>
      <name>addChild</name>
      <anchor>a2</anchor>
      <arglist>(Node *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAttributes</name>
      <anchor>a3</anchor>
      <arglist>(const QXmlAttributes &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; QString, QString &gt;</type>
      <name>attributeMap</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>attribute</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>nextNode</name>
      <anchor>a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>prevNode</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>parentNode</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>lastChild</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>firstChild</name>
      <anchor>a10</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTagName</name>
      <anchor>a11</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>tagName</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>data</name>
      <anchor>a14</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>subData</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;tag) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>appendData</name>
      <anchor>a16</anchor>
      <arglist>(const QString s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QProcess</name>
    <filename>classQProcess.html</filename>
    <base>QObject</base>
    <member kind="typedef">
      <type>long</type>
      <name>Q_LONG</name>
      <anchor>w0</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Q_LONG</type>
      <name>PID</name>
      <anchor>w1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Communication</name>
      <anchor>w6</anchor>
      <arglist></arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>tryTerminate</name>
      <anchor>i0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot">
      <type>void</type>
      <name>kill</name>
      <anchor>i1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>writeToStdin</name>
      <anchor>i2</anchor>
      <arglist>(const QByteArray &amp;buf)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>writeToStdin</name>
      <anchor>i3</anchor>
      <arglist>(const QString &amp;buf)</arglist>
    </member>
    <member kind="slot" virtualness="virtual">
      <type>virtual void</type>
      <name>closeStdin</name>
      <anchor>i4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>readyReadStdout</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>readyReadStderr</name>
      <anchor>l1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>processExited</name>
      <anchor>l2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>wroteToStdin</name>
      <anchor>l3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>launchFinished</name>
      <anchor>l4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QProcess</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QProcess</name>
      <anchor>a1</anchor>
      <arglist>(const QString &amp;arg0, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QProcess</name>
      <anchor>a2</anchor>
      <arglist>(const QStringList &amp;args, QObject *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~QProcess</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QStringList</type>
      <name>arguments</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearArguments</name>
      <anchor>a5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setArguments</name>
      <anchor>a6</anchor>
      <arglist>(const QStringList &amp;args)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addArgument</name>
      <anchor>a7</anchor>
      <arglist>(const QString &amp;arg)</arglist>
    </member>
    <member kind="function">
      <type>QDir</type>
      <name>workingDirectory</name>
      <anchor>a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingDirectory</name>
      <anchor>a9</anchor>
      <arglist>(const QDir &amp;dir)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCommunication</name>
      <anchor>a10</anchor>
      <arglist>(int c)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>communication</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>start</name>
      <anchor>a12</anchor>
      <arglist>(QStringList *env=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>launch</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;buf, QStringList *env=0)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>launch</name>
      <anchor>a14</anchor>
      <arglist>(const QByteArray &amp;buf, QStringList *env=0)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isRunning</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>normalExit</name>
      <anchor>a16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>exitStatus</name>
      <anchor>a17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QByteArray</type>
      <name>readStdout</name>
      <anchor>a18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QByteArray</type>
      <name>readStderr</name>
      <anchor>a19</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canReadLineStdout</name>
      <anchor>a20</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>canReadLineStderr</name>
      <anchor>a21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>readLineStdout</name>
      <anchor>a22</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>readLineStderr</name>
      <anchor>a23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>PID</type>
      <name>processIdentifier</name>
      <anchor>a24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flushStdin</name>
      <anchor>a25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>connectNotify</name>
      <anchor>b0</anchor>
      <arglist>(const char *signal)</arglist>
    </member>
    <member kind="function" protection="public">
      <type>void</type>
      <name>disconnectNotify</name>
      <anchor>b1</anchor>
      <arglist>(const char *signal)</arglist>
    </member>
    <member kind="friend" protection="protected">
      <type>friend class</type>
      <name>QProcessPrivate</name>
      <anchor>n0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Resource</name>
    <filename>classResource.html</filename>
    <member kind="function" static="yes">
      <type>QImage</type>
      <name>loadImage</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QPixmap</type>
      <name>loadPixmap</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QBitmap</type>
      <name>loadBitmap</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>findPixmap</name>
      <anchor>e3</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QIconSet</type>
      <name>loadIconSet</name>
      <anchor>e4</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>findSound</name>
      <anchor>e5</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QStringList</type>
      <name>allSounds</name>
      <anchor>e6</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Sound</name>
    <filename>classSound.html</filename>
    <member kind="function">
      <type></type>
      <name>Sound</name>
      <anchor>a0</anchor>
      <arglist>(const QString &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Sound</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>play</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>playLoop</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchor>a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isFinished</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>soundAlarm</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>StorageInfo</name>
    <filename>classStorageInfo.html</filename>
    <base>QObject</base>
    <member kind="slot">
      <type>void</type>
      <name>update</name>
      <anchor>i0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="signal">
      <type>void</type>
      <name>disksChanged</name>
      <anchor>l0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>StorageInfo</name>
      <anchor>a0</anchor>
      <arglist>(QObject *parent=0)</arglist>
    </member>
    <member kind="function">
      <type>const QList&lt; FileSystem &gt; &amp;</type>
      <name>fileSystems</name>
      <anchor>a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const FileSystem *</type>
      <name>fileSystemOf</name>
      <anchor>a2</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>hasCf</name>
      <anchor>e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>hasSd</name>
      <anchor>e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>bool</type>
      <name>hasMmc</name>
      <anchor>e2</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>StyleExtendedInterface</name>
    <filename>structStyleExtendedInterface.html</filename>
    <base>StyleInterface</base>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>description</name>
      <anchor>a0</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>hasSettings</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QWidget *</type>
      <name>create</name>
      <anchor>a2</anchor>
      <arglist>(QWidget *parent, const char *name=0)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual bool</type>
      <name>accept</name>
      <anchor>a3</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>reject</name>
      <anchor>a4</anchor>
      <arglist>()=0</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>StyleInterface</name>
    <filename>structStyleInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QStyle *</type>
      <name>style</name>
      <anchor>a0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Task</name>
    <filename>classTask.html</filename>
    <base>Qtopia::Record</base>
    <member kind="function">
      <type></type>
      <name>Task</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Task</name>
      <anchor>a1</anchor>
      <arglist>(const QMap&lt; int, QString &gt; &amp;fromMap)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~Task</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QMap&lt; int, QString &gt;</type>
      <name>toMap</name>
      <anchor>a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPriority</name>
      <anchor>a4</anchor>
      <arglist>(int priority)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>priority</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDescription</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;description)</arglist>
    </member>
    <member kind="function">
      <type>const QString &amp;</type>
      <name>description</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDueDate</name>
      <anchor>a8</anchor>
      <arglist>(const QDate &amp;date)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearDueDate</name>
      <anchor>a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDueDate</name>
      <anchor>a10</anchor>
      <arglist>(const QDate &amp;date, bool hasDue)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHasDueDate</name>
      <anchor>a11</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>const QDate &amp;</type>
      <name>dueDate</name>
      <anchor>a12</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hasDueDate</name>
      <anchor>a13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCompleted</name>
      <anchor>a14</anchor>
      <arglist>(bool b)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isCompleted</name>
      <anchor>a15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>save</name>
      <anchor>a16</anchor>
      <arglist>(QString &amp;buf) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>match</name>
      <anchor>a17</anchor>
      <arglist>(const QRegExp &amp;r) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCalendar</name>
      <anchor>e0</anchor>
      <arglist>(const QString &amp;filename, const QValueList&lt; Task &gt; &amp;tasks)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>writeVCalendar</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;filename, const Task &amp;task)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QValueList&lt; Task &gt;</type>
      <name>readVCalendar</name>
      <anchor>e2</anchor>
      <arglist>(const QString &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>TaskbarAppletInterface</name>
    <filename>structTaskbarAppletInterface.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual QWidget *</type>
      <name>applet</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual int</type>
      <name>position</name>
      <anchor>a1</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>TimeZoneSelector</name>
    <filename>classTimeZoneSelector.html</filename>
    <base>QHBox</base>
    <member kind="signal">
      <type>void</type>
      <name>signalNewTz</name>
      <anchor>l0</anchor>
      <arglist>(const QString &amp;id)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>TimeZoneSelector</name>
      <anchor>a0</anchor>
      <arglist>(QWidget *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~TimeZoneSelector</name>
      <anchor>a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>currentZone</name>
      <anchor>a2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentZone</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>QPEToolBar</name>
    <filename>classQPEToolBar.html</filename>
    <base>QToolBar</base>
    <member kind="function">
      <type></type>
      <name>QPEToolBar</name>
      <anchor>a0</anchor>
      <arglist>(QMainWindow *parent=0, const char *name=0)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual void</type>
      <name>childEvent</name>
      <anchor>b0</anchor>
      <arglist>(QChildEvent *e)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>QUuid</name>
    <filename>structQUuid.html</filename>
    <member kind="function">
      <type></type>
      <name>QUuid</name>
      <anchor>a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QUuid</name>
      <anchor>a1</anchor>
      <arglist>(uint l, ushort w1, ushort w2, uchar b1, uchar b2, uchar b3, uchar b4, uchar b5, uchar b6, uchar b7, uchar b8)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QUuid</name>
      <anchor>a2</anchor>
      <arglist>(const QUuid &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>QUuid</name>
      <anchor>a3</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>toString</name>
      <anchor>a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isNull</name>
      <anchor>a5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>QUuid &amp;</type>
      <name>operator=</name>
      <anchor>a6</anchor>
      <arglist>(const QUuid &amp;orig)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator==</name>
      <anchor>a7</anchor>
      <arglist>(const QUuid &amp;orig) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator!=</name>
      <anchor>a8</anchor>
      <arglist>(const QUuid &amp;orig) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&lt;</name>
      <anchor>a9</anchor>
      <arglist>(const QUuid &amp;orig) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>operator&gt;</name>
      <anchor>a10</anchor>
      <arglist>(const QUuid &amp;orig) const </arglist>
    </member>
    <member kind="variable">
      <type>ulong</type>
      <name>data1</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ushort</type>
      <name>data2</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>ushort</type>
      <name>data3</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uchar</type>
      <name>data4</name>
      <anchor>o3</anchor>
      <arglist>[8]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>WindowDecorationInterface</name>
    <filename>structWindowDecorationInterface.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>metric</name>
      <anchor>a1</anchor>
      <arglist>(Metric m, const WindowData *) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>drawArea</name>
      <anchor>a2</anchor>
      <arglist>(Area a, QPainter *, const WindowData *) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>drawButton</name>
      <anchor>a3</anchor>
      <arglist>(Button b, QPainter *, const WindowData *, int x, int y, int w, int h, QWSButton::State) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QRegion</type>
      <name>mask</name>
      <anchor>a4</anchor>
      <arglist>(const WindowData *) const </arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QString</type>
      <name>name</name>
      <anchor>a5</anchor>
      <arglist>() const=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual QPixmap</type>
      <name>icon</name>
      <anchor>a6</anchor>
      <arglist>() const=0</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>WindowDecorationInterface::WindowData</name>
    <filename>structWindowDecorationInterface_1_1WindowData.html</filename>
    <member kind="variable">
      <type>QRect</type>
      <name>rect</name>
      <anchor>o0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QPalette</type>
      <name>palette</name>
      <anchor>o1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>QString</type>
      <name>caption</name>
      <anchor>o2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Q_UINT32</type>
      <name>flags</name>
      <anchor>o3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>Q_UINT32</type>
      <name>reserved</name>
      <anchor>o4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>XmlHandler</name>
    <filename>classXmlHandler.html</filename>
    <base>QXmlDefaultHandler</base>
    <member kind="function">
      <type>bool</type>
      <name>startDocument</name>
      <anchor>a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>endDocument</name>
      <anchor>a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>startElement</name>
      <anchor>a4</anchor>
      <arglist>(const QString &amp;ns, const QString &amp;ln, const QString &amp;qName, const QXmlAttributes &amp;attr)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>endElement</name>
      <anchor>a5</anchor>
      <arglist>(const QString &amp;ns, const QString &amp;ln, const QString &amp;qName)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>characters</name>
      <anchor>a6</anchor>
      <arglist>(const QString &amp;ch)</arglist>
    </member>
    <member kind="function">
      <type>Node *</type>
      <name>firstNode</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Qtopia</name>
    <filename>namespaceQtopia.html</filename>
    <class kind="class">Qtopia::Record</class>
    <member kind="function" static="yes">
      <type>void</type>
      <name>hackString</name>
      <anchor>a81</anchor>
      <arglist>(QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>buildSortKey</name>
      <anchor>a82</anchor>
      <arglist>(const QString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>buildSortKey</name>
      <anchor>a83</anchor>
      <arglist>(const QString &amp;s1, const QString &amp;s2)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>buildSortKey</name>
      <anchor>a84</anchor>
      <arglist>(const QString &amp;s1, const QString &amp;s2, const QString &amp;s3)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QChar</type>
      <name>coll</name>
      <anchor>a85</anchor>
      <arglist>(QChar u)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compare</name>
      <anchor>a86</anchor>
      <arglist>(const QString &amp;s1, const QString &amp;s2)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>simplifyMultiLineSpace</name>
      <anchor>a87</anchor>
      <arglist>(const QString &amp;multiLine)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>escapeString</name>
      <anchor>a88</anchor>
      <arglist>(const QString &amp;plain)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>plainString</name>
      <anchor>a89</anchor>
      <arglist>(const char *escaped, unsigned int length)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>plainString</name>
      <anchor>a90</anchor>
      <arglist>(const QCString &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>QString</type>
      <name>plainString</name>
      <anchor>a91</anchor>
      <arglist>(const QString &amp;string)</arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>UID_ID</name>
      <anchor>a0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const int</type>
      <name>CATEGORY_ID</name>
      <anchor>a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" static="yes">
      <type>const char</type>
      <name>collationHack</name>
      <anchor>a80</anchor>
      <arglist>[]</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Qtopia::Record</name>
    <filename>classQtopia_1_1Record.html</filename>
    <member kind="function">
      <type></type>
      <name>Record</name>
      <anchor>a1</anchor>
      <arglist>(const Record &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>Record &amp;</type>
      <name>operator=</name>
      <anchor>a3</anchor>
      <arglist>(const Record &amp;c)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>match</name>
      <anchor>a4</anchor>
      <arglist>(const QRegExp &amp;) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCategories</name>
      <anchor>a5</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCategories</name>
      <anchor>a6</anchor>
      <arglist>(int single)</arglist>
    </member>
    <member kind="function">
      <type>const QArray&lt; int &gt; &amp;</type>
      <name>categories</name>
      <anchor>a7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reassignCategoryId</name>
      <anchor>a8</anchor>
      <arglist>(int oldId, int newId)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>uid</name>
      <anchor>a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setUid</name>
      <anchor>a10</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>isValidUid</name>
      <anchor>a11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assignUid</name>
      <anchor>a12</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual QString</type>
      <name>customField</name>
      <anchor>a13</anchor>
      <arglist>(const QString &amp;) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setCustomField</name>
      <anchor>a14</anchor>
      <arglist>(const QString &amp;, const QString &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeCustomField</name>
      <anchor>a15</anchor>
      <arglist>(const QString &amp;)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator==</name>
      <anchor>a16</anchor>
      <arglist>(const Record &amp;r) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>operator!=</name>
      <anchor>a17</anchor>
      <arglist>(const Record &amp;r) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>QString</type>
      <name>idsToString</name>
      <anchor>e0</anchor>
      <arglist>(const QArray&lt; int &gt; &amp;ids)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>QArray&lt; int &gt;</type>
      <name>idsFromString</name>
      <anchor>e1</anchor>
      <arglist>(const QString &amp;str)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>void</type>
      <name>dump</name>
      <anchor>e2</anchor>
      <arglist>(const QMap&lt; int, QString &gt; &amp;map)</arglist>
    </member>
    <member kind="function" protection="public" virtualness="pure">
      <type>virtual UidGen &amp;</type>
      <name>uidGen</name>
      <anchor>b0</anchor>
      <arglist>()=0</arglist>
    </member>
    <member kind="function" protection="public" virtualness="virtual">
      <type>virtual QString</type>
      <name>customToXml</name>
      <anchor>b1</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
</tagfile>
