#include <qdom.h>
#include <domutil.h>

#include <qcheckbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <ktextedit.h>

#include <kdebug.h>

#include "opiepackageconfigdlg.h"

OpiePackageConfigDlg::OpiePackageConfigDlg(  QDomDocument &doc, const QString& base,
                                             QWidget* wid )
    : OpiePackageConfig( wid ), m_doc( doc ), m_base( base )
{
    /* read the template */
    int temp =DomUtil::readIntEntry(m_doc, "/kdevtrollproject/packaging/template");
    switch(temp) {
    case 0:
    default:
        radApplication->setChecked( true );
        break;
    case 1:
        radLibrary->setChecked( true );
        break;
    case 2:
        radApplet->setChecked( true );
        break;
    case 3:
        radCustom->setChecked( true );
        break;
    }

    /* Application stuff */
    cmbCategory->setCurrentText( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/appcategory") );

    /* DEST for the target*/
    lneCustom->setText(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/custom_dest") );

    /* 2nd Page */
    lnePackage->setText( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/package" ) );
    cmbPrio->setCurrentItem( DomUtil::readIntEntry(m_doc, "/kdevtrollproject/packaging/owner/prio" ) );
    lneSection->setText(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/section" ) );
    lneMaintainer->setText( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/maintainer" ) );
    lneArch->setText(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/arch" ) );
    lneDepends->setText( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/depends" ) );
    lneVersion->setText(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/version" ) );
    lneDesc->insert(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/owner/desc" ) );

    /* 3rd page */
    lnePre->insert(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/scripts/pre" ) );
    lnePost->insert( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/scripts/post" ) );

    /* 4th page */
    lnePreRem->insert(  DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/scripts/pre_rem" ) );
    lnePostRem->insert( DomUtil::readEntry(m_doc, "/kdevtrollproject/packaging/scripts/post_rem" ) );
}

OpiePackageConfigDlg::~OpiePackageConfigDlg() {
}

void OpiePackageConfigDlg::slotAccept() {
    kdDebug() << "Slot Accept Opie Package Config Dlg" << endl;
/* Now on to saving that suckers */
    int temp = 0;
    if ( radApplication->isChecked() )
        temp = 0;
    else if ( radLibrary->isChecked() )
        temp = 1;
    else if ( radApplet->isChecked() )
        temp = 2;
    else if ( radCustom->isChecked() )
        temp = 3;
    DomUtil::writeIntEntry(m_doc, "/kdevtrollproject/packaging/template", temp);

    /* Application stuff */
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/appcategory",
                        cmbCategory->currentText() );
    /* DEST for the target*/
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/custom_dest",
                       lneCustom->text() );

    /* 2nd Page */
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/package",
                       lnePackage->text() );
    DomUtil::writeIntEntry(m_doc, "/kdevtrollproject/packaging/owner/prio",
                          cmbPrio->currentItem() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/section",
                       lneSection->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/maintainer",
                       lneMaintainer->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/arch",
                       lneArch->text());
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/depends",
                       lneDepends->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/version",
                       lneVersion->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/owner/desc",
                       lneDesc->text() );

    /* 3rd page */
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/scripts/pre",
                       lnePre->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/scripts/post",
                       lnePost->text() );

     /* 4th page */
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/scripts/pre_rem",
                       lnePreRem->text() );
    DomUtil::writeEntry(m_doc, "/kdevtrollproject/packaging/scripts/post_rem",
                       lnePostRem->text() );
}


#include "opiepackageconfigdlg.moc"
