/*
 * GPLv2 zecke@handhelds.org
 */

#ifndef OPIE_PACKAGING_STUFF_H
#define OPIE_PACKAGING_STUFF_H

#include <qobject.h>

class TrollProjectPart;

class TempPackaging;
class KProcess;
class OpiePackagingStuff : public QObject{
    Q_OBJECT
public:
    OpiePackagingStuff(  TrollProjectPart* parent );

public slots:
    void slotBuildPackage();
    void slot18nPackage();
    void slotFillLanguage();
    void slotUpdateAndRelease();
    void slotGenerateAll();
    void slotAddLanguage(int id);

private:
    void generateLang(const QString& lang );
    QString basePath()const;
    QString proFile(const QString&);
    void mkdirs( const QStringList& );

private:
    void addControl( TempPackaging* );
    void addScripts( TempPackaging*,const QString&,const QString& );
    void installApp( TempPackaging*,const QString&,const QString& );
    void installLib( TempPackaging*,const QString&,const QString& );
    void installApplet(  TempPackaging*, const QString&,const QString& );
    void installCustom(  TempPackaging*, const QString&,const QString&,
                         const QString& _str );

private slots:
    void slotOutPut( KProcess*, char* buffer, int len );

private:
    TrollProjectPart *m_part;
    QString m_outp;
};
#endif
