#ifndef _HAVE_MBDESKTOP_H
#define _HAVE_MBDESKTOP_H

#ifdef USE_DNOTIFY 		/* Needed for dnotify stuff from fcntl.c */
#define _GNU_SOURCE
#endif 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <fcntl.h> 
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <ctype.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysymdef.h>
#include <X11/keysym.h>
#include <X11/Xmd.h>

#include "config.h"

#include "item_tasks.h"
#include "mbpixbuf.h"
#include "mbutil.h"
#include "mbdotdesktop.h"

#ifdef USE_XFT
#include <X11/Xft/Xft.h>
#endif

#ifdef USE_FAM
#include <fam.h>
#include <sys/select.h>
#endif

#ifdef USE_LIBSN
#define SN_API_NOT_YET_FROZEN 1
#include <libsn/sn.h>
#endif 

#ifdef USE_XSETTINGS
#include <xsettings-client.h>
#endif 



#define DD_DIR DATADIR "/applications/" 

/* #define DD_DIR "/tmp/" */
#define PIXMAP_PATH PIXMAPSDIR


#ifdef DEBUG
#define DBG(txt, args... ) fprintf(stderr, "DEBUG: " txt , ##args )
#else
#define DBG(txt, args... ) /* nothing */
#endif

#define ITEM_WIDTH  96 /* 48 */ 
#define ITEM_HEIGHT 108 /* 54 */ 
#define ICON_SIZE   64 /* 32 */

#ifdef USE_PNG
#define NO_APP_ICON    "mbnoapp.png"
#define FOLDER_PATH    DATADIR "/pixmaps/mbfolder.png"
#else
#define NO_APP_ICON    "mbnoapp.xpm"
#define FOLDER_PATH    DATADIR "/pixmaps/mbfolder.xpm"
#endif

#ifdef USE_XFT
#define FONT_DESC "verdana-6:bold"
#define FONT_TITLE_DESC "verdana-8:bold"
#else
#define FONT_DESC "fixed"
#define FONT_TITLE_DESC "fixed"
#endif

#define FONT_COL "rgb:255/255/255"

#define ITEM_TEXT_ROWS 2

#define DEFAULT_DESKTOP_BG_COL "#a1b2e9"

enum {
  VIEW_ICONS,
  VIEW_LIST,
};

enum {	   /* from .desktop type key should this be moved to dotdesktop.c ? */
  ITEM_TYPE_UNKNOWN = 0,
  ITEM_TYPE_APP,
  ITEM_TYPE_FOLDER,  /* Same as 'official' Directory */
  ITEM_TYPE_LINK,    /* URL  */

  ITEM_TYPE_FSDEVICE, 
  ITEM_TYPE_MIMETYPE, 
  ITEM_TYPE_DIRECTORY, 
  ITEM_TYPE_SERVICE, 
  ITEM_TYPE_SERVICETYPE ,

  ITEM_TYPE_TASK_FOLDER, 		/* Not official */
  ITEM_TYPE_PREVIOUS,
};

enum {
  BG_SOLID = 1,
  BG_TILED_PXM,
  BG_STRETCHED_PXM,
  BG_GRADIENT_HORIZ,
  BG_GRADIENT_VERT,
  BG_CENTERED_PXM,
};

typedef void (*MBDesktopCB)( void *data1, void *data2 ) ;

typedef struct _mbdesktop_item {

  int type;
  int view;

  char *name;
  char *comment;
  MBPixbufImage *icon;
  char *exec_str;		/* TODO: rename to data */

  Window win;

  MBDesktopCB exec_cb;		/* TODO: rename to activate_cb */

  MBDesktopCB populate_cb; 	/* only populates children */

  struct _mbdesktop_item *item_next_sibling; 
  struct _mbdesktop_item *item_prev_sibling; 
  struct _mbdesktop_item *item_child; 
  struct _mbdesktop_item *item_parent; 

  int x;
  int y;

} MBDesktopItem;

typedef struct item_sizes {

  int width;
  int height;
  int icon_size;
  int box_yoffset;
  int box_size;
  int txt_yoffset;

} MBDesktopItemDimentions;

typedef struct _mbdesktop_bg {
  int type;

  union {
    char *filename;
    int cols[3];
    int gcols[6];
  } data;

} MBDesktopBG;

typedef struct _mbdesktop {

  Display *dpy;
  int scr;

#ifdef USE_XFT  
  XftFont *xftfont;
  XftFont *xfttitlefont;
  XftColor xftcol;
  XftDraw *xftdraw;
#else
  XFontStruct* font;
  XFontStruct* titlefont;
#endif

  GC invert_gc;
  GC gc;

  Window root, win_top_level;

  Bool have_focus;

  int current_view; 		
  MBDesktopItemDimentions itemDim;

  MBDotDesktopFolders *ddfolders;

  MBDesktopItem *top_head_item;      /* Very top of item list  */
  MBDesktopItem *current_head_item;  /* Top of each child list */
  MBDesktopItem *kbd_focus_item;     /* Kdb focused item       */
  MBDesktopItem *scroll_offset_item; /* Initially displayed item if scrolled */
  MBDesktopItem *last_visible_item;

  Bool had_kbd_input;

  int desktop_width;
  int desktop_height;

  int workarea_width;
  int workarea_height;
  int workarea_x;
  int workarea_y;

  MBPixbuf    *pixbuf;

  Pixmap backing_cache;

  MBPixbufImage *bg_img;
  MBDesktopBG *bg;

  char *theme_name;
  char *bg_def;

  MBPixbufImage *img_scroll_up;
  MBPixbufImage *img_scroll_down;


  /* For crapping dir polling */
  time_t dd_dir_mtime;

  char *dd_dir;
  char *pixmaps_dir;
  char *folder_img_path;

  int icon_size;  
  int item_width;
  int item_height;
  int title_offset;

#ifdef USE_FAM

  FAMConnection fam_conn;
  FAMRequest *fam_req;

#endif 

#ifdef USE_LIBSN
  SnDisplay *sn_dpy;
#endif 

#ifdef USE_XSETTINGS
  XSettingsClient *xsettings_client;
#endif 

  Pixmap root_pxm;

} MBDesktop;

MBDesktopItem *
mbdesktop_item_new_with_params(
			       MBDesktop *mb,
			       char *name, 
			       char *comment, 
			       MBPixbufImage *icon,
			       char *exec_str,
			       MBDesktopCB exec_cb,
			       MBDesktopCB populate_cb,
			       int type,
			       int view );

void 
mbdesktop_view_paint(MBDesktop *mb, Bool use_cache);

Bool
mbdesktop_get_workarea(MBDesktop *mb, int *x, int *y, int *w, int *h);


void
mbdesktop_items_free(MBDesktop *mb, MBDesktopItem *item);

Bool
mbdesktop_bg_parse_spec(MBDesktop *mb, char *spec);


#endif
