#include "panel_app.h"

MBPanelApp*
panel_app_list_get_prev(MBPanel *panel, MBPanelApp *papp)
{
  MBPanelApp *tmp = panel->panel_app_head;
  
  if (tmp == NULL || papp == tmp) return NULL;

  while (tmp->next != NULL)
    {
      if (tmp->next == papp) return tmp;
      tmp = tmp->next;
    }
  
  return NULL;
}

MBPanelApp*
panel_app_list_get_last(MBPanel *panel)
{
  MBPanelApp *tmp = panel->panel_app_head;
  
  if (tmp == NULL) return NULL;

  while (tmp->next != NULL) tmp = tmp->next;

  return tmp;
}


void
panel_app_list_prepend(MBPanel *panel, MBPanelApp *papp_new)
{
  MBPanelApp *tmp;
  if (panel->panel_app_head == NULL)
    {
      panel->panel_app_head = papp_new;
    }
  else
    {
      tmp = panel->panel_app_head;
      panel->panel_app_head = papp_new;
      papp_new->next = tmp;
    }
}

void
panel_app_list_append(MBPanel *panel, MBPanelApp *new_client)
{
  MBPanelApp *tmp;
  if (panel->panel_app_head == NULL)
    {
      panel->panel_app_head = new_client;
    }
  else
    {
      tmp = panel->panel_app_head;
      while ( tmp->next != NULL ) tmp = tmp->next;
      tmp->next = new_client;
    }
  new_client->next = NULL;

}

void
panel_app_list_insert_after(MBPanel *panel, MBPanelApp *papp, 
			    MBPanelApp *new_papp)
{
  MBPanelApp *tmp;
  tmp = papp->next;
  papp->next = new_papp;
  new_papp->next = tmp;
}

void
panel_app_list_remove(MBPanel *panel, MBPanelApp *papp)
{
  MBPanelApp *prev_papp = panel_app_list_get_prev(panel, papp);

  if (prev_papp == NULL) 
    {
      panel->panel_app_head = papp->next;
    }
  else
    {
      prev_papp->next = papp->next;
    }
  return;
}

void
panel_app_list_add(MBPanel *panel, MBPanelApp *papp_new)
{
  MBPanelApp *papp_cur = panel->panel_app_head;

  int cur_sz = 0, new_sz = 0;

  if (panel->orientation == North || panel->orientation == South)
    {
      new_sz = papp_new->w;
    } else {
      new_sz = papp_new->h;
    }

  if (papp_cur == NULL)
    {
      DBG("%s() : empty panel, adding head\n", __func__ );
      panel_app_list_append(panel, papp_new);
      return;
    }

  /* check if new->offset is less than panel->panel_app_list_head->offset; */
  if (papp_new->offset < papp_cur->offset && new_sz <= papp_cur->offset)
    {
      DBG("%s() : papp_new->offset ( %i ) < papp_cur->offset ( %i ) \n\t && papp_new->w ( %i ) < papp_cur->offset ( %i ) \n", __func__, papp_new->offset, papp_cur->offset, papp_new->w , papp_cur->offset );
      panel_app_list_prepend(panel, papp_new);
      return;
    }

  while (papp_cur != NULL)
    {
      DBG("%s() : iterateing on %s\n", __func__, papp_cur->name );

      if (panel->orientation == North || panel->orientation == South)
	{
	  cur_sz = papp_cur->w;
	} else {
	  cur_sz = papp_cur->h;
	}

      if (papp_cur->next == NULL)
	{
	  if (!papp_new->offset) papp_new->offset = papp_cur->offset + cur_sz;
	  DBG("%s() : next is null, appending at %i\n", __func__,
	      papp_new->offset );

	  panel_app_list_append(panel, papp_new);
	  return;
	}

      DBG("%s() : next is  %s\n", __func__, papp_cur->next->name );

      /*
      if (papp_new->offset && ( papp_cur->offset < papp_new->offset ))
	{
	  DBG("%s() : papp_new->offset ( %i ) && ( papp_cur->offset ( %i ) < papp_new->offset ( %i ) )\n", __func__, papp_new->offset, papp_cur->offset, papp_new->offset);
	  papp_cur = papp_cur->next;
	  continue;
	}
      */

      /* XXX below may be broke */
      if (papp_new->offset)
	{
	  DBG("%s() : checking ((papp_cur->next->offset ( %i )- papp_new->offset ( %i )) >= papp_new->w ( %i ))\n", __func__, papp_cur->next->offset, papp_new->offset, papp_new->w);
	  if ((papp_cur->next->offset - papp_new->offset) >= new_sz)
	    {
	      panel_app_list_insert_after(panel, papp_cur, papp_new);
	      return;
	    }
	  else
	    {
	      papp_cur = papp_cur->next;
	      continue;
	    }
	}

      DBG("%s() : checking (papp_cur->next->offset ( %i ) - (papp_cur->offset ( %i ) + papp_cur->w ( %i ))) >= papp_new->w ( %i ))\n", __func__, papp_cur->next->offset, papp_cur->offset, papp_cur->w, papp_new->w);
	  
      if ((papp_cur->next->offset - (papp_cur->offset + cur_sz)) >= new_sz)
	{
	  
	  papp_new->offset = papp_cur->offset + cur_sz;
	  panel_app_list_insert_after(panel, papp_cur, papp_new);
	  return;
	}
      papp_cur = papp_cur->next;
    }
}

void
panel_app_name_get(MBPanel *panel, MBPanelApp *papp)
{
  XFetchName(panel->dpy, papp->win, &papp->name);
  if (papp->name == NULL) {
    XStoreName(panel->dpy, papp->win, "<unnamed>");
    XFetchName(panel->dpy, papp->win, &papp->name);
    if (papp->name == NULL) papp->name = strdup("<unnamed>");
  }
}

Window
panel_app_get_client_leader_win(MBPanel *panel, MBPanelApp *papp)
{
  Atom realType;
  unsigned long n;
  unsigned long extra;
  int format;
  int status;
  Window* value = NULL, win_result = None;
  
  status = XGetWindowProperty(panel->dpy, papp->win,
			      panel->atoms[ATOM_WM_CLIENT_LEADER],
			      0L, 16L,
			      0, XA_WINDOW, &realType, &format,
			      &n, &extra, (unsigned char **) &value);
  if (status == Success && realType == XA_WINDOW 
      && format == 32 && n == 1 && value != NULL)
    {
      win_result = (Window) value[0];
    }
  
  if (value) XFree(value);

  return win_result;
}

int*
panel_app_icon_prop_data_get(MBPanel *d, MBPanelApp *papp)
{
  Atom type;
  int format;
  long bytes_after;
  unsigned char *data = NULL;
  long n_items;
  int result;

  result =  XGetWindowProperty (d->dpy, papp->win, 
			        d->atoms[ATOM_NET_WM_ICON],
				0, 100000L,
				False, XA_CARDINAL,
				&type, &format, &n_items,
				&bytes_after, (unsigned char **)&data);

  if (result != Success || data == NULL)
    {
      if (data) XFree (data);
      DBG("%s() failed for %s (XID: %li)\n", __func__, papp->name, papp->win);
      return NULL;
    }

  return (int *)data;
}


MBPanelApp *
panel_app_new(MBPanel *panel, Window win, char *cmd_str, int x_offset)
{
  MBPanelApp *papp;
  XWindowAttributes attr;

  papp = NEW(MBPanelApp);
  
  papp->offset      = x_offset;
  papp->next   = NULL;
  papp->win    = win;
  papp->panel  = panel;
  papp->ignore = False;

  // client_set_state(c, WithdrawnState); XXX

  XGetWindowAttributes(panel->dpy, win, &attr);  
  
  if (papp->offset == 0) /* not previous set it ( ie by the config file ) */
    {
      if (attr.x < 0) 		/* XXX todo for vertically orientated */
	{
	  DBG("%s() panel app is -ive positioned\n", __func__ );
	  papp->offset = panel->w + attr.x - attr.width; 
	}
      else
	papp->offset = attr.x;
    }

  papp->w = attr.width;
  papp->h = attr.height;

  panel_app_list_add(panel, papp); 

  panel_app_name_get(panel, papp);

  /* panel_app_command_prop_get(panel, papp); */

  papp->cmd_str = cmd_str;

  if (panel->orientation == North || panel->orientation == South)
    {
      papp->y = (panel->h - papp->h) / 2;
      papp->x = papp->offset;
    }
  else
    {
       papp->x = (panel->w - papp->w) / 2;
       papp->y = papp->offset;
    }


  // reparent etc

  // call to enable scrolling etc ..

  panel_app_deliver_config_event(panel, papp);

  XReparentWindow(panel->dpy, papp->win, panel->win, papp->x, papp->y);

  return papp;
}

void
panel_app_handle_configure_request(MBPanel *panel, XConfigureRequestEvent *ev)
{
  XWindowChanges xwc;
  MBPanelApp *papp = NULL;
  
  papp = panel_app_get_from_window( panel, ev->window );

  if (papp != NULL)
    {
      DBG("%s() found win %s\n", __func__, papp->name);

      xwc.width  = ev->width;
      xwc.height = ev->height;

      if (panel->orientation == North || panel->orientation == South)
	{
	  xwc.x = papp->x; 	      /* NOT allowed to move themselves */
	  xwc.y = papp->y + panel->y; //ev->y;

	  if (xwc.width != papp->w)	/* Handle width changes */
	    {
	      MBPanelApp *ptmp = papp->next;
	      if (papp->next)
		{
		  int unused_space = papp->next->offset 
		    - (papp->offset + xwc.width);
		  DBG("%s() unused space %i - (papp->x ( %i ) + xwc.width ( %i )) - papp->next->x ( %i )\n", __func__, unused_space, papp->offset, xwc.width, papp->next->offset);
		  while ( ptmp != NULL)
		    {
		      int offset = (ptmp->offset + (xwc.width - papp->w));
		      panel_app_move_to(panel, ptmp, offset - unused_space);
		      ptmp = ptmp->next;
		    }
		}
	    }
	} else { 		/* East / West orientated dock */
	  xwc.x = papp->x;
	  xwc.y = papp->y;
	}
      xwc.border_width = 0;
      xwc.sibling      = None;
      xwc.stack_mode   = None;
      DBG("%s() setting x: %i , y: %i\n", __func__, xwc.x, xwc.y );
      XConfigureWindow(panel->dpy, papp->win, ev->value_mask, &xwc);

    }
}

void
panel_app_deliver_config_event(MBPanel *panel, MBPanelApp *papp)
{
   XConfigureEvent ce;
   
   ce.type = ConfigureNotify;
   ce.event  = papp->win;
   ce.window = papp->win;
   
   if (PANEL_IS_VERTICAL(panel))
     {
       ce.x = papp->x + panel->x;
       ce.y = papp->y;
     } else {
       ce.x = papp->x;
       ce.y = papp->y + panel->y; 	/* XXX Bodged ? */
     }
   
   ce.width  = papp->w;
   ce.height = papp->h;
   ce.border_width = 0;
   ce.above =  panel->win;
   ce.override_redirect = 0;
   
   XSendEvent(panel->dpy, papp->win, False,
	      StructureNotifyMask, (XEvent *)&ce);
}


void 
panel_app_move_to(MBPanel *panel, MBPanelApp *papp, int origin_offset)
{
  if (panel->orientation == North || panel->orientation == South)
    {
      papp->x = origin_offset;
      papp->y = (panel->h - papp->h) / 2;
    }
  else
    {
      papp->y = origin_offset;
      papp->x = (panel->w - papp->w) / 2;
    }

  papp->offset = origin_offset;
  XMoveWindow(panel->dpy, papp->win, papp->x, papp->y);      

  panel_scroll_update_visibility(panel);
}

void
panel_app_destroy(MBPanel *panel, MBPanelApp *papp)
{
   MenuItem *tmp = NULL;
   
   if (!papp) return;
      
   /* remove popup menu entry  XXX this functionaility should be in mbmenu */
   tmp = panel->remove_menu->items;
   
   while (tmp != NULL)
     {
       if ((MBPanelApp *)tmp->cb_data == papp)
	 {
	   mb_menu_item_remove(panel->mbmenu, panel->remove_menu, tmp);
	   break;
	 }
       tmp = tmp->next_item;
     }
   
   panel_app_list_remove(panel, papp);

#if 0
   /* See if we still need the scroll button */
   if (dock->scroll_active)
     if ((p = client_get_furthest_right(dock)) != NULL)
       if ( (p->x + p->w + (-1 * dock->scroll_offset)) < dock->w) 
	 {
	   Client *q = dock->head_client;
	   while( q != NULL)
	     {
	       q->x += (-1 * dock->scroll_offset);
	       client_update(dock, q);
	       q = q->next;
	     }
	   dock_deactivate_scroll(dock);
	 }
#endif

   if (papp->cmd_str) free(papp->cmd_str);

   free(papp);

}


/* Utilities */

MBPanelApp*
panel_app_get_from_window(MBPanel *panel, Window win)
{
   MBPanelApp *papp = panel->panel_app_head;
   DBG("%s() called, looking for win %li\n", __func__, win);
   while( papp != NULL)
   {
     DBG("%s() check %s ( %li )\n", __func__, papp->name, papp->win);
      if (papp->win == win) return papp;
      papp = papp->next;
   }
   return NULL;
}


#if 0

Client *
client_new(Dock *dock, Window win)
{
   Client *c;
   long icccm_mask;
   XWindowAttributes attr;
   XSizeHints	*size;
   Window win_with_cmd_prop;

   c = NEW(Client);

   c->next = NULL;
   c->win = win;
   c->dock = dock;

   c->next = NULL;
   
   if (dock->tail_client != NULL)
      dock->tail_client->next = c;
   dock->tail_client = c;

   if (dock->head_client == NULL) dock->head_client = c;

   XGetWindowAttributes(dock->dpy, win, &attr);

   size = XAllocSizeHints();
   if ( !XGetWMNormalHints(dock->dpy, win, size, &icccm_mask) )
   {
      c->w = attr.width;
      c->h = attr.height;
   } else {
      if (size->flags & PBaseSize) {
	 c->w  = size->base_width;
	 c->h =  size->base_height;
      } else if (size->flags &  PMinSize) {
	 c->w  = size->min_width;
	 c->h = size->min_height;
      } else {
	 c->w = attr.width;
	 c->h = attr.height;
      }
   }

   /* TODO UTF8 naming */
   XFetchName(dock->dpy, win, &c->name);
   if (c->name == NULL) {
       XStoreName(dock->dpy, win, "<unnamed>");
       XFetchName(dock->dpy, win, &c->name);
       if (c->name == NULL) c->name = "<unnamed>";
   }


   if (!XGetCommand(dock->dpy, win_with_cmd_prop, &c->argv, &c->argc))
   {
     /* TODO XGetWMClientMachine(display, w, text_prop_return) */
      c->argv = NULL;
      c->argc = 0;
   }

   c->x = client_get_init_x_pos(dock,c);
   c->y = client_get_init_y_pos(dock,c);

   c->ignore = False;
   
   DBG("docking with %i, %i : %ix%i\n", c->x, c->y, c->w, c->h);

   //client_deliver_config(dock, c);

   XReparentWindow(dock->dpy, c->win, dock->win, c->x, c->y);

   client_update(dock, c);

   return c;
}

Bool
client_get_command_str(Dock *d, Client *c, char *cmd)
{
   int i;
   if (!c->argc) return False;
   strcat(cmd, c->argv[0]);
   while(*cmd != '\0') cmd++;

   for(i=1;i<c->argc;i++)
   {
     /*
       This is a gental hack for now to keep ~/.mbdock readable.
       Later on we will probably just 'serialize' argv combined
       with position infomation
     */
     char *p = c->argv[i];
     *cmd++ = ' ';

     if (strpbrk(p, " \t") == NULL)
       {
	 while (*p) *cmd++ = *p++;
       } else {
	 *cmd++ = '\'';
	 while (*p)
	   {
	     if (*p == '\'')
	       *cmd++ = '\\';
	     *cmd++ = *p++;
	   }
	 *cmd++ = '\'';
       }
   }
   return True;
}

int
client_get_init_x_pos(Dock *d, Client *c)
{
   Client *p;
   int x = d->session_init_x_pos;
   int done = 0;

   DBG("client_get_init_x_pos called. init_x is %i:", x);
   
   while (!done)
     {
       if ( (p = client_get_closest_right(d, c, x) ) != NULL)
	 {
	   DBG("\tClosest is %s ( p->x is %i )\n", p->name, p->x);
	   if ( p == c || (p->x - x) > c->w)
	     done = 1;
	   else
	     x = p->x + p->w;
	 } else {
	   done = 1;
	 }
     }
   d->session_init_x_pos = 0;
   return x;
}

Client *
client_get_closest_right(Dock *dock, Client *c, int pos)
{
  Client *q = NULL;
  int dist = 0xFFFF;
  Client *p = dock->head_client;

  DBG("client_get_closest_right(%i):\n", pos);

  while( p != NULL)
    {
      if (p != c)
	{
	  DBG("\t Checking %s p->x (%i) >= pos ( %i ) && p->x < dist ( %i )\n",
	      p->name, p->x, pos, dist);
	  if ((p->x >= pos && p->x <= dist))
	    {
	      q = p;
	      dist = q->x;
	    }
	}
      p = p->next;
    }
  return q;
}


int
client_get_init_y_pos(Dock *d, Client *c)
{
   return ( (d->h - c->h) / 2 );
}

void
client_destroy(Dock *dock, Client *c)
{
   Client *p;
   int x,w;
   MenuItem *tmp = NULL;
   
   if (!c) return;
   
   x = c->x;
   w = c->w;
      
   /* remove popup menu entry */
   tmp = dock->remove_menu->items;
   
   if ((Client *)tmp->cb_data == c)
     {
       dock->remove_menu->items = dock->remove_menu->items->next;
       free(tmp);
     }
   else
     {
       while (tmp != NULL)
	 {
	   if (tmp->next_item
	       && (Client *)tmp->next_item->cb_data == c)
	     {
	       free(tmp->next_item);
	       tmp->next_item = tmp->next_item->next_item;
	       continue;
	     }
	   tmp = tmp->next_item;
	 }
     }
   
   /* Remove from list */
   if (dock->head_client == c)
     {
       dock->head_client = c->next;
     } else {
       
       for (p=dock->head_client; p->next != c; p = p->next);
       if ( dock->tail_client == c )
	 {
	   dock->tail_client = p;
	   p->next = NULL;
	 } else {
	   p->next = c->next;
	 }
     }

   /* See if we still need the scroll button */
   if (dock->scroll_active)
     if ((p = client_get_furthest_right(dock)) != NULL)
       if ( (p->x + p->w + (-1 * dock->scroll_offset)) < dock->w) 
	 {
	   Client *q = dock->head_client;
	   while( q != NULL)
	     {
	       q->x += (-1 * dock->scroll_offset);
	       client_update(dock, q);
	       q = q->next;
	     }
	   dock_deactivate_scroll(dock);
	 }

   free(c);

}

void
client_handle_configure(Dock *dock, Client *c, XConfigureRequestEvent *ev)
{
  XWindowChanges xwc;

  DBG("sending configure to %s\n", c->name);

  xwc.width  = c->w;
  xwc.height = c->h;
  xwc.x = ev->x;
  xwc.y = c->y + dock->y; //ev->y;

  c->x = ev->x;
  //c->y = c->y + dock->y; // ev->y;
  
  XConfigureWindow(dock->dpy, c->win,
		   ev->value_mask, &xwc);
}

void
client_deliver_config(Dock *dock, Client *c)
{
   XConfigureEvent ce;
   
   ce.type = ConfigureNotify;
   ce.event = c->win;
   ce.window = c->win;
   
   ce.x = c->x;
   ce.y = c->y + dock->y; 	/* BROKE - to do fix  */
   
   ce.width  = c->w;
   ce.height = c->h;
   ce.border_width = 0;
   ce.above = None;
   ce.override_redirect = 0;
   
   XSendEvent(dock->dpy, c->win, False,
	      StructureNotifyMask, (XEvent *)&ce);
}


Client *
client_find(Dock *dock, Window win_to_find)
{
   Client *c = dock->head_client;
   while( c != NULL)
   {
      if (c->win == win_to_find) return c;
      c = c->next;
   }
   return NULL;
}


Client *
client_get_furthest_right(Dock *dock)
{
  Client *q = NULL, *p = dock->head_client;
  int pos = 0;
  while( p != NULL)
    {
      if (p->x >= pos)
	{
	  q = p;
	  pos = q->x;
	}
      p = p->next;
    }
  return q;
}



void
client_update(Dock *dock, Client *c)
{

  XMoveWindow(dock->dpy, c->win, c->x, c->y);      
  client_deliver_config(dock, c);

  XSync(dock->dpy, False);

  if ((c->x+c->w) > (dock->w+SCROLL_ACTIVATE_SENSITIVITY) 
      && !dock->scroll_active)
    {
      XLowerWindow(dock->dpy, c->win);
      dock_activate_scroll(dock);
    }
}

#endif
