#ifndef _MBUTIL_H_
#define _MBUTIL_H_

/* libmb
 * Copyright (C) 2002 Matthew Allum
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <signal.h>
#include <errno.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

/* Exec a command like the shell would */
int mb_exec (char *cmd);

/* Get window ID of app with specified binary name */
Window mb_single_instance_get_window(Display *dpy, char *bin_name);

/* Test to see if an app is in 'startup' phase */
Bool mb_single_instance_is_starting(Display *dpy, char *bin_name);

/* Raise an already running window */
void mb_util_window_activate(Display *dpy, Window win);

/* Get root pixmap if set */
Pixmap mb_util_get_root_pixmap(Display *dpy);

/* Get a full theme path from its name */
char *mb_util_get_theme_full_path(char *theme_name);


#endif
