/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/


#include "desktop_client.h"

Client*
desktop_client_new(Wm *w, Window win)
{

   client *c = base_client_new(w, win); 
   c->type = desktop;
   c->configure    = &desktop_client_configure;
   c->reparent     = &desktop_client_reparent;
   c->move_resize  = &desktop_client_move_resize;
   c->get_coverage = &desktop_client_get_coverage;
   c->show         = &desktop_client_show;

   return c;
}

void
desktop_client_reparent(Client *c)
{
   c->frame = c->window;
}

void
desktop_client_move_resize(Client *c)
{
   XMoveResizeWindow(c->wm->dpy, c->window, c->x, c->y, c->width, c->height );
}

void
desktop_client_get_coverage(Client *c, int *x, int *y, int *w, int *h)
{
   *x = 0; *y = 0;*w = 0;*h = 0;
}

void
desktop_client_configure(Client *c)
{   
   c->width = c->wm->dpy_width;
   c->height = c->wm->dpy_height;

   c->x = 0;
   c->y = 0;

}

void
desktop_client_show(Client *c)
{
   XLowerWindow(c->wm->dpy, c->window);
   XMapWindow(c->wm->dpy, c->window);

   if (client_want_focus(c))
   {
     dbg("Desktop setting focus\n");
      XSetInputFocus(c->wm->dpy, c->window,
		     RevertToPointerRoot, CurrentTime);
      c->wm->focused_client = c;
   }

}

