/* matchbox - a lightweight window manager

   Copyright 2002 Matthew Allum

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
*/

#ifndef _MAIN_CLIENT_H_
#define _MAIN_CLIENT_H_

#include <stdio.h>
#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>

#include "structs.h"
#include "base_client.h"
#include "wm.h"
#include "main_client.h"
#include "misc.h"
#include "select_client.h"

#define TITLE_HIDDEN_SZ 4

client* main_client_new(struct _wm *w, Window win);
void main_client_check_for_state_hints(Client *c);
void main_client_check_for_single(Client *c);
void main_client_init(client *c);
void main_client_configure(client *c);
void main_client_reparent(client *c);
void main_client_redraw(client *c, Bool use_cache);
void main_client_button_press(client *c, XButtonEvent *e);
void main_client_move_resize(client *c);
void main_client_destroy(Client *c);


int _theight(client *c); /* title bar height */
int main_client_total_height(client *c);
client* _get_prev_normal(client *c);
client* _get_next_normal(client *c);
client *main_client_has_transient(client *c);
void main_client_iconize(client *c);
void main_client_uniconize(client *c);

/* new */
int main_client_title_height(Client *c);
void main_client_get_coverage(Client *c, int *x, int *y, int *w, int *h);
void main_client_hide(Client *c);
void main_client_show(Client *c);
void main_client_toggle_title_bar(Client *c);

void main_client_toggle_fullscreen(Client *c);

#endif
