/* 
vcard test file generator
(c) 2003 kernel concepts 
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
        
#define P_TEXT "abcdefghijklmnopqrstuvwxyz"
#define P_NR "01234567890-/+"
#define NUM_CARDS 100
#define NAME_MIN 4
#define NAME_MAX 20
#define NUM_MIN 4
#define NUM_MAX 10
#define MAIL_MIN 7
#define MAIL_MAX 32

int 
main(int argc, char *argv[])
{
	FILE *fd;
	char fn[30];
	char name[NAME_MAX+1];
	int namelen;
	char vname[NAME_MAX+1];
	int vnamelen;
	char phone[NUM_MAX+1];
	int phonelen;
	char mail[MAIL_MAX+1];
	int maillen;
	int i,j;
	
	for (i=0;i<NUM_CARDS;i++)
	{
		sprintf(fn,"vcard%03i.vcf",i);
		fd = fopen(fn,"w+");
		namelen = rand() % ((NAME_MAX-NAME_MIN) + NAME_MIN);
		for (j=0;j<namelen;j++)
		{
			name[j] = P_TEXT[rand()%strlen(P_TEXT)];
		}
		name[namelen] = 0;
		vnamelen = rand() % ((NAME_MAX-NAME_MIN) + NAME_MIN);
		for (j=0;j<vnamelen;j++)
		{
			vname[j] = P_TEXT[rand()%strlen(P_TEXT)];
		}
		vname[vnamelen] = 0;
		phonelen = rand() % ((NUM_MAX-NUM_MIN) + NUM_MIN);
		for (j=0;j<phonelen;j++)
		{
			phone[j] = P_NR[rand()%strlen(P_NR)];
		}
		phone[phonelen] = 0;
		maillen = rand() % ((MAIL_MAX-MAIL_MIN) + MAIL_MIN);
		for (j=0;j<maillen;j++)
		{
			mail[j] = P_TEXT[rand()%strlen(P_TEXT)];
		}
		mail[maillen] = 0;
		mail[rand()%(maillen-1)+1] = '@';
		fprintf(fd,"BEGIN:VCARD\n");
		fprintf(fd,"VERSION:2.1\n");
		fprintf(fd ,"N:%s;%s;;;\n",name,vname);
		fprintf(fd,"ADR;WORK:;;Dreisbachstrasse 24;Netphen;;57250;Germany\n");
		fprintf(fd,"TEL;VOICE:%s\n",phone);
		fprintf(fd,"EMAIL;INTERNET:%s\n",mail);
		fprintf(fd,"END:VCARD\n");
		fclose(fd);
	}
	return 0;
}


    