/*
 *  Copyright (C) 2004 Luca De Cicco <ldecicco@gmx.net> 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *
 */

#include "day_render.h"
#include <gpe/event-db.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <langinfo.h>
#include <time.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>

#define event_ends(event) ((event)->start + (event)->duration)
//Constructor of caption object
#define caption_new(height) caption_with_pango_new((height),NULL)

//Constructor of caption specifing pango layout
caption_t caption_with_pango_new(guint height, PangoLayout *pl){
	caption_t this;
	PangoLayout *p_layout;
	PangoContext *p_context;
	
	if(pl !=NULL){
		this -> pl = pl;
	}else{
		p_context = pango_context_new();
		p_layout = pango_layout_new(p_context);
		this -> pl = p_layout;
	}
	this -> height = height;
	return this;
}

void caption_set_pango(caption_t this, PangoLayout *pl){
	this->pl = pl;
}

void caption_show(caption_t capt, GdkDrawable *draw){
	
}

//Constructor of day_render object
struct day_render*
day_render_new(GdkDrawable *drawable_area,
		GdkGC *app_gc,
		GdkGC *overl_gc,
		GTime date,
		guint width,
		guint height, 
		guint cols,
		guint gap,
		GdkPoint offset,
		GSList *events)
{
	
	struct day_render *this;
	
	if(height <= 0 || width <= 0 || cols <=0 || drawable_area == NULL){
		return NULL;
	}
	
	this = (struct day_render*)g_malloc(sizeof(struct day_render));
	this->draw = drawable_area;
	this->date = date;
	this->width = width;
	this->height = height;
	this->cols = cols;
	this->rows = 24/cols;
	this->gap = gap;
	this->events = events;
	this-> dx = width/cols;
	this-> dy = (height)/this->rows;
	this-> normal_gc = app_gc;
	this-> ol_gc = overl_gc;
	this-> offset = offset;
	return this;
}

//Returns true if event started today.
gboolean event_starts_today(struct day_render *dr,event_t ev){
	GTime today,tomorrow;
		
	today = dr->date;
	tomorrow = today + 60*60*24;
	printf("Today: %d Tomorrow:%d Event start: %d\n", today,tomorrow, ev->start);
	if( ev->start <= tomorrow && ev->start >= today){
		return TRUE;
	}else{
		return FALSE;
	}
}

//True if event ends today.
gboolean event_ends_today(struct day_render *dr, event_t ev){
	GTime today, tomorrow;
	today = dr->date;
	tomorrow = today + 60*60*24;
	if( ev->start + ev->duration <= tomorrow){
		return TRUE	;
	}else{
		return FALSE;
	}
	
}

GSList *day_render_find_overlapping(GSList *events){
	GSList *iter1, *iter2;
	GSList *ol_list=NULL; 
	event_t ol_event,ev1,ev2;
	
	for (iter1 = events; iter1; iter1 = iter1->next){
		for(iter2 = iter1->next ; iter2 ; iter2 = iter2->next){
				ev1 = iter1->data;
				ev2 = iter2->data;
				if(ev2->start >= ev1->start && ev2->start <= ev1->start + ev1->duration){
					struct tm a,b;
					printf("collisione : %d-%d\n",ev1->start, ev2->start);
					if(event_ends(ev2) < event_ends(ev1)){
						
						localtime_r(&(ev2->start),&a);
						
						//localtime_r(&((time_t)event_ends(ev2)),&b);
						
						printf("Intervallo collisione(tc): %d:%d-%d:%d\n", a.tm_hour,a.tm_min,b.tm_hour,b.tm_min);
						
						ol_list = g_slist_append(ol_list,ev2);									
						
					}else{
						localtime_r(&(ev2->start),&a);
						//localtime_r(&(event_ends(ev1)),&b);
						printf("Intervallo collisione: %d:%d-%d:%d\n", a.tm_hour,a.tm_min,b.tm_hour,b.tm_min);
						ol_event = (event_t)g_malloc(sizeof(event_t));
						ol_event->start = ev2->start;
						ol_event->duration = event_ends(ev1) - (guint)(ev2->start);
						ol_list = g_slist_append(ol_list,ol_event);
					}
					
				}
		}

	}
	return ol_list;
}


//Returns where the event starts (x,y and row number)
row_t day_render_event_starts(struct day_render *dr, event_t event){
	row_t start;
	start = (row_t)malloc(sizeof(row_t));
	if(event_starts_today(dr, event)){
		struct tm time;
		GdkPoint point;
		
		localtime_r (&(event->start), &time);
		printf("Time: %d:%d\n",time.tm_hour,time.tm_min);
		point.x = (time.tm_hour % dr->cols) * dr->dx + dr->gap;
		point.y = (time.tm_hour / dr->cols) * dr->dy + dr->gap;
		printf("Start Point (%d,%d)\n",point.x,point.y);
		start->row_num = time.tm_hour / dr->cols;
		start->point = point;
	
	}else{
		//Event doesn't start today, so for today it starts since 00:00
		printf("Event doesn't start today!!!\n");
		(start->point).x = 0;
		(start->point).y = dr->gap;
		start->row_num = 0;
	}
	printf("Start: (%d , %d) - Row #%d\n",(start->point).x,(start->point).y + dr->offset.y,start->row_num);
	return start;
}


//Render an event with gc color. Note that also an overlapping event is rendered
//with this function.
void day_render_event_show(struct day_render *dr, event_t event, GdkGC *gc){
	row_t start ;
	guint height, width;
	GdkPoint offset = dr->offset;
	
	height = dr->dy;
	start = day_render_event_starts(dr,event);
	
	if(!event_ends_today(dr,event)&&0){
		int i;
		//I got to fill up whole rows starting from "start" point
		//I draw the first rectangle (first row)
		
		width = dr->width - (start->point).x;	
		gdk_draw_rectangle(dr->draw, gc, TRUE, (start->point).x + offset.x, (start->point).y + offset.y +dr->gap, width, dr->dy-dr->gap);			

		for( i = start->row_num  ; i < dr->rows ; i++){
			//Draw remaining rows - start -> row_num rectangle...
			gdk_draw_rectangle(dr->draw,gc, TRUE, offset.x, offset.y + i*dr->dy + dr->gap,dr->width, dr->dy-dr->gap);
		}
	}else{
		guint length;
		if(!event_starts_today(dr,event)){
			length = (guint)(((float)event->start+(float)event->duration - (float)dr->date ) / 3600.0 * (float)dr->dx);
			printf("duration: %f\n",(float)length/(float)dr->dx);
		}else{
			length = (guint)(((float)event->duration ) / 3600.0 * (float)dr->dx);
		}
	
		printf("Total lenght is: %d - start point: %d\n", length + (start->point).x , (start->point).x);
		if(length + (start->point).x < dr->width){
			//It fits in a row...
			printf("IT FITS in a row!\n\n");
			gdk_draw_rectangle(dr->draw, gc, TRUE, (start->point).x + offset.x, (start->point).y + offset.y + dr->gap, length, dr->dy-dr->gap);						
		}else{
			//Draw first rectangle
			int i=start->row_num + 1;
			guint reminder =0 ;	
			printf("Drawing fist rectangle row #%d - y:%d \n",start->row_num,(start->point).y + offset.y);
			gdk_draw_rectangle(dr->draw, gc, TRUE, (start->point).x + offset.x, (start->point).y + offset.y, dr->width - (start->point).x, dr->dy-dr->gap);					
			reminder = length - ( dr->width - (start->point).x); 
			printf("Lenght: %d - reminder: %d - width: %d\n", length, reminder , dr->width);
			
			while((reminder > dr->width) && reminder > 0 ){
				printf("Drawing on row #%d. y: %d\n",i,offset.y + i*dr->dy +dr->gap);
				gdk_draw_rectangle(dr->draw,gc, TRUE, offset.x, offset.y + i*dr->dy +dr->gap,dr->width, dr->dy-dr->gap);			
				reminder -=dr->width;
				
				++i;
				if(i > dr->rows){
					break;
				}
			}
			if(i<=dr->rows){
				printf("Drawing last rectangle. Row #%d - y: %d\n",i,offset.y + i*dr->dy +dr->gap);
				printf("Widh: %d\n",reminder);
				gdk_draw_rectangle(dr->draw,gc, TRUE, offset.x , offset.y + i*dr->dy + dr->gap,reminder, dr->dy-dr->gap);			
			}
		}
		
	}
}

//Renders day caption
void day_render_caption_show(struct day_render *dr){
	//Fill me	
	
}

//Show day with events and stuff.
void day_render_events_show(struct day_render *dr, GSList *events,GdkGC *gc ){
	GSList *iter;
	
	for (iter = events; iter; iter = iter->next){
		printf("-------\n");
		day_render_event_show(dr,iter->data,gc);
		
	}
}

//Renders day element...
void day_render_show(struct day_render *dr){
	GSList *ol_list;
	day_render_caption_show(dr);
	//shows events if any...
	if(dr->events !=NULL)
		day_render_events_show(dr,dr->events ,dr->normal_gc);
	
	//shows overlapping areas if any...
	ol_list = day_render_find_overlapping(dr->events);
	if(ol_list!=NULL){
		day_render_events_show(dr, ol_list, dr->ol_gc);
	}
}
