/*
 *  Copyright (C) 2004 Luca De Cicco <ldecicco@gmx.net> 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *
 */

#ifndef DAY_RENDER_H
#define DAY_RENDER_H

#include <glib.h>
#include <time.h>
#include <gtk/gtk.h>

struct day_render {
	//Add Caption...
	GdkDrawable *draw;
	GdkGC *normal_gc;	//Normal event color
	GdkGC *ol_gc;	//Overlapping areas color
	guint width;	//rectangle width
	guint height;	//rectangle height
	guint cols;		//Number of columns, i.e. how many hours in a row.
	guint rows;		
	guint gap;		//Define gap...
	GTime date;  	//Date of this day
	guint dx;
	guint dy;
	GdkPoint offset;
	GSList *events;	//Events associated to this day.
};

typedef struct row {
	GdkPoint point;
	guint row_num;
	
} *row_t;

typedef struct caption {
	guint height;
	PangoLayout *pl;
	//Other stuff here...
	
} *caption_t ;

struct day_render*
day_render_new(GdkDrawable *drawable_area,GdkGC *normal_gc, GdkGC *ol_gc, GTime date,guint width,
				guint height, guint cols,guint gap,	GdkPoint offset, GSList *events);

void
day_render_show(struct day_render *dr);


#endif /* DAY_RENDER_H */
