/*
 * gpe-mini-browser v0.16
 *
 * Basic web browser based on gtk-webcore 
 * 
 * Misc calls.
 *
 * Copyright (c) 2005 Philippe De Swert
 *
 * Contact : philippedeswert@scarlet.be
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stddef.h>

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <webi.h>

#include <gdk/gdk.h>

#include <glib.h>
#include <gpe/init.h>
#include <gpe/errorbox.h>
#include <gpe/question.h>

#include "gpe-mini-browser.h"

//#define DEBUG /* uncomment this if you want debug output*/

void
set_default_settings (Webi * html, WebiSettings * ks)
{
  const gchar *http_proxy;

  ks->default_font_size = 11;
  ks->default_fixed_font_size = 11;
  ks->minimum_font_size = 7;
  ks->serif_font_family = "serif";
  ks->sans_serif_font_family = "sans";
  ks->fixed_font_family = "sans";
  ks->standard_font_family = "sans";
  ks->autoload_images = 1;
  ks->javascript_enabled = 1;

  http_proxy = g_getenv ("http_proxy");
  if (!http_proxy)
    http_proxy = g_getenv ("HTTP_PROXY");
  if (!http_proxy)
    {
      http_proxy = "";
    }
  ks->http_proxy = g_strdup (http_proxy);

  webi_set_settings (WEBI (html), ks);
}

void
zoom_in (GtkWidget * zoom_in, gpointer * data)
{
  struct zoom_data *zoom;
  WebiSettings *set;

  zoom = (struct zoom_data *) data;
  set = zoom->settings;
  set->default_font_size++;
  set->default_fixed_font_size++;
  webi_set_settings (WEBI (zoom->html), set);
}

void
zoom_out (GtkWidget * zoom_out, gpointer * data)
{
  struct zoom_data *zoom;
  WebiSettings *set;

  zoom = (struct zoom_data *) data;
  set = zoom->settings;
  set->default_font_size--;
  set->default_fixed_font_size--;
  webi_set_settings (WEBI (zoom->html), set);
}

void
delete_bookmarks (GtkWidget * button, gpointer * data)
{
  if (gpe_question_ask ("Really delete this bookmark or category?", "Delete?",
			"question", "!gtk-cancel", NULL,
			"!gtk-delete", NULL, NULL) == 1)
    {
        GtkTreeSelection *selection;
        GtkTreeModel *model;
        GtkTreeIter iter;
        gchar *url;

        selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(data));
        model = gtk_tree_view_get_model (GTK_TREE_VIEW(data));

        if (gtk_tree_selection_get_selected(selection, &model, &iter))
        {
                gtk_tree_model_get(model, &iter, 0, &url, -1);
#ifdef DEBUG
		printf("Deleting url %s\n",url);
#endif

	//delete from db
	int err = remove_bookmark(url);
	if (err)
		gpe_error_box("error removing bookmark from db!\n");
	//delete from list or refresh list when db backend is in
		gtk_list_store_remove (GTK_LIST_STORE(model), &iter);
        }
    }
}

void
open_bookmarks (GtkWidget * button, gpointer * data)
{
	struct tree_action *open_data;
	GtkTreeSelection *selection; 
	GtkTreeModel *model;
	GtkTreeIter iter;
	gchar *url;

	open_data = (struct tree_action *)data;
	
	selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(open_data->treeview));
	model = gtk_tree_view_get_model (GTK_TREE_VIEW(open_data->treeview));

	if (gtk_tree_selection_get_selected(selection, &model, &iter))
	{
		gtk_tree_model_get(model, &iter, 0, &url, -1);
		url = (gchar *)parse_url(url);
#ifdef DEBUG
		printf("The selected url = %s\n", url);
#endif
		fetch_url(url, GTK_WIDGET(open_data->html));
		g_free(url);
	}
	else
	{
	 gpe_error_box("No bookmark selected!");
	}
}

void
toggle_type (GtkWidget * button, gpointer * data)
{
  struct bookmark_add *test;

  test = (struct bookmark_add *) data;

  if (test->bookmark_type)
    test->bookmark_type = 0;
  else
    test->bookmark_type = 1;
}

void add_bookmark_func (GtkWidget *button, gpointer *data)
{
	struct bookmark_add *info;
	GtkTreeModel *model;
        GtkTreeIter iter;
	const gchar *location;
	
	info = (struct bookmark_add *) data;

        model = gtk_tree_view_get_model (GTK_TREE_VIEW(info->treeview));

	if (info->bookmark_type == 0)
	{
      		location = webi_get_location (info->html);	
	}
	else
	{
		location = gtk_editable_get_chars (GTK_EDITABLE (info->entry), 0, -1);
	}
#ifdef DEBUG
		printf("bookmark value is %s\n", location);
#endif
		if(location != NULL)
                {
                // add to database
		int err = insert_new_bookmark((char *)location);
		if (err)
			gpe_error_box("Error accessing db!\n");
                gtk_list_store_append(GTK_LIST_STORE(model), &iter);
                gtk_list_store_set(GTK_LIST_STORE(model), &iter, 0, location, -1);
                }
		else
                {
                        gpe_error_box("No url filled in!\n");
                }


}
