PREFIX = /usr/local
PACKAGE = gpe-plucker
DEBUG = no
CVSBUILD = yes
GST = yes
VERSION = 0.1

MEMBERS = gpe-plucker

PACKAGE_CFLAGS = -Iunpluck/ -DUSE_GPE -D_GNU_SOURCE -Wall
ifeq ($(DEBUG),yes)
PAKAGE_CFLAGS += -O2 -g
PACKAGE_LDFLAGS = -g 
else
PACKAGE_CFLAGS += -Os -fomit-frame-pointer
endif
PACKAGE_CPPFLAGS += -DPACKAGE=\"$(PACKAGE)\" -DPREFIX=\"$(PREFIX)\" -DPACKAGE_LOCALE_DIR=\"$(PREFIX)/share/locale\"

PACKAGE_CFLAGS += $(STANDARD_CFLAGS) $(GTKCFLAGS) $(GPECFLAGS)
PACKAGE_LDFLAGS += $(STANDARD_LIBS) $(GPELIBS) $(GTKLIBS)

PACKGE_LDFLAGS += -Lunpluck/ -lunpluck -lz


ifeq ($(CVSBUILD),yes)
BUILD = ../build
else
BUILD = build
endif
SOURCES = image.c library.c viewer.c
OBJS = ${SOURCES:.c=.o}

all: unpluck $(PACKAGE)

unpluck:
	(make -C unpluck)

$(PACKAGE): $(OBJS) $(LIB)
	$(CC) -o $@ $^ $(LDFLAGS) $(PACKAGE_LDFLAGS)

install-program: all $(PACKAGE).desktop
	mkdir -p $(DESTDIR)$(PREFIX)/bin
	install -s $(PACKAGE) $(DESTDIR)$(PREFIX)/bin/$(PACKAGE)
	mkdir -p $(DESTDIR)$(PREFIX)/share/pixmaps
	install -m 644 $(PACKAGE).png $(DESTDIR)$(PREFIX)/share/pixmaps/$(PACKAGE).png
	#mkdir -p $(DESTDIR)$(PREFIX)/share/$(PACKAGE)
	#install -m 644 pixmaps/*.png $(DESTDIR)$(PREFIX)/share/$(PACKAGE)/
	mkdir -p $(DESTDIR)$(PREFIX)/share/applications
	install -m 644 $(PACKAGE).desktop $(DESTDIR)$(PREFIX)/share/applications

clean:
	rm -f $(PACKAGE) $(OBJS) $(PACKAGE).desktop *.ipk
	rm -rf familiar/dist

include $(BUILD)/Makefile.translation
include $(BUILD)/Makefile.dpkg_ipkg
