/* OptionMenu.c */
#include <gtk/gtk.h>

void main(int argc, char *argv[])
{
  GtkWidget *Fenetre;
  GtkWidget *OptionMenu;
  GtkWidget *Menu;
  GtkWidget *MenuItem;

  /* Initialisation des bibliothques */
  gtk_init(&argc, &argv);

  /* Cration de la fentre de dialogue */
  Fenetre = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_container_set_border_width(GTK_CONTAINER(Fenetre), 5);
  /* Connection des signaux "delete" et "destroy" */
  gtk_signal_connect(GTK_OBJECT(Fenetre), "delete_event",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  gtk_signal_connect(GTK_OBJECT(Fenetre), "destroy",
                     (GtkSignalFunc)gtk_exit,
                     NULL);
  /* Cration du menu  */
  Menu = gtk_menu_new();
  /* L'option 1 */
  MenuItem = gtk_menu_item_new_with_label("option 1");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_widget_show(MenuItem);
  /* L'option 2 */
  MenuItem = gtk_menu_item_new_with_label("option 2");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_widget_show(MenuItem);
  /* L'option 3 */
  MenuItem = gtk_menu_item_new_with_label("option 3");
  gtk_menu_append(GTK_MENU(Menu), MenuItem);
  gtk_widget_show(MenuItem);
  /* L'option menu */
  OptionMenu = gtk_option_menu_new();
  gtk_container_add(GTK_CONTAINER(Fenetre), OptionMenu);
  /* Attachement du menu au bouton */
  gtk_option_menu_set_menu(GTK_OPTION_MENU(OptionMenu),
                           Menu);
  /* On choisit la valeur par dfaut */
  gtk_option_menu_set_history(GTK_OPTION_MENU(OptionMenu),
                              1);
  /* On affiche le tout */
  gtk_widget_show_all(Fenetre);      

  /* La boucle principale */
  gtk_main();
}
