/*
 * Copyright (C) 2001, 2002, 2003 Philip Blundell <philb@gnu.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 */

#include <libintl.h>
#include <gtk/gtk.h>
#include "gtktimesel.h"

#define _(x) gettext(x)

static guint my_signals[1];

struct _GtkTimeSel
{
  GtkHBox hbox;

  int hour, minute;
  
  GtkWidget *hour_spin, *minute_spin;
  GtkWidget *label;
};

struct _GtkTimeSelClass 
{
  GtkHBoxClass parent_class;
};

static GtkHBoxClass *parent_class = NULL;

static void
gtk_time_sel_init (GtkTimeSel *sel)
{
}

static void
gtk_time_sel_show (GtkWidget *widget)
{
  GtkTimeSel *sel;

  g_return_if_fail (widget != NULL);
  g_return_if_fail (GTK_IS_TIME_SEL (widget));

  GTK_WIDGET_CLASS (parent_class)->show (widget);

  sel = GTK_TIME_SEL (widget);
  switch (sel->mode)
    {
    case GTKTIMESEL_FULL:	/* day, month, year */
      show_field (&sel->day);
      show_field (&sel->month);
      break;
    case GTKTIMESEL_WEEK:	/* week, year */
      show_field (&sel->week);
      break;
    case GTKTIMESEL_MONTH:	/* month, year */
      show_field (&sel->month);
      break;
    case GTKTIMESEL_YEAR:	/* year */
      break;
    }
  show_field (&sel->year);
}

static void
gtk_time_sel_class_init (GtkTimeSelClass * klass)
{
  GtkObjectClass *oclass;
  GtkWidgetClass *widget_class;

  parent_class = gtk_type_class (gtk_hbox_get_type ());
  oclass = (GtkObjectClass *) klass;
  widget_class = (GtkWidgetClass *) klass;

  widget_class->show = gtk_time_sel_show;
}

GtkType
gtk_time_sel_get_type (void)
{
  static guint time_sel_type = 0;

  if (! time_sel_type)
    {
      static const GtkTypeInfo time_sel_info =
      {
	"GtkTimeSel",
	sizeof (GtkTimeSel),
	sizeof (GtkTimeSelClass),
	(GtkClassInitFunc) gtk_time_sel_class_init,
	(GtkObjectInitFunc) gtk_time_sel_init,
	/* reserved_1 */ NULL,
	/* reserved_2 */ NULL,
        (GtkClassInitFunc) NULL,
      };
      time_sel_type = gtk_type_unique (gtk_hbox_get_type (), 
				       &time_sel_info);
    }
  return time_sel_type;
}

GtkWidget *
gtk_time_sel_new (void)
{
  GtkWidget *w = GTK_WIDGET (gtk_type_new (gtk_time_sel_get_type ()));
  return w;
}
